/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.gitsetup;

import java.util.Collections;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import org.fuin.devsupwiz.common.DevSupWizFxUtils;
import org.fuin.devsupwiz.common.Loggable;
import org.fuin.devsupwiz.common.SetupController;
import org.fuin.devsupwiz.common.SetupTask;
import org.fuin.devsupwiz.tasks.gitsetup.GitCloneTask;

@Loggable
public class GitCloneController
implements SetupController {
    @FXML
    private ListView<String> repositories;
    @FXML
    private Label title;
    @FXML
    private TextField directory;
    private GitCloneTask task;
    private ObservableList<String> repoList;

    public void init(SetupTask setupTask) {
        if (!(setupTask instanceof GitCloneTask)) {
            throw new IllegalArgumentException("Expected task of type " + GitCloneTask.class.getName() + ", but was: " + setupTask.getClass().getName());
        }
        this.task = (GitCloneTask)setupTask;
        this.repoList = FXCollections.observableArrayList(this.task.getRepositories());
        this.repositories.setItems(this.repoList);
        this.directory.setText(this.task.getTargetDir());
        this.refreshStatus();
    }

    public List<String> getValidationErrors() {
        return Collections.emptyList();
    }

    public void save() {
    }

    public SetupTask getTask() {
        return this.task;
    }

    public void refreshStatus() {
        boolean alreadyExecuted = this.task.alreadyExecuted();
        this.repositories.setDisable(alreadyExecuted);
        this.directory.setDisable(alreadyExecuted);
        if (alreadyExecuted) {
            this.title.setGraphic((Node)DevSupWizFxUtils.createIconOk24x24());
        } else {
            this.title.setGraphic((Node)DevSupWizFxUtils.createIconTodo24x24());
        }
    }
}

