/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.gitsetup;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.io.FileUtils;
import org.fuin.devsupwiz.common.SetupTask;
import org.fuin.devsupwiz.common.ValidateInstance;
import org.fuin.devsupwiz.tasks.gitsetup.PushDefault;
import org.fuin.utils4j.Utils4J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="create-git-config")
public class CreateGitConfigTask
implements SetupTask {
    static final String KEY = "create-git-config";
    private static final Logger LOG = LoggerFactory.getLogger(CreateGitConfigTask.class);
    @NotEmpty
    @XmlAttribute(name="id")
    private String id;
    @NotEmpty(message="{create-git-config.name.empty}")
    @XmlTransient
    private @NotEmpty(message="{create-git-config.name.empty}") String name;
    @NotEmpty(message="{create-git-config.email.empty}")
    @XmlTransient
    private @NotEmpty(message="{create-git-config.email.empty}") String email;
    @NotNull(message="{create-git-config.push-default.empty}")
    @XmlTransient
    private @NotNull(message="{create-git-config.push-default.empty}") PushDefault pushDefault;
    @NotNull(message="configFile==null")
    @XmlTransient
    private @NotNull(message="configFile==null") File configFile;

    protected CreateGitConfigTask() {
        this.configFile = new File(Utils4J.getUserHomeDir(), ".gitconfig");
    }

    public CreateGitConfigTask(@NotEmpty String id, @NotEmpty String name, @NotEmpty String email, @NotNull PushDefault pushDefault) {
        this(id, name, email, pushDefault, new File(Utils4J.getUserHomeDir(), ".gitconfig"));
    }

    public CreateGitConfigTask(@NotEmpty String id, @NotEmpty String name, @NotEmpty String email, @NotNull PushDefault pushDefault, @NotNull File configFile) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.pushDefault = pushDefault;
        this.configFile = configFile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotEmpty String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(@NotEmpty String email) {
        this.email = email;
    }

    public PushDefault getPushDefault() {
        return this.pushDefault;
    }

    public void setPushDefault(@NotNull PushDefault pushDefault) {
        this.pushDefault = pushDefault;
    }

    public boolean alreadyExecuted() {
        return this.configFile.exists();
    }

    @ValidateInstance
    public void execute() {
        block5: {
            MDC.put((String)"task", (String)this.getTypeId());
            try {
                if (this.alreadyExecuted()) break block5;
                String str = "[user]\n\tname = " + this.name + "\n\temail = " + this.email + "\n[push]\n\tdefault = " + this.pushDefault.name().toLowerCase() + "\n";
                try {
                    FileUtils.writeStringToFile((File)this.configFile, (String)str, (Charset)Charset.forName("utf-8"));
                    LOG.info("Successfully create git config: {}", (Object)this.configFile);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Wasn't able to write git config: " + this.configFile, ex);
                }
            }
            finally {
                MDC.remove((String)"task");
            }
        }
    }

    public String getResource() {
        return this.getClass().getPackage().getName().replace('.', '/') + "/" + KEY;
    }

    public String getFxml() {
        return "/" + this.getResource() + ".fxml";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return KEY;
    }

    public String getTypeId() {
        return this.getType() + "[" + this.getId() + "]";
    }
}

