/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.gitsetup;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.Decorator;
import org.controlsfx.control.decoration.GraphicDecoration;
import org.fuin.devsupwiz.common.DevSupWizFxUtils;
import org.fuin.devsupwiz.common.DevSupWizUtils;
import org.fuin.devsupwiz.common.Loggable;
import org.fuin.devsupwiz.common.SetupController;
import org.fuin.devsupwiz.common.SetupTask;
import org.fuin.devsupwiz.tasks.gitsetup.CreateGitConfigTask;
import org.fuin.devsupwiz.tasks.gitsetup.PushDefault;

@Loggable
public class CreateGitConfigController
implements Initializable,
SetupController {
    @FXML
    private TextField name;
    @FXML
    private TextField email;
    @FXML
    private ComboBox<String> pushDefault;
    @FXML
    private Label title;
    @Inject
    private Validator validator;
    private CreateGitConfigTask task;

    public void init(SetupTask task) {
        if (!(task instanceof CreateGitConfigTask)) {
            throw new IllegalArgumentException("Expected task of type " + CreateGitConfigTask.class.getName() + ", but was: " + task.getClass().getName());
        }
        this.task = (CreateGitConfigTask)task;
        this.refreshStatus();
    }

    public void initialize(URL location, ResourceBundle resources) {
        for (PushDefault value : PushDefault.values()) {
            this.pushDefault.getItems().add((Object)value.name().toLowerCase());
        }
        this.pushDefault.setValue((Object)PushDefault.SIMPLE.name().toLowerCase());
    }

    public List<String> getValidationErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.task.alreadyExecuted()) {
            String selected = ((String)this.pushDefault.getValue()).toUpperCase();
            CreateGitConfigTask t = new CreateGitConfigTask("x", (String)this.name.textProperty().get(), (String)this.email.textProperty().get(), PushDefault.valueOf(selected));
            Set violations = this.validator.validate((Object)t, new Class[0]);
            for (ConstraintViolation violation : violations) {
                errors.add(violation.getMessage());
            }
            Decorator.removeAllDecorations((Node)this.name);
            if (DevSupWizUtils.violated((Set)violations, (String)this.name.getId())) {
                Decorator.addDecoration((Node)this.name, (Decoration)new GraphicDecoration((Node)DevSupWizFxUtils.createIconError16x16(), Pos.TOP_RIGHT));
            }
            Decorator.removeAllDecorations((Node)this.email);
            if (DevSupWizUtils.violated((Set)violations, (String)this.email.getId())) {
                Decorator.addDecoration((Node)this.email, (Decoration)new GraphicDecoration((Node)DevSupWizFxUtils.createIconError16x16(), Pos.TOP_RIGHT));
            }
        }
        return errors;
    }

    public void save() {
        this.task.setName(this.name.getText());
        this.task.setEmail(this.email.getText());
        String selected = ((String)this.pushDefault.getValue()).toUpperCase();
        this.task.setPushDefault(PushDefault.valueOf(selected));
    }

    public SetupTask getTask() {
        return this.task;
    }

    public void refreshStatus() {
        boolean alreadyExecuted = this.task.alreadyExecuted();
        this.name.setDisable(alreadyExecuted);
        this.email.setDisable(alreadyExecuted);
        this.pushDefault.setDisable(alreadyExecuted);
        if (alreadyExecuted) {
            this.title.setGraphic((Node)DevSupWizFxUtils.createIconOk24x24());
        } else {
            this.title.setGraphic((Node)DevSupWizFxUtils.createIconTodo24x24());
        }
    }
}

