/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.hostname;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.fuin.devsupwiz.common.LogOutputStream;
import org.fuin.devsupwiz.common.SetupTask;
import org.fuin.devsupwiz.common.ShellCommandExecutor;
import org.fuin.devsupwiz.common.ValidateInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.event.Level;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="set-hostname")
public class SetHostnameTask
implements SetupTask {
    static final String KEY = "set-hostname";
    private static final Logger LOG = LoggerFactory.getLogger(SetHostnameTask.class);
    @XmlTransient
    private Preferences userPrefs = Preferences.userRoot();
    @NotEmpty
    @XmlAttribute(name="id")
    private String id;
    @Pattern(regexp="[a-z][a-z0-9\\-]*", message="{set-hostname.pattern}")
    @NotEmpty(message="{set-hostname.empty}")
    @XmlTransient
    private @Pattern(regexp="[a-z][a-z0-9\\-]*", message="{set-hostname.pattern}") @NotEmpty(message="{set-hostname.empty}") String name;

    protected SetHostnameTask() {
    }

    public SetHostnameTask(@NotEmpty String id, @NotEmpty String name) {
        this.id = id;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotEmpty String name) {
        this.name = name;
    }

    public boolean alreadyExecuted() {
        return this.userPrefs.getBoolean(this.getPrefKey(), false);
    }

    private String getPrefKey() {
        return this.getType() + "-" + this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidateInstance
    public void execute() {
        block5: {
            MDC.put((String)"task", (String)this.getTypeId());
            try {
                ShellCommandExecutor executor;
                int result;
                if (this.alreadyExecuted() || (result = (executor = new ShellCommandExecutor("hostnamectl set-hostname '" + this.name + "'", 5L, new HashMap(), (OutputStream)new LogOutputStream(Level.INFO), (OutputStream)new LogOutputStream(Level.ERROR))).execute()) != 0) break block5;
                try {
                    this.userPrefs.putBoolean(this.getPrefKey(), true);
                    this.userPrefs.flush();
                }
                catch (BackingStoreException ex) {
                    throw new RuntimeException("Failed to save the setup key '" + this.getPrefKey() + "'", ex);
                }
                LOG.info("Successfully set the host name to '{}'", (Object)this.name);
            }
            finally {
                MDC.remove((String)"task");
            }
        }
    }

    public String getResource() {
        return this.getClass().getPackage().getName().replace('.', '/') + "/" + KEY;
    }

    public String getFxml() {
        return "/" + this.getResource() + ".fxml";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return KEY;
    }

    public String getTypeId() {
        return this.getType() + "[" + this.getId() + "]";
    }
}

