/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.hostname;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.Decorator;
import org.controlsfx.control.decoration.GraphicDecoration;
import org.fuin.devsupwiz.common.DevSupWizFxUtils;
import org.fuin.devsupwiz.common.DevSupWizUtils;
import org.fuin.devsupwiz.common.Loggable;
import org.fuin.devsupwiz.common.SetupController;
import org.fuin.devsupwiz.common.SetupTask;
import org.fuin.devsupwiz.tasks.hostname.SetHostnameTask;

@Loggable
public class SetHostnameController
implements SetupController {
    @FXML
    private TextField name;
    @FXML
    private Label title;
    @Inject
    private Validator validator;
    private SetHostnameTask task;

    public void init(SetupTask task) {
        if (!(task instanceof SetHostnameTask)) {
            throw new IllegalArgumentException("Expected task of type " + SetHostnameTask.class.getName() + ", but was: " + task.getClass().getName());
        }
        this.task = (SetHostnameTask)task;
        this.refreshStatus();
    }

    public List<String> getValidationErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.task.alreadyExecuted()) {
            this.name.setText(this.name.getText().toLowerCase());
            SetHostnameTask t = new SetHostnameTask("x", this.name.getText());
            Set violations = this.validator.validate((Object)t, new Class[0]);
            for (ConstraintViolation violation : violations) {
                errors.add(violation.getMessage());
            }
            Decorator.removeAllDecorations((Node)this.name);
            if (DevSupWizUtils.violated((Set)violations, (String)this.name.getId())) {
                Decorator.addDecoration((Node)this.name, (Decoration)new GraphicDecoration(this.createErrorNode(), Pos.TOP_RIGHT));
            }
        }
        return errors;
    }

    private Node createErrorNode() {
        return new ImageView(new Image("/error-16x16.png"));
    }

    public void save() {
        this.task.setName(this.name.getText());
    }

    public SetupTask getTask() {
        return this.task;
    }

    public void refreshStatus() {
        boolean alreadyExecuted = this.task.alreadyExecuted();
        this.name.setDisable(alreadyExecuted);
        if (alreadyExecuted) {
            this.title.setGraphic((Node)DevSupWizFxUtils.createIconOk24x24());
        } else {
            this.title.setGraphic((Node)DevSupWizFxUtils.createIconTodo24x24());
        }
    }
}

