/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.gitsetup;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import javax.validation.constraints.NotEmpty;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public final class SshKeyPairGenerator {
    private final String user;
    private final KeyPair keyPair;
    private final String privateKey;
    private final String publicKey;

    public SshKeyPairGenerator(@NotEmpty String user) {
        this.user = user;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(2048);
            this.keyPair = kpg.generateKeyPair();
            this.privateKey = SshKeyPairGenerator.createPrivate(this.keyPair);
            this.publicKey = SshKeyPairGenerator.createPublic(this.keyPair, user);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new RuntimeException("Failed to generate a key pair for SSH", ex);
        }
    }

    public final String getUser() {
        return this.user;
    }

    public final KeyPair getKeyPair() {
        return this.keyPair;
    }

    public final String getPrivateKey() {
        return this.privateKey;
    }

    public final String getPublicKey() {
        return this.publicKey;
    }

    private static String encodePublicKey(RSAPublicKey key) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] sshrsa = new byte[]{0, 0, 0, 7, 115, 115, 104, 45, 114, 115, 97};
        out.write(sshrsa);
        BigInteger e = key.getPublicExponent();
        byte[] exponent = e.toByteArray();
        out.write(SshKeyPairGenerator.encodeUInt32(exponent.length));
        out.write(exponent);
        BigInteger m = key.getModulus();
        byte[] modulus = m.toByteArray();
        out.write(SshKeyPairGenerator.encodeUInt32(modulus.length));
        out.write(modulus);
        byte[] bytes = out.toByteArray();
        return new String(Base64.getEncoder().encode(bytes), Charset.forName("us-ascii"));
    }

    private static byte[] encodeUInt32(int value) {
        byte[] tmp = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return tmp;
    }

    private static String createPublic(KeyPair keyPair, String user) {
        try {
            RSAPublicKey key = (RSAPublicKey)keyPair.getPublic();
            return "ssh-rsa " + SshKeyPairGenerator.encodePublicKey(key) + " " + user;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String createPrivate(KeyPair keyPair) {
        try {
            StringWriter strWriter = new StringWriter();
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)strWriter);){
                pemWriter.writeObject((Object)keyPair.getPrivate());
            }
            return strWriter.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

