/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.gitsetup;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Provider;
import java.security.Security;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.fuin.devsupwiz.common.DevSupWizUtils;
import org.fuin.devsupwiz.common.SetupTask;
import org.fuin.devsupwiz.common.ValidateInstance;
import org.fuin.devsupwiz.tasks.gitsetup.GitProvider;
import org.fuin.devsupwiz.tasks.gitsetup.SshKeyPairGenerator;
import org.fuin.utils4j.Utils4J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="setup-git-ssh")
public class SetupGitSshTask
implements SetupTask {
    static final String KEY = "setup-git-ssh";
    private static final Logger LOG = LoggerFactory.getLogger(SetupGitSshTask.class);
    @NotEmpty
    @XmlAttribute(name="id")
    private String id;
    @NotEmpty(message="{setup-git-ssh.name.empty}")
    @XmlTransient
    private @NotEmpty(message="{setup-git-ssh.name.empty}") String name;
    @NotEmpty(message="{setup-git-ssh.password.empty}")
    @XmlTransient
    private @NotEmpty(message="{setup-git-ssh.password.empty}") String password;
    @NotNull(message="{setup-git-ssh.provider.null}")
    @XmlAttribute(name="provider")
    private @NotNull(message="{setup-git-ssh.provider.null}") String provider;
    @NotEmpty(message="{setup-git-ssh.host.empty}")
    @XmlAttribute(name="host")
    private @NotEmpty(message="{setup-git-ssh.host.empty}") String host;
    @NotNull(message="sshDir==null")
    @XmlTransient
    private @NotNull(message="sshDir==null") File sshDir;
    @XmlTransient
    private boolean postPublicKey;
    @XmlTransient
    private Preferences userPrefs;

    protected SetupGitSshTask() {
        this.sshDir = new File(Utils4J.getUserHomeDir(), ".ssh");
        this.postPublicKey = true;
        this.userPrefs = Preferences.userRoot();
    }

    public SetupGitSshTask(@NotEmpty String id, @NotEmpty String name, @NotEmpty String password, @NotNull GitProvider provider, @NotEmpty String host, boolean postPublicKey) {
        this(id, name, password, provider, host, new File(Utils4J.getUserHomeDir(), ".ssh"), postPublicKey);
    }

    public SetupGitSshTask(@NotEmpty String id, @NotEmpty String name, @NotEmpty String password, @NotNull GitProvider provider, @NotEmpty String host, @NotNull File sshDir, boolean postPublicKey) {
        this.id = id;
        this.name = name;
        this.password = password;
        this.provider = provider.name().toLowerCase();
        this.host = host;
        this.sshDir = sshDir;
        this.postPublicKey = postPublicKey;
        this.userPrefs = Preferences.userRoot();
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotEmpty String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(@NotEmpty String password) {
        this.password = password;
    }

    public GitProvider getProvider() {
        if (this.provider == null) {
            return null;
        }
        return GitProvider.valueOf(this.provider.toUpperCase());
    }

    public void setProvider(@NotNull GitProvider provider) {
        this.provider = provider.name().toLowerCase();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(@NotEmpty String host) {
        this.host = host;
    }

    public boolean alreadyExecuted() {
        return this.userPrefs.getBoolean(this.getPrefKey(), false);
    }

    private String getPrefKey() {
        return this.getType() + "-" + this.getId();
    }

    @ValidateInstance
    public void execute() {
        block10: {
            MDC.put((String)"task", (String)this.getTypeId());
            try {
                if (this.alreadyExecuted()) break block10;
                this.init();
                SshKeyPairGenerator generator = this.generateKeys(this.sshDir, this.getPrivateKeyFile(), this.getPublicKeyFile());
                if (this.postPublicKey) {
                    if (GitProvider.BITBUCKET == this.getProvider()) {
                        this.postPublicKeyToBitbucket(generator.getPublicKey());
                    } else {
                        if (GitProvider.GITHUB == this.getProvider()) {
                            throw new UnsupportedOperationException("Provider " + (Object)((Object)GitProvider.GITHUB) + " is not supported yet");
                        }
                        throw new IllegalStateException("Provider unknown: " + this.provider);
                    }
                }
                this.appendToConfig(this.getPrivateKeyFile());
                if (this.postPublicKey) {
                    DevSupWizUtils.addToSshKnownHosts((String)this.host);
                }
                try {
                    this.userPrefs.putBoolean(this.getPrefKey(), true);
                    this.userPrefs.flush();
                }
                catch (BackingStoreException ex) {
                    throw new RuntimeException("Failed to save the setup key '" + this.getPrefKey() + "'", ex);
                }
                LOG.info("Successfully finished SSH git setup");
            }
            finally {
                MDC.remove((String)"task");
            }
        }
    }

    public String getResource() {
        return this.getClass().getPackage().getName().replace('.', '/') + "/" + KEY;
    }

    public String getFxml() {
        return "/" + this.getResource() + ".fxml";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return KEY;
    }

    public String getTypeId() {
        return this.getType() + "[" + this.getId() + "]";
    }

    private String getKeyFilename() {
        return this.name + "-" + this.host;
    }

    private File getConfigFile() {
        return new File(this.sshDir, "config");
    }

    private File getPrivateKeyFile() {
        return new File(this.sshDir, this.getKeyFilename() + ".prv");
    }

    private File getPublicKeyFile() {
        return new File(this.sshDir, this.getKeyFilename() + ".pub");
    }

    private void init() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (!this.sshDir.exists() && !this.sshDir.mkdirs()) {
            throw new IllegalStateException("Failed to create directory: " + this.sshDir);
        }
    }

    private SshKeyPairGenerator generateKeys(File sshDir, File prvKeyFile, File pubKeyFile) {
        try {
            SshKeyPairGenerator generator = new SshKeyPairGenerator(this.name);
            FileUtils.writeStringToFile((File)prvKeyFile, (String)generator.getPrivateKey(), (Charset)Charset.forName("us-ascii"));
            DevSupWizUtils.setFilePermissions((File)prvKeyFile, (PosixFilePermission[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE});
            FileUtils.writeStringToFile((File)pubKeyFile, (String)generator.getPublicKey(), (Charset)Charset.forName("us-ascii"));
            LOG.info("Successfully generated and saved ssh keys: {} {}", (Object)prvKeyFile, (Object)pubKeyFile);
            return generator;
        }
        catch (IOException ex) {
            throw new RuntimeException("Wasn't able to write ssh keys to: " + sshDir, ex);
        }
    }

    private void postPublicKeyToBitbucket(String publicKey) {
        String url = "https://api.bitbucket.org/1.0/users/" + this.name + "/ssh-keys";
        try {
            String hostname = DevSupWizUtils.getHostname();
            HttpResponse jsonResponse = Unirest.post((String)url).basicAuth(this.name, this.password).header("accept", "application/json").field("label", (Object)hostname).field("key", publicKey).asString();
            LOG.info("[" + jsonResponse.getStatus() + "] " + jsonResponse.getStatusText() + ": " + jsonResponse);
            jsonResponse.getHeaders().forEach((key, values) -> LOG.info(key + "=" + values));
            if (jsonResponse.getStatus() != 200) {
                throw new RuntimeException("Error posting public key: " + jsonResponse.getStatusText() + " [" + jsonResponse.getStatus() + "]");
            }
            LOG.info("Successfully posted public ssh key: {}", (Object)url);
            LOG.debug((String)jsonResponse.getBody());
        }
        catch (UnirestException ex) {
            throw new RuntimeException("Wasn't able to post public ssh key to: " + url, ex);
        }
    }

    private void appendToConfig(File prvKeyFile) {
        try {
            String lf = System.lineSeparator();
            String str = "Host " + this.host + lf + "    User " + this.name + lf + "    HostName " + this.host + lf + "    IdentityFile " + prvKeyFile + lf;
            try (FileWriter fw = new FileWriter(this.getConfigFile(), true);){
                fw.write(str);
            }
            LOG.info("Successfully added entry to ssh config: {}", (Object)this.getConfigFile());
        }
        catch (IOException ex) {
            throw new RuntimeException("Wasn't able to write ssh config: " + this.getConfigFile(), ex);
        }
    }
}

