/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.json.bind.annotation.JsonbProperty;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fuin.ddd4j.ddd.DecryptionFailedException;
import org.fuin.ddd4j.ddd.EncryptionIvVersionUnknownException;
import org.fuin.ddd4j.ddd.EncryptionKeyIdUnknownException;
import org.fuin.ddd4j.ddd.EncryptionKeyVersionUnknownException;
import org.fuin.objects4j.vo.ValueObject;

@XmlRootElement(name="eyncrypted-data")
@Immutable
public final class EncryptedData
implements ValueObject,
Serializable {
    private static final long serialVersionUID = 1000L;
    @NotEmpty
    @JsonbProperty(value="key-id")
    @XmlElement(name="key-id")
    private String keyId;
    @NotEmpty
    @JsonbProperty(value="key-version")
    @XmlElement(name="key-version")
    private String keyVersion;
    @Nullable
    @JsonbProperty(value="iv-version")
    @XmlElement(name="iv-version")
    private String ivVersion;
    @NotEmpty
    @JsonbProperty(value="data-type")
    @XmlElement(name="data-type")
    private String dataType;
    @NotEmpty
    @JsonbProperty(value="content-type")
    @XmlElement(name="content-type")
    private String contentType;
    @NotEmpty
    @JsonbProperty(value="encrypted-data")
    @XmlElement(name="encrypted-data")
    private byte[] encryptedData;

    protected EncryptedData() {
    }

    public EncryptedData(@NotEmpty String keyId, @NotEmpty String keyVersion, @Nullable String ivVersion, @NotEmpty String dataType, @NotEmpty String contentType, @NotEmpty byte[] encryptedData) {
        this.keyId = keyId;
        this.keyVersion = keyVersion;
        this.ivVersion = ivVersion;
        this.dataType = dataType;
        this.contentType = contentType;
        this.encryptedData = encryptedData;
    }

    @NotEmpty
    public final String getKeyId() {
        return this.keyId;
    }

    @NotEmpty
    public final String getKeyVersion() {
        return this.keyVersion;
    }

    @Nullable
    public final String getIvVersion() {
        return this.ivVersion;
    }

    @NotEmpty
    public final String getDataType() {
        return this.dataType;
    }

    @NotEmpty
    public final String getContentType() {
        return this.contentType;
    }

    @NotEmpty
    public final byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + Arrays.hashCode(this.encryptedData);
        result = 31 * result + (this.ivVersion == null ? 0 : this.ivVersion.hashCode());
        result = 31 * result + (this.keyId == null ? 0 : this.keyId.hashCode());
        result = 31 * result + (this.keyVersion == null ? 0 : this.keyVersion.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedData other = (EncryptedData)obj;
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        if (!Arrays.equals(this.encryptedData, other.encryptedData)) {
            return false;
        }
        if (this.ivVersion == null ? other.ivVersion != null : !this.ivVersion.equals(other.ivVersion)) {
            return false;
        }
        if (this.keyId == null ? other.keyId != null : !this.keyId.equals(other.keyId)) {
            return false;
        }
        return !(this.keyVersion == null ? other.keyVersion != null : !this.keyVersion.equals(other.keyVersion));
    }

    public final String toString() {
        return "EncryptedData [keyId=" + this.keyId + ", keyVersion=" + this.keyVersion + ", ivVersion=" + this.ivVersion + ", dataType=" + this.dataType + ", contentType=" + this.contentType + "]";
    }

    public static interface Decrypter {
        @NotEmpty
        public byte[] decrypt(@NotNull EncryptedData var1) throws EncryptionKeyIdUnknownException, EncryptionKeyVersionUnknownException, EncryptionIvVersionUnknownException, DecryptionFailedException;
    }

    public static interface Encrypter {
        public EncryptedData encrypt(@NotEmpty String var1, @NotEmpty String var2, @NotEmpty String var3, @NotEmpty byte[] var4) throws EncryptionKeyIdUnknownException;
    }
}

