/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.constraints.NotNull;
import org.fuin.ddd4j.ddd.AggregateRootId;
import org.fuin.ddd4j.ddd.EntityType;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.vo.ValueObjectWithBaseType;

public abstract class AggregateRootUuid
implements AggregateRootId,
Comparable<AggregateRootUuid>,
ValueObjectWithBaseType<UUID> {
    private static final long serialVersionUID = 1000L;
    private static final Pattern PATTERN = Pattern.compile("\\{?\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}\\}?");
    private final EntityType entityType;
    private final UUID uuid;

    public AggregateRootUuid(@NotNull EntityType entityType) {
        this(entityType, UUID.randomUUID());
    }

    public AggregateRootUuid(@NotNull EntityType entityType, @NotNull UUID uuid) {
        Contract.requireArgNotNull((String)"entityType", (Object)entityType);
        Contract.requireArgNotNull((String)"uuid", (Object)uuid);
        this.entityType = entityType;
        this.uuid = uuid;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entityType.asString().hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateRootUuid)) {
            return false;
        }
        AggregateRootUuid other = (AggregateRootUuid)obj;
        if (!this.entityType.asString().equals(other.entityType.asString())) {
            return false;
        }
        return this.uuid.equals(other.uuid);
    }

    @Override
    public final int compareTo(AggregateRootUuid other) {
        int c = this.entityType.asString().compareTo(other.entityType.asString());
        if (c != 0) {
            return c;
        }
        return this.uuid.compareTo(other.uuid);
    }

    public final String toString() {
        return this.uuid.toString();
    }

    @Override
    public final String asString() {
        return this.toString();
    }

    @Override
    public final String asTypedString() {
        return this.entityType + " " + this.uuid;
    }

    @Override
    public final EntityType getType() {
        return this.entityType;
    }

    public final Class<UUID> getBaseType() {
        return UUID.class;
    }

    public final UUID asBaseType() {
        return this.uuid;
    }

    public static boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() != 36) {
            return false;
        }
        return PATTERN.matcher(value).matches();
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!AggregateRootUuid.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
        }
    }

    public static final class Validator
    implements ConstraintValidator<AggregateRootUuidStr, String> {
        public final void initialize(AggregateRootUuidStr annotation) {
        }

        public final boolean isValid(String value, ConstraintValidatorContext context) {
            return AggregateRootUuid.isValid(value);
        }
    }

    @Target(value={ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    @Documented
    public static @interface AggregateRootUuidStr {
        public String message() default "{org.fuin.ddd4j.ddd.AggregateRootUuid.message}";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }
}

