/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.fuin.ddd4j.ddd.EntityId;
import org.fuin.ddd4j.ddd.EntityIdFactory;
import org.fuin.ddd4j.ddd.EntityIdPath;
import org.fuin.objects4j.common.ThreadSafe;
import org.fuin.objects4j.vo.AbstractValueObjectConverter;

@Converter(autoApply=true)
@ThreadSafe
public final class EntityIdPathConverter
extends AbstractValueObjectConverter<String, EntityIdPath>
implements AttributeConverter<EntityIdPath, String> {
    private final EntityIdFactory factory;

    public EntityIdPathConverter(EntityIdFactory factory) {
        if (factory == null) {
            throw new IllegalStateException("Factory cannot be null");
        }
        this.factory = factory;
    }

    public final Class<String> getBaseTypeClass() {
        return String.class;
    }

    public final Class<EntityIdPath> getValueObjectClass() {
        return EntityIdPath.class;
    }

    public final boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        List<Entry> entryList = this.entries(value);
        if (entryList == null || entryList.size() == 0) {
            return false;
        }
        for (Entry entry : entryList) {
            if (this.factory.containsType(entry.type)) continue;
            return false;
        }
        return true;
    }

    public final EntityIdPath toVO(String value) {
        if (value == null) {
            return null;
        }
        List<Entry> entryList = this.entries(value);
        if (entryList == null || entryList.size() == 0) {
            throw new IllegalArgumentException("Invalid entity path: '" + value + "'");
        }
        ArrayList<EntityId> ids = new ArrayList<EntityId>();
        for (Entry entry : entryList) {
            ids.add(this.factory.createEntityId(entry.type, entry.id));
        }
        return new EntityIdPath(ids);
    }

    public final String fromVO(EntityIdPath value) {
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    private List<Entry> entries(String value) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        StringTokenizer tok = new StringTokenizer(value, "/");
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            int p = str.indexOf(32);
            if (p == -1) {
                return null;
            }
            String type = str.substring(0, p);
            String id = str.substring(p + 1);
            list.add(new Entry(type, id));
        }
        return list;
    }

    private static final class Entry {
        private String type;
        private String id;

        public Entry(String type, String id) {
            this.type = type;
            this.id = id;
        }
    }
}

