/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import com.migesok.jaxb.adapter.javatime.ZonedDateTimeXmlAdapter;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.ddd4j.ddd.Event;
import org.fuin.ddd4j.ddd.EventId;
import org.fuin.ddd4j.ddd.EventIdConverter;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;

public abstract class AbstractEvent
implements Event {
    private static final long serialVersionUID = 1000L;
    @XmlJavaTypeAdapter(value=EventIdConverter.class)
    @XmlElement(name="event-id")
    private EventId eventId = new EventId();
    @Label(value="Timestamp")
    @ShortLabel(value="Time")
    @Tooltip(value="Date/Time the event was created")
    @Prompt(value="2016-12-31T23:59:59+02:00")
    @XmlJavaTypeAdapter(value=ZonedDateTimeXmlAdapter.class)
    @XmlElement(name="event-timestamp")
    private ZonedDateTime timestamp = ZonedDateTime.now();
    @Label(value="Correlation Identifier")
    @ShortLabel(value="CorrID")
    @Tooltip(value="Event this one correlates to")
    @XmlJavaTypeAdapter(value=EventIdConverter.class)
    @XmlElement(name="correlation-id")
    private EventId correlationId;
    @Label(value="Causation Identifier")
    @ShortLabel(value="CauseID")
    @Tooltip(value="Event that caused this one")
    @XmlJavaTypeAdapter(value=EventIdConverter.class)
    @XmlElement(name="causation-id")
    private EventId causationId;

    public AbstractEvent() {
        this(null, null);
    }

    public AbstractEvent(@NotNull Event respondTo) {
        this(respondTo.getCorrelationId(), respondTo.getEventId());
    }

    public AbstractEvent(@Nullable EventId correlationId, @Nullable EventId causationId) {
        this.correlationId = correlationId;
        this.causationId = causationId;
    }

    @Override
    public final EventId getEventId() {
        return this.eventId;
    }

    @Override
    public final ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public final EventId getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public final EventId getCausationId() {
        return this.causationId;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventId == null ? 0 : this.eventId.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEvent other = (AbstractEvent)obj;
        return !(this.eventId == null ? other.eventId != null : !this.eventId.equals(other.eventId));
    }
}

