/*
 * Decompiled with CFR 0.152.
 */
package org.fuchss.traylauncher;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.fuchss.traylauncher.UrlEntry;

public class SpringBootTrayLauncherConfiguration {
    private String name;
    private String mainUrl;
    private boolean autoOpenMainUrl = true;
    private Image trayIconImage;
    private List<UrlEntry> additionalEntries;

    public SpringBootTrayLauncherConfiguration(String name, String mainUrl, Image trayIcon) {
        this.setName(name);
        this.setMainUrl(mainUrl);
        this.setTrayIconImage(trayIcon);
    }

    public SpringBootTrayLauncherConfiguration(String name, String mainUrl, InputStream trayIcon) {
        this.setName(name);
        this.setMainUrl(mainUrl);
        this.setTrayIconImage(trayIcon);
    }

    public String getName() {
        return this.name;
    }

    public String getMainUrl() {
        return this.mainUrl;
    }

    public Image getTrayIconImage() {
        return this.trayIconImage;
    }

    public List<UrlEntry> getAdditionalUrls() {
        return this.additionalEntries;
    }

    public boolean isAutoOpenMainUrl() {
        return this.autoOpenMainUrl;
    }

    public SpringBootTrayLauncherConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public SpringBootTrayLauncherConfiguration setMainUrl(String mainUrl) {
        this.mainUrl = mainUrl;
        return this;
    }

    public SpringBootTrayLauncherConfiguration setTrayIconImage(Image trayIcon) {
        this.trayIconImage = trayIcon;
        return this;
    }

    public SpringBootTrayLauncherConfiguration setTrayIconImage(InputStream trayIcon) {
        try {
            this.trayIconImage = ImageIO.read(trayIcon);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public SpringBootTrayLauncherConfiguration setAdditionalUrls(List<UrlEntry> entries) {
        this.additionalEntries = entries;
        return this;
    }

    public SpringBootTrayLauncherConfiguration setAutoOpenMainUrl(boolean autoOpenMainUrl) {
        this.autoOpenMainUrl = autoOpenMainUrl;
        return this;
    }
}

