/*
 * Decompiled with CFR 0.152.
 */
package org.fuchss.traylauncher;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.fuchss.traylauncher.SpringBootTrayLauncherConfiguration;
import org.fuchss.traylauncher.UrlEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public final class SpringBootTrayLauncher {
    private static final Logger logger = LoggerFactory.getLogger(SpringBootTrayLauncher.class);

    private SpringBootTrayLauncher() {
        throw new IllegalAccessError();
    }

    public static void run(Class<?> starterClass, String[] args, SpringBootTrayLauncherConfiguration conf) {
        Container container = new Container();
        container.conf = conf;
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{starterClass});
        builder.headless(false);
        SpringApplication app = builder.application();
        app.addListeners(new ApplicationListener[]{e -> SpringBootTrayLauncher.afterStartup(e, () -> SpringBootTrayLauncher.initialMainLaunch(container))});
        app.addListeners(new ApplicationListener[]{e -> SpringBootTrayLauncher.afterStartup(e, () -> SpringBootTrayLauncher.initTray(container))});
        container.ctx = app.run(args);
    }

    private static void openUrl(String urlToOpen) {
        if (urlToOpen == null) {
            return;
        }
        try {
            Desktop.getDesktop().browse(new URI(urlToOpen));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static void initialMainLaunch(Container container) {
        if (container.conf.isAutoOpenMainUrl()) {
            SpringBootTrayLauncher.openUrl(container.conf.getMainUrl());
        }
    }

    private static void initTray(Container container) {
        if (!SystemTray.isSupported()) {
            logger.error("Sorry, SystemTray is not supported");
            return;
        }
        SpringBootTrayLauncher.activateSystemLookAndFeel();
        SpringBootTrayLauncherConfiguration conf = container.conf;
        TrayIcon trayIcon = SpringBootTrayLauncher.createTrayIcon(container);
        trayIcon.addActionListener(e -> SpringBootTrayLauncher.openUrl(conf.getMainUrl()));
        PopupMenu popup = new PopupMenu();
        MenuItem openItem = new MenuItem("Open");
        openItem.addActionListener(e -> SpringBootTrayLauncher.openUrl(conf.getMainUrl()));
        popup.add(openItem);
        if (conf.getAdditionalUrls() != null) {
            for (UrlEntry entry : conf.getAdditionalUrls()) {
                MenuItem entryItem = new MenuItem(entry.getName());
                entryItem.addActionListener(e -> SpringBootTrayLauncher.openUrl(entry.getUrl()));
                popup.add(entryItem);
            }
        }
        MenuItem exitItem = new MenuItem("Exit");
        exitItem.addActionListener(e -> SpringBootTrayLauncher.exit(container));
        popup.add(exitItem);
        try {
            SystemTray tray = SystemTray.getSystemTray();
            trayIcon.setPopupMenu(popup);
            tray.add(trayIcon);
        }
        catch (AWTException e2) {
            logger.error("Sorry, TrayIcon could not be added.");
        }
    }

    private static TrayIcon createTrayIcon(Container container) {
        SpringBootTrayLauncherConfiguration conf = container.conf;
        TrayIcon trayIcon = new TrayIcon(conf.getTrayIconImage(), conf.getName());
        trayIcon.setImageAutoSize(true);
        container.trayIcon = trayIcon;
        return trayIcon;
    }

    private static void exit(Container container) {
        SpringApplication.exit((ApplicationContext)container.ctx, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        SystemTray tray = SystemTray.getSystemTray();
        tray.remove(container.trayIcon);
    }

    private static void activateSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void afterStartup(ApplicationEvent e, Runnable r) {
        if (!(e instanceof ApplicationStartedEvent)) {
            return;
        }
        r.run();
    }

    private static final class Container {
        SpringBootTrayLauncherConfiguration conf;
        ConfigurableApplicationContext ctx;
        TrayIcon trayIcon;

        private Container() {
        }
    }
}

