/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import net.liftweb.common.Box;
import net.liftweb.util.Currency$;
import net.liftweb.util.CurrencyMismatchException;
import net.liftweb.util.Helpers$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u0013\tA1)\u001e:sK:\u001c\u0017P\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0004mS\u001a$x/\u001a2\u000b\u0003\u001d\t1A\\3u\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011!\t\u0002A!b\u0001\n\u0003\u0011\u0012AB1n_VtG/F\u0001\u0014!\tYA#\u0003\u0002\u0016\u0019\t!Aj\u001c8h\u0011!9\u0002A!A!\u0002\u0013\u0019\u0012aB1n_VtG\u000f\t\u0005\t3\u0001\u0011)\u0019!C\u00015\u000511/_7c_2,\u0012a\u0007\t\u00039}q!aC\u000f\n\u0005ya\u0011A\u0002)sK\u0012,g-\u0003\u0002!C\t11\u000b\u001e:j]\u001eT!A\b\u0007\t\u0011\r\u0002!\u0011!Q\u0001\nm\tqa]=nE>d\u0007\u0005\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003!!WmY5nC2\u001cX#A\u0014\u0011\u0005-A\u0013BA\u0015\r\u0005\rIe\u000e\u001e\u0005\tW\u0001\u0011\t\u0011)A\u0005O\u0005IA-Z2j[\u0006d7\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\t=\n$g\r\t\u0003a\u0001i\u0011A\u0001\u0005\u0006#1\u0002\ra\u0005\u0005\u000631\u0002\ra\u0007\u0005\u0006K1\u0002\ra\n\u0005\u0006k\u0001!\tEN\u0001\ti>\u001cFO]5oOR\tq\u0007\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005!A.\u00198h\u0015\u0005a\u0014\u0001\u00026bm\u0006L!\u0001I\u001d\t\u000b}\u0002A\u0011\u0001\u000e\u0002\u000b\u0019|'\u000f\u0012\"\t\u000b\u0005\u0003A\u0011\t\"\u0002\r\u0015\fX/\u00197t)\t\u0019e\t\u0005\u0002\f\t&\u0011Q\t\u0004\u0002\b\u0005>|G.Z1o\u0011\u00159\u0005\t1\u0001I\u0003\u0015yG\u000f[3s!\tY\u0011*\u0003\u0002K\u0019\t\u0019\u0011I\\=\t\u000b1\u0003A\u0011A'\u0002\u000b\u0011\u0002H.^:\u0015\u0005=r\u0005\"B$L\u0001\u0004y\u0003\"\u0002)\u0001\t\u0003\t\u0016A\u0002\u0013nS:,8\u000f\u0006\u00020%\")qi\u0014a\u0001_\u001d)AK\u0001E\u0001+\u0006A1)\u001e:sK:\u001c\u0017\u0010\u0005\u00021-\u001a)\u0011A\u0001E\u0001/N\u0011aK\u0003\u0005\u0006[Y#\t!\u0017\u000b\u0002+\")1L\u0016C\u00019\u0006)\u0011\r\u001d9msR\u0011Ql\u0019\t\u0004=\u0006|S\"A0\u000b\u0005\u0001$\u0011AB2p[6|g.\u0003\u0002c?\n\u0019!i\u001c=\t\u000b\u0011T\u0006\u0019A\u000e\u0002\u0003M\u0004")
public class Currency {
    private final long amount;
    private final String symbol;
    private final int decimals;

    public static Box<Currency> apply(String string2) {
        return Currency$.MODULE$.apply(string2);
    }

    public long amount() {
        return this.amount;
    }

    public String symbol() {
        return this.symbol;
    }

    public int decimals() {
        return this.decimals;
    }

    public String toString() {
        String string2;
        if (this.decimals() == 0) {
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToLong((long)this.amount())).toString();
        } else {
            double d = this.amount();
            double pow = package$.MODULE$.pow(10.0, (double)this.decimals());
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToDouble((double)(d / pow))).toString();
        }
        return string2;
    }

    public String forDB() {
        return new StringBuilder().append((Object)Helpers$.MODULE$.urlEncode(this.symbol())).append((Object)"&").append((Object)BoxesRunTime.boxToLong((long)this.amount())).append((Object)"&").append((Object)BoxesRunTime.boxToInteger((int)this.decimals())).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof Currency)) return false;
        Currency currency = (Currency)object;
        if (currency.amount() != this.amount()) return false;
        String string2 = currency.symbol();
        String string3 = this.symbol();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        if (currency.decimals() != this.decimals()) return false;
        return true;
    }

    public Currency $plus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() + other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    public Currency $minus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() - other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    public Currency(long amount, String symbol, int decimals) {
        this.amount = amount;
        this.symbol = symbol;
        this.decimals = decimals;
    }
}

