/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import net.liftweb.common.Box;
import net.liftweb.util.Currency$;
import net.liftweb.util.CurrencyMismatchException;
import net.liftweb.util.Helpers$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u0013\tA1)\u001e:sK:\u001c\u0017P\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0004mS\u001a$x/\u001a2\u000b\u0003\u001d\t1A\\3u\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-\u0001R\"\u0001\u0007\u000b\u00055q\u0011\u0001\u00027b]\u001eT\u0011aD\u0001\u0005U\u00064\u0018-\u0003\u0002\u0012\u0019\t1qJ\u00196fGRD\u0001b\u0005\u0001\u0003\u0006\u0004%\t\u0001F\u0001\u0007C6|WO\u001c;\u0016\u0003U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011A\u0001T8oO\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0004b[>,h\u000e\u001e\u0011\t\u0011y\u0001!Q1A\u0005\u0002}\taa]=nE>dW#\u0001\u0011\u0011\u0005\u0005\"cB\u0001\f#\u0013\t\u0019s#\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u0019\u0012aa\u0015;sS:<'BA\u0012\u0018\u0011!A\u0003A!A!\u0002\u0013\u0001\u0013aB:z[\n|G\u000e\t\u0005\tU\u0001\u0011)\u0019!C\u0001W\u0005AA-Z2j[\u0006d7/F\u0001-!\t1R&\u0003\u0002//\t\u0019\u0011J\u001c;\t\u0011A\u0002!\u0011!Q\u0001\n1\n\u0011\u0002Z3dS6\fGn\u001d\u0011\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0011!dg\u000e\u001d\u0011\u0005U\u0002Q\"\u0001\u0002\t\u000bM\t\u0004\u0019A\u000b\t\u000by\t\u0004\u0019\u0001\u0011\t\u000b)\n\u0004\u0019\u0001\u0017\t\u000bi\u0002A\u0011I\u001e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u0010\t\u0003\u0017uJ!!\n\u0007\t\u000b}\u0002A\u0011A\u0010\u0002\u000b\u0019|'\u000f\u0012\"\t\u000b\u0005\u0003A\u0011\t\"\u0002\r\u0015\fX/\u00197t)\t\u0019e\t\u0005\u0002\u0017\t&\u0011Qi\u0006\u0002\b\u0005>|G.Z1o\u0011\u00159\u0005\t1\u0001I\u0003\u0015yG\u000f[3s!\t1\u0012*\u0003\u0002K/\t\u0019\u0011I\\=\t\u000b1\u0003A\u0011A'\u0002\u000b\u0011\u0002H.^:\u0015\u0005Qr\u0005\"B$L\u0001\u0004!\u0004\"\u0002)\u0001\t\u0003\t\u0016A\u0002\u0013nS:,8\u000f\u0006\u00025%\")qi\u0014a\u0001i\u001d)AK\u0001E\u0001+\u0006A1)\u001e:sK:\u001c\u0017\u0010\u0005\u00026-\u001a)\u0011A\u0001E\u0001/N\u0011aK\u0003\u0005\u0006eY#\t!\u0017\u000b\u0002+\")1L\u0016C\u00019\u0006)\u0011\r\u001d9msR\u0011Ql\u0019\t\u0004=\u0006$T\"A0\u000b\u0005\u0001$\u0011AB2p[6|g.\u0003\u0002c?\n\u0019!i\u001c=\t\u000b\u0011T\u0006\u0019\u0001\u0011\u0002\u0003M\u0004")
public class Currency {
    private final long amount;
    private final String symbol;
    private final int decimals;

    public static Box<Currency> apply(String string2) {
        return Currency$.MODULE$.apply(string2);
    }

    public long amount() {
        return this.amount;
    }

    public String symbol() {
        return this.symbol;
    }

    public int decimals() {
        return this.decimals;
    }

    public String toString() {
        String string2;
        if (this.decimals() == 0) {
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToLong((long)this.amount())).toString();
        } else {
            double d = this.amount();
            double pow = package$.MODULE$.pow(10.0, (double)this.decimals());
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToDouble((double)(d / pow))).toString();
        }
        return string2;
    }

    public String forDB() {
        return new StringBuilder().append((Object)Helpers$.MODULE$.urlEncode(this.symbol())).append((Object)"&").append((Object)BoxesRunTime.boxToLong((long)this.amount())).append((Object)"&").append((Object)BoxesRunTime.boxToInteger((int)this.decimals())).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof Currency)) return false;
        Currency x2 = (Currency)object;
        if (x2.amount() != this.amount()) return false;
        String string2 = x2.symbol();
        String string3 = this.symbol();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        if (x2.decimals() != this.decimals()) return false;
        return true;
    }

    public Currency $plus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() + other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    public Currency $minus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() - other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    public Currency(long amount, String symbol, int decimals) {
        this.amount = amount;
        this.symbol = symbol;
        this.decimals = decimals;
    }
}

