/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.apple.foundationdb.record.spatial.geophile.GeophileRecordImpl;
import com.apple.foundationdb.record.spatial.geophile.GeophileScanTypes;
import com.apple.foundationdb.record.spatial.geophile.GeophileSpatialJoin;
import com.apple.foundationdb.tuple.Tuple;
import com.geophile.z.SpatialIndex;
import com.geophile.z.SpatialJoin;
import com.geophile.z.SpatialObject;
import com.geophile.z.index.RecordWithSpatialObject;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class GeophileSpatialObjectQueryPlan
implements RecordQueryPlanWithNoChildren,
RecordQueryPlanWithIndex {
    @Nonnull
    private final String indexName;
    @Nonnull
    private final ScanComparisons prefixComparisons;

    protected GeophileSpatialObjectQueryPlan(@Nonnull String indexName, @Nonnull ScanComparisons prefixComparisons) {
        this.indexName = indexName;
        this.prefixComparisons = prefixComparisons;
    }

    @Nullable
    protected abstract SpatialObject getSpatialObject(@Nonnull EvaluationContext var1);

    @Nullable
    protected SpatialJoin.Filter<RecordWithSpatialObject, GeophileRecordImpl> getFilter(@Nonnull EvaluationContext context) {
        return null;
    }

    protected BiFunction<IndexEntry, Tuple, GeophileRecordImpl> getRecordFunction() {
        return GeophileRecordImpl::new;
    }

    @Nonnull
    public ScanComparisons getPrefixComparisons() {
        return this.prefixComparisons;
    }

    @Nonnull
    public String getIndexName() {
        return this.indexName;
    }

    @Nonnull
    public IndexScanType getScanType() {
        return GeophileScanTypes.GO_TO_Z;
    }

    @Nonnull
    public Optional<? extends MatchCandidate> getMatchCandidateMaybe() {
        return Optional.empty();
    }

    @Nonnull
    public <M extends Message> RecordCursor<IndexEntry> executeEntries(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        if (continuation != null) {
            throw new RecordCoreException("continuations are not yet supported", new Object[0]);
        }
        SpatialObject spatialObject = this.getSpatialObject(context);
        if (spatialObject == null) {
            return RecordCursor.empty();
        }
        SpatialJoin spatialJoin = SpatialJoin.newSpatialJoin((SpatialJoin.Duplicates)SpatialJoin.Duplicates.INCLUDE, this.getFilter(context));
        GeophileSpatialJoin geophileSpatialJoin = new GeophileSpatialJoin(spatialJoin, store.getUntypedRecordStore(), context);
        SpatialIndex<GeophileRecordImpl> spatialIndex = geophileSpatialJoin.getSpatialIndex(this.indexName, this.prefixComparisons, this.getRecordFunction());
        return geophileSpatialJoin.recordCursor(spatialObject, spatialIndex);
    }

    public boolean isReverse() {
        return false;
    }

    public boolean hasRecordScan() {
        return false;
    }

    public boolean hasFullRecordScan() {
        return false;
    }

    public boolean hasIndexScan(@Nonnull String indexName) {
        return this.indexName.equals(indexName);
    }

    @Nonnull
    public Set<String> getUsedIndexes() {
        return Collections.singleton(this.indexName);
    }

    public boolean hasLoadBykeys() {
        return false;
    }

    public void logPlanStructure(StoreTimer timer) {
        timer.increment((StoreTimer.Count)FDBStoreTimer.Counts.PLAN_INDEX);
    }

    public int getComplexity() {
        return 1;
    }

    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return Collections.emptyList();
    }

    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        return ImmutableSet.of();
    }

    @Nonnull
    public GeophileSpatialObjectQueryPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return this;
    }

    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        GeophileSpatialObjectQueryPlan that = (GeophileSpatialObjectQueryPlan)otherExpression;
        return this.indexName.equals(that.indexName) && this.prefixComparisons.equals((Object)that.prefixComparisons);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    public int hashCodeWithoutChildren() {
        return Objects.hash(this.indexName, this.prefixComparisons);
    }
}

