/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.spatial.geophile.GeophileIndexImpl;
import com.apple.foundationdb.record.spatial.geophile.GeophileIndexMaintainer;
import com.apple.foundationdb.record.spatial.geophile.GeophileRecordImpl;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.geophile.z.Index;
import com.geophile.z.Space;
import com.geophile.z.SpatialIndex;
import com.geophile.z.SpatialJoin;
import com.geophile.z.SpatialObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

class GeophileSpatialJoin {
    @Nonnull
    private final SpatialJoin spatialJoin;
    @Nonnull
    private final FDBRecordStore store;
    @Nonnull
    private final EvaluationContext context;

    GeophileSpatialJoin(@Nonnull SpatialJoin spatialJoin, @Nonnull FDBRecordStore store, @Nonnull EvaluationContext context) {
        this.spatialJoin = spatialJoin;
        this.store = store;
        this.context = context;
    }

    @Nonnull
    public SpatialIndex<GeophileRecordImpl> getSpatialIndex(@Nonnull String indexName) {
        return this.getSpatialIndex(indexName, ScanComparisons.EMPTY);
    }

    @Nonnull
    public SpatialIndex<GeophileRecordImpl> getSpatialIndex(@Nonnull String indexName, @Nonnull ScanComparisons prefixComparisons) {
        return this.getSpatialIndex(indexName, prefixComparisons, GeophileRecordImpl::new);
    }

    @Nonnull
    public SpatialIndex<GeophileRecordImpl> getSpatialIndex(@Nonnull String indexName, @Nonnull ScanComparisons prefixComparisons, @Nonnull BiFunction<IndexEntry, Tuple, GeophileRecordImpl> recordFunction) {
        if (!prefixComparisons.isEquality()) {
            throw new RecordCoreArgumentException("prefix comparisons must only have equality", new Object[0]);
        }
        IndexMaintainer indexMaintainer = this.store.getIndexMaintainer(this.store.getRecordMetaData().getIndex(indexName));
        TupleRange prefixRange = prefixComparisons.toTupleRange((FDBRecordStoreBase)this.store, this.context);
        Tuple prefix = prefixRange.getLow();
        GeophileIndexImpl index = new GeophileIndexImpl(indexMaintainer, prefix, recordFunction);
        Space space = ((GeophileIndexMaintainer)indexMaintainer).getSpace();
        try {
            return SpatialIndex.newSpatialIndex((Space)space, (Index)index);
        }
        catch (IOException ex) {
            throw new RecordCoreException("Unexpected IO exception", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RecordCoreException((Throwable)ex);
        }
    }

    @Nonnull
    public RecordCursor<IndexEntry> recordCursor(@Nonnull SpatialObject spatialObject, @Nonnull SpatialIndex<GeophileRecordImpl> spatialIndex) {
        Iterator iterator;
        try {
            iterator = this.spatialJoin.iterator(spatialObject, spatialIndex);
        }
        catch (IOException ex) {
            throw new RecordCoreException("Unexpected IO exception", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RecordCoreException((Throwable)ex);
        }
        RecordCursor recordCursor = RecordCursor.fromIterator((Executor)this.store.getExecutor(), (Iterator)iterator);
        return recordCursor.map(GeophileRecordImpl::getIndexEntry);
    }

    @Nonnull
    public RecordCursor<Pair<IndexEntry, IndexEntry>> recordCursor(@Nonnull SpatialIndex<GeophileRecordImpl> left, @Nonnull SpatialIndex<GeophileRecordImpl> right) {
        Iterator iterator;
        try {
            iterator = this.spatialJoin.iterator(left, right);
        }
        catch (IOException ex) {
            throw new RecordCoreException("Unexpected IO exception", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RecordCoreException((Throwable)ex);
        }
        RecordCursor recordCursor = RecordCursor.fromIterator((Executor)this.store.getExecutor(), (Iterator)iterator);
        return recordCursor.map(p -> Pair.of((Object)((GeophileRecordImpl)p.left()).getIndexEntry(), (Object)((GeophileRecordImpl)p.right()).getIndexEntry()));
    }
}

