/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.spatial.geophile.GeophileRecordImpl;
import com.apple.foundationdb.record.spatial.geophile.GeophileSpatialJoin;
import com.apple.foundationdb.record.util.pair.Pair;
import com.geophile.z.SpatialIndex;
import com.geophile.z.SpatialJoin;
import com.google.protobuf.Message;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class GeophileSpatialIndexJoinPlan {
    @Nonnull
    private final String leftIndexName;
    @Nonnull
    private final ScanComparisons leftPrefixComparisons;
    @Nonnull
    private final String rightIndexName;
    @Nonnull
    private final ScanComparisons rightPrefixComparisons;

    public GeophileSpatialIndexJoinPlan(@Nonnull String leftIndexName, @Nonnull ScanComparisons leftPrefixComparisons, @Nonnull String rightIndexName, @Nonnull ScanComparisons rightPrefixComparisons) {
        this.leftIndexName = leftIndexName;
        this.leftPrefixComparisons = leftPrefixComparisons;
        this.rightIndexName = rightIndexName;
        this.rightPrefixComparisons = rightPrefixComparisons;
    }

    @Nonnull
    public <M extends Message> RecordCursor<Pair<FDBIndexedRecord<M>, FDBIndexedRecord<M>>> execute(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        SpatialJoin spatialJoin = SpatialJoin.newSpatialJoin((SpatialJoin.Duplicates)SpatialJoin.Duplicates.INCLUDE);
        GeophileSpatialJoin geophileSpatialJoin = new GeophileSpatialJoin(spatialJoin, store.getUntypedRecordStore(), context);
        SpatialIndex<GeophileRecordImpl> leftSpatialIndex = geophileSpatialJoin.getSpatialIndex(this.leftIndexName, this.leftPrefixComparisons);
        SpatialIndex<GeophileRecordImpl> rightSpatialIndex = geophileSpatialJoin.getSpatialIndex(this.rightIndexName, this.rightPrefixComparisons);
        return this.fetchIndexRecords(store, geophileSpatialJoin.recordCursor(leftSpatialIndex, rightSpatialIndex));
    }

    @Nonnull
    public <M extends Message> RecordCursor<Pair<FDBIndexedRecord<M>, FDBIndexedRecord<M>>> fetchIndexRecords(@Nonnull FDBRecordStoreBase<M> store, @Nonnull RecordCursor<Pair<IndexEntry, IndexEntry>> indexCursor) {
        return indexCursor.mapPipelined(pair -> store.loadIndexEntryRecord((IndexEntry)pair.getLeft(), IndexOrphanBehavior.ERROR).thenCombine((CompletionStage)store.loadIndexEntryRecord((IndexEntry)pair.getRight(), IndexOrphanBehavior.ERROR), Pair::of), store.getPipelineSize(PipelineOperation.INDEX_TO_RECORD));
    }
}

