/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.spatial.geophile.GeophileSpatial;
import com.geophile.z.Space;
import com.geophile.z.SpatialObject;
import com.geophile.z.spatialobject.d2.Point;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.io.ParseException;

@API(value=API.Status.EXPERIMENTAL)
public abstract class GeophileSpatialFunctionKeyExpression
extends FunctionKeyExpression {
    public static final Space SPACE_LAT_LON = GeophileSpatial.createLatLonSpace();
    private final Space space = SPACE_LAT_LON;

    protected GeophileSpatialFunctionKeyExpression(@Nonnull String name, @Nonnull KeyExpression arguments) {
        super(name, arguments);
    }

    @Nonnull
    public Space getSpace() {
        return this.space;
    }

    @Nullable
    protected abstract SpatialObject parseSpatialObject(@Nonnull Key.Evaluated var1) throws ParseException;

    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateFunction(@Nullable FDBRecord<M> record, @Nullable Message message, @Nonnull Key.Evaluated arguments) {
        SpatialObject spatialObject;
        try {
            spatialObject = this.parseSpatialObject(arguments);
        }
        catch (ParseException ex) {
            throw new RecordCoreException((Throwable)ex);
        }
        if (spatialObject == null) {
            return Collections.singletonList(Key.Evaluated.NULL);
        }
        long[] zs = new long[spatialObject.maxZ()];
        GeophileSpatial.shuffle(this.space, spatialObject, zs);
        ArrayList<Key.Evaluated> result = new ArrayList<Key.Evaluated>(zs.length);
        for (long z : zs) {
            if (z == -1L) break;
            result.add(Key.Evaluated.scalar((Object)z));
        }
        return result;
    }

    public boolean createsDuplicates() {
        return true;
    }

    public int getColumnSize() {
        return 1;
    }

    protected boolean shouldSwapLatLong(@Nonnull Key.Evaluated arguments) {
        return arguments.size() > 1 && (Boolean)arguments.getObject(1, Boolean.class) != false;
    }

    public static class GeoWKTZ
    extends GeophileSpatialFunctionKeyExpression {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash((Object)"Geo-WKT-Z");

        public GeoWKTZ(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        @Override
        @Nullable
        protected SpatialObject parseSpatialObject(@Nonnull Key.Evaluated arguments) throws ParseException {
            String wkt = arguments.getString(0);
            if (wkt == null) {
                return null;
            }
            return GeophileSpatial.deserializeWKT(this.getSpace(), wkt, this.shouldSwapLatLong(arguments));
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return 2;
        }

        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return super.basePlanHash(mode, BASE_HASH, new Object[0]);
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class GeoWKBZ
    extends GeophileSpatialFunctionKeyExpression {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash((Object)"Geo-WKB-Z");

        public GeoWKBZ(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        @Override
        @Nullable
        protected SpatialObject parseSpatialObject(@Nonnull Key.Evaluated arguments) throws ParseException {
            byte[] wkb = (byte[])arguments.getObject(0, byte[].class);
            if (wkb == null) {
                return null;
            }
            return GeophileSpatial.deserializeWKB(this.getSpace(), wkb, this.shouldSwapLatLong(arguments));
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return 2;
        }

        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return super.basePlanHash(mode, BASE_HASH, new Object[0]);
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class GeoJsonZ
    extends GeophileSpatialFunctionKeyExpression {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash((Object)"Geo-Json-Z");

        public GeoJsonZ(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        @Override
        @Nullable
        protected SpatialObject parseSpatialObject(@Nonnull Key.Evaluated arguments) throws ParseException {
            String json = arguments.getString(0);
            if (json == null) {
                return null;
            }
            return GeophileSpatial.deserializeGeoJson(this.getSpace(), json, this.shouldSwapLatLong(arguments));
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return 2;
        }

        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return super.basePlanHash(mode, BASE_HASH, new Object[0]);
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class GeoPointZ
    extends GeophileSpatialFunctionKeyExpression {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash((Object)"Geo-Point-Z");

        public GeoPointZ(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        @Override
        @Nullable
        protected SpatialObject parseSpatialObject(@Nonnull Key.Evaluated arguments) {
            Double latitude = arguments.getNullableDouble(0);
            Double longitude = arguments.getNullableDouble(1);
            if (latitude == null || longitude == null) {
                return null;
            }
            return new Point(latitude.doubleValue(), longitude.doubleValue());
        }

        public int getMinArguments() {
            return 2;
        }

        public int getMaxArguments() {
            return 2;
        }

        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return super.basePlanHash(mode, BASE_HASH, new Object[0]);
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

