/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.annotation.API;
import com.geophile.z.Space;
import com.geophile.z.SpatialObject;
import com.geophile.z.spatialobject.jts.JTS;
import com.geophile.z.spatialobject.jts.JTSSpatialObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import org.slf4j.bridge.SLF4JBridgeHandler;

@API(value=API.Status.EXPERIMENTAL)
class GeophileSpatial {
    public static final int LAT_LON_DIMENSIONS = 2;
    public static final double MIN_LAT = -90.0;
    public static final double MAX_LAT = 90.0;
    public static final double MIN_LON = -180.0;
    public static final double MAX_LON = 180.0;
    private static final int LAT_BITS = 28;
    private static final int LON_BITS = 29;
    private static final CoordinateSequenceFilter SWAPPING_FILTER = new SwappingFilter();
    private static final ThreadLocal<IO> io;

    private GeophileSpatial() {
    }

    public static Space createLatLonSpace() {
        int[] interleave = new int[57];
        int dimension = 1;
        for (int d = 0; d < 57; ++d) {
            interleave[d] = dimension;
            dimension = 1 - dimension;
        }
        return Space.newSpace((double[])new double[]{-90.0, -180.0}, (double[])new double[]{90.0, 180.0}, (int[])new int[]{28, 29}, (int[])interleave);
    }

    public static long shuffle(Space space, double x, double y) {
        com.geophile.z.spatialobject.d2.Point point = new com.geophile.z.spatialobject.d2.Point(x, y);
        long[] zValues = new long[1];
        space.decompose((SpatialObject)point, zValues);
        return zValues[0];
    }

    public static void shuffle(Space space, SpatialObject spatialObject, long[] zs) {
        space.decompose(spatialObject, zs);
    }

    public static String serializeGeoJson(JTSSpatialObject spatialObject) {
        return io.get().geoJsonWriter().write(spatialObject.geometry());
    }

    public static SpatialObject deserializeGeoJson(Space space, String string) throws ParseException {
        return GeophileSpatial.deserializeGeoJson(space, string, false);
    }

    public static SpatialObject deserializeGeoJson(Space space, String string, boolean swapLatLong) throws ParseException {
        Geometry geometry = io.get().geoJsonReader().read(string);
        if (swapLatLong) {
            geometry = GeophileSpatial.swapLatLong(geometry);
        }
        return geometry instanceof Point ? JTS.spatialObject((Space)space, (Point)((Point)geometry)) : JTS.spatialObject((Space)space, (Geometry)geometry);
    }

    public static byte[] serializeWKB(JTSSpatialObject spatialObject) {
        return io.get().wkbWriter().write(spatialObject.geometry());
    }

    public static SpatialObject deserializeWKB(Space space, byte[] bytes) throws ParseException {
        return GeophileSpatial.deserializeWKB(space, bytes, false);
    }

    public static SpatialObject deserializeWKB(Space space, byte[] bytes, boolean swapLatLong) throws ParseException {
        Geometry geometry = io.get().wkbReader().read(bytes);
        if (swapLatLong) {
            geometry = GeophileSpatial.swapLatLong(geometry);
        }
        return geometry instanceof Point ? JTS.spatialObject((Space)space, (Point)((Point)geometry)) : JTS.spatialObject((Space)space, (Geometry)geometry);
    }

    public static String serializeWKT(JTSSpatialObject spatialObject) {
        return io.get().wktWriter().write(spatialObject.geometry());
    }

    public static SpatialObject deserializeWKT(Space space, String string) throws ParseException {
        return GeophileSpatial.deserializeWKT(space, string, false);
    }

    public static SpatialObject deserializeWKT(Space space, String string, boolean swapLatLong) throws ParseException {
        Geometry geometry = io.get().wktReader().read(string);
        if (swapLatLong) {
            geometry = GeophileSpatial.swapLatLong(geometry);
        }
        return geometry instanceof Point ? JTS.spatialObject((Space)space, (Point)((Point)geometry)) : JTS.spatialObject((Space)space, (Geometry)geometry);
    }

    public static Geometry swapLatLong(@Nonnull Geometry geometry) {
        geometry.apply(SWAPPING_FILTER);
        return geometry;
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Logger.getLogger("").setLevel(Level.FINEST);
        io = new ThreadLocal<IO>(){

            @Override
            protected IO initialValue() {
                return new IO();
            }
        };
    }

    private static class IO {
        private final GeometryFactory factory = new GeometryFactory();
        private GeoJsonReader geoJsonReader;
        private GeoJsonWriter geoJsonWriter;
        private WKBReader wkbReader;
        private WKBWriter wkbWriter;
        private WKTReader wktReader;
        private WKTWriter wktWriter;

        private IO() {
        }

        public GeoJsonReader geoJsonReader() {
            if (this.geoJsonReader == null) {
                this.geoJsonReader = new GeoJsonReader(this.factory);
            }
            return this.geoJsonReader;
        }

        public GeoJsonWriter geoJsonWriter() {
            if (this.geoJsonWriter == null) {
                this.geoJsonWriter = new GeoJsonWriter();
            }
            return this.geoJsonWriter;
        }

        public WKBReader wkbReader() {
            if (this.wkbReader == null) {
                this.wkbReader = new WKBReader(this.factory);
            }
            return this.wkbReader;
        }

        public WKBWriter wkbWriter() {
            if (this.wkbWriter == null) {
                this.wkbWriter = new WKBWriter();
            }
            return this.wkbWriter;
        }

        public WKTReader wktReader() {
            if (this.wktReader == null) {
                this.wktReader = new WKTReader(this.factory);
            }
            return this.wktReader;
        }

        public WKTWriter wktWriter() {
            if (this.wktWriter == null) {
                this.wktWriter = new WKTWriter();
            }
            return this.wktWriter;
        }
    }

    private static class SwappingFilter
    implements CoordinateSequenceFilter {
        private SwappingFilter() {
        }

        public void filter(CoordinateSequence seq, int i) {
            double x = seq.getCoordinate((int)i).x;
            double y = seq.getCoordinate((int)i).y;
            seq.setOrdinate(i, 0, y);
            seq.setOrdinate(i, 1, x);
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return false;
        }
    }
}

