/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.tuple.Tuple;
import com.geophile.z.Record;
import com.geophile.z.SpatialObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class GeophileRecordImpl
implements Record {
    @Nullable
    private final IndexEntry indexEntry;
    private long z;

    GeophileRecordImpl(@Nullable IndexEntry indexEntry, @Nullable Tuple prefix) {
        this.indexEntry = indexEntry;
        this.z = indexEntry == null ? -1L : indexEntry.getKey().getLong(prefix == null ? 0 : prefix.size());
    }

    @Nullable
    public IndexEntry getIndexEntry() {
        return this.indexEntry;
    }

    @Nonnull
    public SpatialObject spatialObject() {
        throw new UnsupportedOperationException("this index does not have covering spatial objects");
    }

    public long z() {
        return this.z;
    }

    public void z(long z) {
        this.z = z;
    }

    public void copyTo(Record record) {
        throw new UnsupportedOperationException("records are stable; no need for copying");
    }

    public String toString() {
        return String.valueOf(this.indexEntry) + "@" + this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeophileRecordImpl that = (GeophileRecordImpl)o;
        return Objects.equals(this.indexEntry, that.indexEntry);
    }

    public int hashCode() {
        return Objects.hash(this.indexEntry);
    }
}

