/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.spatial.common.DoubleValueOrParameter;
import com.apple.foundationdb.record.spatial.geophile.GeophileBoxLatLon;
import com.apple.foundationdb.record.spatial.geophile.GeophileCoveringPointRecord;
import com.apple.foundationdb.record.spatial.geophile.GeophileRecordImpl;
import com.apple.foundationdb.record.spatial.geophile.GeophileSpatialObjectQueryPlan;
import com.apple.foundationdb.tuple.Tuple;
import com.geophile.z.SpatialJoin;
import com.geophile.z.SpatialObject;
import com.geophile.z.index.RecordWithSpatialObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

@API(value=API.Status.EXPERIMENTAL)
public class GeophilePointWithinDistanceQueryPlan
extends GeophileSpatialObjectQueryPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash((Object)"Geophile-Point-Within-Distance-Query-Plan");
    @Nonnull
    private final DoubleValueOrParameter centerLatitude;
    @Nonnull
    private final DoubleValueOrParameter centerLongitude;
    @Nonnull
    private final DoubleValueOrParameter distance;
    private final boolean covering;

    public GeophilePointWithinDistanceQueryPlan(@Nonnull DoubleValueOrParameter centerLatitude, @Nonnull DoubleValueOrParameter centerLongitude, @Nonnull DoubleValueOrParameter distance, @Nonnull String indexName, @Nonnull ScanComparisons prefixComparisons, boolean covering) {
        super(indexName, prefixComparisons);
        this.centerLatitude = centerLatitude;
        this.centerLongitude = centerLongitude;
        this.distance = distance;
        this.covering = covering;
    }

    @Override
    @Nullable
    protected SpatialObject getSpatialObject(@Nonnull EvaluationContext context) {
        Double distanceValue = this.distance.getValue(context);
        Double centerLatitudeValue = this.centerLatitude.getValue(context);
        Double centerLongitudeValue = this.centerLongitude.getValue(context);
        if (distanceValue == null || centerLatitudeValue == null || centerLongitudeValue == null) {
            return null;
        }
        return GeophileBoxLatLon.newBox(centerLatitudeValue - distanceValue, centerLatitudeValue + distanceValue, centerLongitudeValue - distanceValue, centerLongitudeValue + distanceValue);
    }

    @Override
    @Nullable
    protected SpatialJoin.Filter<RecordWithSpatialObject, GeophileRecordImpl> getFilter(@Nonnull EvaluationContext context) {
        if (this.covering) {
            Double distanceValue = this.distance.getValue(context);
            Double centerLatitudeValue = this.centerLatitude.getValue(context);
            Double centerLongitudeValue = this.centerLongitude.getValue(context);
            if (distanceValue == null || centerLatitudeValue == null || centerLongitudeValue == null) {
                return null;
            }
            GeometryFactory geometryFactory = new GeometryFactory();
            Point center = geometryFactory.createPoint(new Coordinate(centerLatitudeValue.doubleValue(), centerLongitudeValue.doubleValue()));
            return (arg_0, arg_1) -> GeophilePointWithinDistanceQueryPlan.lambda$getFilter$0(geometryFactory, (Geometry)center, distanceValue, arg_0, arg_1);
        }
        return null;
    }

    @Override
    protected BiFunction<IndexEntry, Tuple, GeophileRecordImpl> getRecordFunction() {
        if (this.covering) {
            return GeophileCoveringPointRecord::new;
        }
        return GeophileRecordImpl::new;
    }

    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.NO_FIELDS;
    }

    @Nonnull
    public RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords getFetchIndexRecords() {
        return RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY;
    }

    @Nonnull
    public Value getResultValue() {
        return new QueriedValue();
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{this.getIndexName(), this.getPrefixComparisons(), this.centerLatitude, this.centerLongitude, this.distance, this.covering});
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{BASE_HASH, this.getIndexName(), this.getPrefixComparisons(), this.covering});
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf(mode.getKind()) + " is not supported");
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (!super.equalsWithoutChildren(otherExpression, equivalencesMap)) {
            return false;
        }
        GeophilePointWithinDistanceQueryPlan that = (GeophilePointWithinDistanceQueryPlan)otherExpression;
        return this.covering == that.covering && this.centerLatitude.equals(that.centerLatitude) && this.centerLongitude.equals(that.centerLongitude) && this.distance.equals(that.distance);
    }

    @Override
    public int hashCodeWithoutChildren() {
        return Objects.hash(super.hashCodeWithoutChildren(), this.centerLatitude, this.centerLongitude, this.distance, this.covering);
    }

    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return this.createIndexPlannerGraph((RecordQueryPlan)this, this.covering ? NodeInfo.COVERING_SPATIAL_INDEX_SCAN_OPERATOR : NodeInfo.SPATIAL_INDEX_SCAN_OPERATOR, (List<String>)ImmutableList.of(), (Map<String, Attribute>)ImmutableMap.of());
    }

    @Nonnull
    public PlannerGraph createIndexPlannerGraph(@Nonnull RecordQueryPlan identity, @Nonnull NodeInfo nodeInfo, @Nonnull List<String> additionalDetails, @Nonnull Map<String, Attribute> additionalAttributeMap) {
        ImmutableList.Builder detailsBuilder = ImmutableList.builder();
        ImmutableMap.Builder attributeMapBuilder = ImmutableMap.builder();
        detailsBuilder.addAll(additionalDetails);
        attributeMapBuilder.putAll(additionalAttributeMap);
        detailsBuilder.add((Object)"center latitude: {{centerLatitude}}");
        attributeMapBuilder.put((Object)"centerLatitude", (Object)Attribute.gml((Object)this.centerLatitude));
        detailsBuilder.add((Object)"center longitude: {{centerLongitude}}");
        attributeMapBuilder.put((Object)"centerLongitude", (Object)Attribute.gml((Object)this.centerLongitude));
        detailsBuilder.add((Object)"distance: {{distance}}");
        attributeMapBuilder.put((Object)"distance", (Object)Attribute.gml((Object)this.distance));
        return PlannerGraph.fromNodeAndChildGraphs((PlannerGraph.Node)new PlannerGraph.OperatorNodeWithInfo(identity, nodeInfo, (List)detailsBuilder.build(), (Map)attributeMapBuilder.build()), (List)ImmutableList.of((Object)PlannerGraph.fromNodeAndChildGraphs((PlannerGraph.Node)new PlannerGraph.DataNodeWithInfo(NodeInfo.INDEX_DATA, (Type)new Type.Relation((Type)new Type.Any()), (List)ImmutableList.copyOf(this.getUsedIndexes())), (List)ImmutableList.of())));
    }

    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    private static /* synthetic */ boolean lambda$getFilter$0(GeometryFactory geometryFactory, Geometry center, Double distanceValue, RecordWithSpatialObject spatialObject, GeophileRecordImpl record) {
        com.geophile.z.spatialobject.d2.Point point = (com.geophile.z.spatialobject.d2.Point)record.spatialObject();
        Point geometry = geometryFactory.createPoint(new Coordinate(point.x(), point.y()));
        return geometry.isWithinDistance(center, distanceValue.doubleValue());
    }
}

