/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChild;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.record.spatial.geophile.GeophileScanTypes;
import com.apple.foundationdb.record.spatial.geophile.GeophileSpatialFunctionKeyExpression;
import com.geophile.z.Space;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class GeophileIndexMaintainer
extends StandardIndexMaintainer {
    @Nonnull
    private final Space space;

    public GeophileIndexMaintainer(IndexMaintainerState state) {
        super(state);
        this.space = GeophileIndexMaintainer.getSpatialFunction(state.index).getSpace();
    }

    @Nonnull
    static GeophileSpatialFunctionKeyExpression getSpatialFunction(@Nonnull Index index) {
        KeyExpression rightComponent;
        KeyExpression rootKey = index.getRootExpression();
        if (rootKey instanceof KeyWithValueExpression) {
            rootKey = ((KeyWithValueExpression)rootKey).getKeyExpression();
        }
        List components = rootKey.normalizeKeyForPositions();
        KeyExpression bottomComponent = rightComponent = (KeyExpression)components.get(components.size() - 1);
        while (true) {
            if (bottomComponent instanceof GeophileSpatialFunctionKeyExpression) {
                return (GeophileSpatialFunctionKeyExpression)bottomComponent;
            }
            if (!(bottomComponent instanceof KeyExpressionWithChild)) break;
            bottomComponent = ((KeyExpressionWithChild)bottomComponent).getChild();
        }
        throw new KeyExpression.InvalidExpressionException("need spatial key expression for index type", new Object[]{LogMessageKeys.INDEX_TYPE, index.getType(), LogMessageKeys.INDEX_NAME, index.getName(), LogMessageKeys.INDEX_KEY, index.getRootExpression()});
    }

    @Nonnull
    public Space getSpace() {
        return this.space;
    }

    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (scanType.equals((Object)GeophileScanTypes.GO_TO_Z)) {
            return this.scan(range, continuation, scanProperties);
        }
        throw new RecordCoreException("This index can only be scanned by a spatial cursor", new Object[0]);
    }
}

