/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.spatial.geophile.GeophileIndexImpl;
import com.apple.foundationdb.record.spatial.geophile.GeophileRecordImpl;
import com.apple.foundationdb.record.spatial.geophile.GeophileScanTypes;
import com.apple.foundationdb.tuple.Tuple;
import com.geophile.z.Cursor;
import com.geophile.z.Index;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class GeophileCursorImpl
extends Cursor<GeophileRecordImpl> {
    @Nonnull
    private final IndexMaintainer indexMaintainer;
    @Nullable
    private final Tuple prefix;
    @Nonnull
    private final BiFunction<IndexEntry, Tuple, GeophileRecordImpl> recordFunction;
    private RecordCursor<IndexEntry> recordCursor;

    GeophileCursorImpl(@Nonnull GeophileIndexImpl index, @Nonnull IndexMaintainer indexMaintainer, @Nullable Tuple prefix, @Nonnull BiFunction<IndexEntry, Tuple, GeophileRecordImpl> recordFunction) {
        super((Index)index);
        this.indexMaintainer = indexMaintainer;
        this.prefix = prefix;
        this.recordFunction = recordFunction;
    }

    @Nullable
    public GeophileRecordImpl next() throws InterruptedException {
        if (this.recordCursor == null) {
            throw new IllegalStateException("cannot call next before goTo");
        }
        RecordCursorResult next = this.recordCursor.getNext();
        if (next.hasNext()) {
            return this.recordFunction.apply((IndexEntry)next.get(), this.prefix);
        }
        return null;
    }

    public void goTo(@Nonnull GeophileRecordImpl key) {
        TupleRange range = new TupleRange(Tuple.from((Object[])new Object[]{key.z()}), null, EndpointType.RANGE_INCLUSIVE, EndpointType.TREE_END);
        if (this.prefix != null) {
            range = range.prepend(this.prefix);
        }
        this.recordCursor = this.indexMaintainer.scan(GeophileScanTypes.GO_TO_Z, range, null, ScanProperties.FORWARD_SCAN);
    }

    public boolean deleteCurrent() {
        throw new UnsupportedOperationException("delete not supported");
    }
}

