/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.geophile.z.Space;
import com.geophile.z.SpatialObject;
import com.geophile.z.space.Region;
import com.geophile.z.space.RegionComparison;
import com.geophile.z.spatialobject.d2.Box;
import java.nio.ByteBuffer;

class GeophileBoxLatLonWithWraparound
implements SpatialObject {
    private final Box left;
    private final Box right;

    public GeophileBoxLatLonWithWraparound(double latLo, double latHi, double lonLo, double lonHi) {
        if (lonLo <= lonHi) {
            throw new RecordCoreArgumentException("box does not wrap around", new Object[0]).addLogInfo("latLo", (Object)latLo).addLogInfo("latHi", (Object)latHi).addLogInfo("lonLo", (Object)lonLo).addLogInfo("lonHi", (Object)lonHi);
        }
        this.left = new Box(latLo, latHi, -180.0, lonHi);
        this.right = new Box(latLo, latHi, lonLo, 180.0);
    }

    public double[] arbitraryPoint() {
        return this.left.arbitraryPoint();
    }

    public int maxZ() {
        return this.left.maxZ();
    }

    public boolean containedBy(Region region) {
        return region.level() == 0;
    }

    public boolean containedBy(Space space) {
        return this.left.containedBy(space) && this.right.containedBy(space);
    }

    public RegionComparison compare(Region region) {
        RegionComparison cL = this.left.compare(region);
        RegionComparison cR = this.right.compare(region);
        if (cL == RegionComparison.REGION_INSIDE_OBJECT && cR == RegionComparison.REGION_INSIDE_OBJECT) {
            throw new IllegalStateException("Cannot be inside two disjoint boxes");
        }
        if (cL == RegionComparison.REGION_INSIDE_OBJECT || cR == RegionComparison.REGION_INSIDE_OBJECT) {
            return RegionComparison.REGION_INSIDE_OBJECT;
        }
        if (cL == RegionComparison.REGION_OUTSIDE_OBJECT && cR == RegionComparison.REGION_OUTSIDE_OBJECT) {
            return RegionComparison.REGION_OUTSIDE_OBJECT;
        }
        return RegionComparison.REGION_OVERLAPS_OBJECT;
    }

    public void readFrom(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public void writeTo(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "(" + this.left.yLo() + ":" + this.left.yHi() + ", " + this.right.xLo() + ":" + this.left.xHi() + ")";
    }
}

