/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.spatial.geophile.GeophileBoxLatLonWithWraparound;
import com.geophile.z.SpatialObject;
import com.geophile.z.spatialobject.d2.Box;

@API(value=API.Status.EXPERIMENTAL)
public class GeophileBoxLatLon {
    private static final double CIRCLE = 360.0;

    private GeophileBoxLatLon() {
    }

    public static SpatialObject newBox(double latLo, double latHi, double lonLo, double lonHi) {
        latLo = GeophileBoxLatLon.fixLat(latLo);
        latHi = GeophileBoxLatLon.fixLat(latHi);
        lonLo = GeophileBoxLatLon.fixLon(lonLo);
        lonHi = GeophileBoxLatLon.fixLon(lonHi);
        try {
            return lonLo <= lonHi ? new Box(latLo, latHi, lonLo, lonHi) : new GeophileBoxLatLonWithWraparound(latLo, latHi, lonLo, lonHi);
        }
        catch (IllegalArgumentException ex) {
            throw new RecordCoreArgumentException("cannot make box", (Throwable)ex).addLogInfo("latLo", (Object)latLo).addLogInfo("latHi", (Object)latHi).addLogInfo("lonLo", (Object)lonLo).addLogInfo("lonHi", (Object)lonHi);
        }
    }

    private static double fixLon(double lon) {
        if (lon > 540.0 || lon < -540.0) {
            throw new RecordCoreArgumentException("Invalid longitude", new Object[0]).addLogInfo("longitude", (Object)lon);
        }
        if (lon < -180.0) {
            lon += 360.0;
        } else if (lon > 180.0) {
            lon -= 360.0;
        }
        return lon;
    }

    private static double fixLat(double lat) {
        if (lat > 450.0 || lat < -450.0) {
            throw new RecordCoreArgumentException("Invalid latitude", new Object[0]).addLogInfo("latitude", (Object)lat);
        }
        if (lat > 90.0) {
            lat = 90.0;
        } else if (lat < -90.0) {
            lat = -90.0;
        }
        return lat;
    }
}

