/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.ComponentWithNoChildren;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.spatial.common.DoubleValueOrParameter;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

@API(value=API.Status.EXPERIMENTAL)
public class GeoPointWithinDistanceComponent
implements ComponentWithNoChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash((Object)"Geo-Point-Within-Distance-Component");
    @Nonnull
    private final DoubleValueOrParameter centerLatitude;
    @Nonnull
    private final DoubleValueOrParameter centerLongitude;
    @Nonnull
    private final DoubleValueOrParameter distance;
    @Nonnull
    private final String latitudeFieldName;
    @Nonnull
    private final String longitudeFieldName;
    @Nonnull
    private final GeometryFactory geometryFactory = new GeometryFactory();

    public GeoPointWithinDistanceComponent(@Nonnull DoubleValueOrParameter centerLatitude, @Nonnull DoubleValueOrParameter centerLongitude, @Nonnull DoubleValueOrParameter distance, @Nonnull String latitudeFieldName, @Nonnull String longitudeFieldName) {
        this.centerLatitude = centerLatitude;
        this.centerLongitude = centerLongitude;
        this.distance = distance;
        this.latitudeFieldName = latitudeFieldName;
        this.longitudeFieldName = longitudeFieldName;
    }

    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        Double distanceValue = this.distance.getValue(context);
        Double centerLatitudeValue = this.centerLatitude.getValue(context);
        Double centerLongitudeValue = this.centerLongitude.getValue(context);
        if (distanceValue == null || centerLatitudeValue == null || centerLongitudeValue == null) {
            return null;
        }
        Double pointLatitudeValue = this.getCoordinateField(message, this.latitudeFieldName);
        Double pointLongitudeValue = this.getCoordinateField(message, this.longitudeFieldName);
        if (pointLatitudeValue == null || pointLongitudeValue == null) {
            return null;
        }
        Point center = this.geometryFactory.createPoint(new Coordinate(centerLatitudeValue.doubleValue(), centerLongitudeValue.doubleValue()));
        Point point = this.geometryFactory.createPoint(new Coordinate(pointLatitudeValue.doubleValue(), pointLongitudeValue.doubleValue()));
        return point.isWithinDistance((Geometry)center, distanceValue.doubleValue());
    }

    @Nullable
    private Double getCoordinateField(@Nullable Message message, @Nonnull String fieldName) {
        if (message == null) {
            return null;
        }
        Descriptors.FieldDescriptor field = message.getDescriptorForType().findFieldByName(fieldName);
        if (field == null) {
            throw new Query.InvalidExpressionException("Missing field " + fieldName);
        }
        return (Double)message.getField(field);
    }

    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        this.validateCoordinateField(descriptor, this.latitudeFieldName);
        this.validateCoordinateField(descriptor, this.longitudeFieldName);
    }

    private void validateCoordinateField(@Nonnull Descriptors.Descriptor descriptor, @Nonnull String fieldName) {
        Descriptors.FieldDescriptor field = descriptor.findFieldByName(fieldName);
        if (field == null) {
            throw new Query.InvalidExpressionException("Missing field " + fieldName);
        }
        if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.DOUBLE) {
            throw new Query.InvalidExpressionException("Required double field for " + fieldName);
        }
        if (field.isRepeated()) {
            throw new Query.InvalidExpressionException("Required scalar field, but got repeated field " + fieldName);
        }
    }

    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{this.centerLatitude, this.centerLongitude, this.distance, this.latitudeFieldName, this.longitudeFieldName});
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{BASE_HASH, this.centerLatitude, this.centerLongitude, this.distance, this.latitudeFieldName, this.longitudeFieldName});
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf(mode.getKind()) + " is not supported");
    }

    public String toString() {
        return "(" + this.latitudeFieldName + "," + this.longitudeFieldName + ") WITHIN " + String.valueOf(this.distance) + " OF (" + String.valueOf(this.centerLatitude) + "," + String.valueOf(this.centerLongitude) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPointWithinDistanceComponent that = (GeoPointWithinDistanceComponent)o;
        return this.centerLatitude.equals(that.centerLatitude) && this.centerLongitude.equals(that.centerLongitude) && this.distance.equals(that.distance) && this.latitudeFieldName.equals(that.latitudeFieldName) && this.longitudeFieldName.equals(that.longitudeFieldName);
    }

    public int hashCode() {
        return Objects.hash(this.centerLatitude, this.centerLongitude, this.distance, this.latitudeFieldName, this.longitudeFieldName);
    }
}

