/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class DoubleValueOrParameter
implements PlanHashable {
    public abstract Double getValue(@Nonnull EvaluationContext var1);

    @Nonnull
    public static DoubleValueOrParameter value(double value) {
        return new DoubleValue(value);
    }

    @Nonnull
    public static DoubleValueOrParameter parameter(@Nonnull String parameter) {
        return new DoubleParameter(parameter);
    }

    static class DoubleValue
    extends DoubleValueOrParameter {
        private final double value;

        DoubleValue(double value) {
            this.value = value;
        }

        @Override
        public Double getValue(@Nonnull EvaluationContext context) {
            return this.value;
        }

        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return Double.hashCode(this.value);
        }

        public String toString() {
            return Double.toString(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleValue that = (DoubleValue)o;
            return Double.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    static class DoubleParameter
    extends DoubleValueOrParameter {
        @Nonnull
        private final String parameter;

        DoubleParameter(@Nonnull String parameter) {
            this.parameter = parameter;
        }

        @Override
        public Double getValue(@Nonnull EvaluationContext context) {
            return (Double)context.getBinding(this.parameter);
        }

        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return this.parameter.hashCode();
        }

        public String toString() {
            return "$" + this.parameter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleParameter that = (DoubleParameter)o;
            return this.parameter.equals(that.parameter);
        }

        public int hashCode() {
            return this.parameter.hashCode();
        }
    }
}

