/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.spatial.geophile;

import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.query.FDBRecordStoreQueryTestBase;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.spatial.common.DoubleValueOrParameter;
import com.apple.foundationdb.record.spatial.common.GeoPointWithinDistanceComponent;
import com.apple.foundationdb.record.spatial.geophile.GeophilePointWithinDistanceQueryPlan;
import com.apple.foundationdb.record.spatial.geophile.GeophileSpatial;
import com.apple.foundationdb.record.spatial.geophile.GeophileSpatialIndexJoinPlan;
import com.apple.foundationdb.record.spatial.geophile.TestRecordsGeoProto;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Throwables;
import com.google.protobuf.Message;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="RequiresFDB")
public class GeophileQueryTest
extends FDBRecordStoreQueryTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeophileQueryTest.class);
    protected static KeyExpression LOCATION_LAT_LONG = Key.Expressions.field((String)"location").nest((KeyExpression)Key.Expressions.concatenateFields((String)"latitude", (String)"longitude", (String[])new String[0]));
    protected static final Index CITY_LOCATION_INDEX = new Index("City$location", (KeyExpression)Key.Expressions.function((String)"geophile_point_z", (KeyExpression)LOCATION_LAT_LONG), "spatial_geophile");
    protected static final Index CITY_LOCATION_COVERING_INDEX = new Index("City$location", (KeyExpression)Key.Expressions.keyWithValue((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"geophile_point_z", (KeyExpression)LOCATION_LAT_LONG), (KeyExpression)LOCATION_LAT_LONG, (KeyExpression[])new KeyExpression[0]), (int)1), "spatial_geophile");
    protected static final Index COUNTRY_SHAPE_INDEX = new Index("Country$shape", (KeyExpression)Key.Expressions.function((String)"geophile_json_z", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"shape"), (KeyExpression)Key.Expressions.value((Object)true), (KeyExpression[])new KeyExpression[0])), "spatial_geophile");

    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook) throws Exception {
        this.openAnyRecordStore(TestRecordsGeoProto.getDescriptor(), context, hook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCities(FDBRecordStoreTestBase.RecordMetaDataHook hook, int minPopulation) throws Exception {
        int count;
        int total = 0;
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, hook);
            try (FileInputStream file = new FileInputStream(".out/geonames/cities15000.txt");){
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)file, "UTF-8"));
                count = 0;
                while ((line = reader.readLine()) != null) {
                    String[] split = line.split("\t");
                    if (Integer.parseInt(split[14]) < minPopulation) continue;
                    TestRecordsGeoProto.City.Builder cityBuilder = TestRecordsGeoProto.City.newBuilder().setGeoNameId(Integer.parseInt(split[0])).setName(split[1]).setNameAscii(split[2]).setCountry(split[8]);
                    cityBuilder.getLocationBuilder().setLatitude(Double.parseDouble(split[4])).setLongitude(Double.parseDouble(split[5]));
                    this.recordStore.saveRecord((Message)cityBuilder.build());
                    if (++count <= 100) continue;
                    this.commit(context);
                    context.close();
                    total += count;
                    count = 0;
                    context = this.openContext();
                    this.recordStore = (FDBRecordStore)this.recordStore.asBuilder().setContext(context).open();
                }
                this.commit(context);
            }
        }
        LOGGER.info(KeyValueLogMessage.of((String)"Loaded cities", (Object[])new Object[]{"count", total += count}));
    }

    protected void loadCountries(FDBRecordStoreTestBase.RecordMetaDataHook hook, int minPopulation) throws Exception {
        int total = 0;
        try (FileInputStream file = new FileInputStream(".out/geonames/countryInfo.txt");
             FDBRecordContext context = this.openContext();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)file, "UTF-8"));
            this.openRecordStore(context, hook);
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                try {
                    String[] split = line.split("\t");
                    if (Integer.parseInt(split[7]) < minPopulation) continue;
                    TestRecordsGeoProto.Country.Builder countryBuilder = TestRecordsGeoProto.Country.newBuilder().setGeoNameId(Integer.parseInt(split[16])).setName(split[4]).setCode(split[0]);
                    this.recordStore.saveRecord((Message)countryBuilder.build());
                    ++total;
                }
                catch (Exception ex) {
                    LOGGER.error("loadCountries(): Failed to parse line " + line, (Throwable)ex);
                }
            }
            this.commit(context);
        }
        LOGGER.info(KeyValueLogMessage.of((String)"Loaded countries", (Object[])new Object[]{"count", total}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCountryShapes(FDBRecordStoreTestBase.RecordMetaDataHook hook) throws Exception {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, hook);
            try (FileInputStream file = new FileInputStream(".out/geonames/shapes_all_low.txt");){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)file, "UTF-8"));
                String line = reader.readLine();
                int count = 0;
                while ((line = reader.readLine()) != null) {
                    try {
                        String[] split = line.split("\t");
                        FDBStoredRecord country = this.recordStore.loadRecord(Tuple.from((Object[])new Object[]{Integer.parseInt(split[0])}));
                        if (country == null) {
                            LOGGER.warn(KeyValueLogMessage.of((String)"country not found", (Object[])new Object[]{"country", split[0]}));
                            continue;
                        }
                        TestRecordsGeoProto.Country.Builder countryBuilder = TestRecordsGeoProto.Country.newBuilder().mergeFrom(country.getRecord()).setShape(split[1]);
                        this.recordStore.saveRecord((Message)countryBuilder.build());
                        if (++count <= 100) continue;
                        this.commit(context);
                        context.close();
                        context = this.openContext();
                        this.recordStore = (FDBRecordStore)this.recordStore.asBuilder().setContext(context).open();
                        count = 0;
                    }
                    catch (Exception ex) {
                        LOGGER.error("loadCountryShapes(): Failed to parse line " + line, (Throwable)ex);
                    }
                }
                this.commit(context);
            }
        }
    }

    @Nonnull
    protected RecordQueryPlan distanceFilter(double distance, RecordQueryPlan input) {
        return new RecordQueryFilterPlan(input, Query.field((String)"location").matches((QueryComponent)new GeoPointWithinDistanceComponent(DoubleValueOrParameter.parameter((String)"center_latitude"), DoubleValueOrParameter.parameter((String)"center_longitude"), DoubleValueOrParameter.value((double)distance), "latitude", "longitude")));
    }

    @Nonnull
    protected RecordQueryPlan distanceFilterScan(double distance) {
        return this.distanceFilter(distance, (RecordQueryPlan)new RecordQueryTypeFilterPlan((RecordQueryPlan)new RecordQueryScanPlan(ScanComparisons.EMPTY, false), Collections.singleton("City")));
    }

    @Nonnull
    protected RecordQueryPlan distanceSpatialQuery(double distance, boolean covering) {
        GeophilePointWithinDistanceQueryPlan spatialQuery = new GeophilePointWithinDistanceQueryPlan(DoubleValueOrParameter.parameter((String)"center_latitude"), DoubleValueOrParameter.parameter((String)"center_longitude"), DoubleValueOrParameter.value((double)distance), "City$location", ScanComparisons.EMPTY, covering);
        if (covering) {
            return spatialQuery;
        }
        return this.distanceFilter(distance, (RecordQueryPlan)spatialQuery);
    }

    @Nonnull
    protected EvaluationContext bindCenter(int cityId) {
        Bindings.Builder bindings = Bindings.newBuilder();
        FDBStoredRecord city = this.recordStore.loadRecord(Tuple.from((Object[])new Object[]{cityId}));
        if (city == null) {
            LOGGER.warn(KeyValueLogMessage.of((String)"city not found", (Object[])new Object[]{"city", cityId}));
        } else {
            TestRecordsGeoProto.City.Builder cityBuilder = TestRecordsGeoProto.City.newBuilder().mergeFrom(city.getRecord());
            bindings.set("center_latitude", (Object)cityBuilder.getLocation().getLatitude());
            bindings.set("center_longitude", (Object)cityBuilder.getLocation().getLongitude());
        }
        return EvaluationContext.forBindings((Bindings)bindings.build());
    }

    @Test
    @Tag(value="Slow")
    public void testDistance() throws Exception {
        RecordCursor recordCursor;
        FDBRecordStoreTestBase.RecordMetaDataHook hook = md -> md.addIndex("City", CITY_LOCATION_COVERING_INDEX);
        this.loadCities(hook, 0);
        int centerId = 5391959;
        double distance = 1.0;
        int scanLimit = 5000;
        RecordQueryPlan scanPlan = this.distanceFilterScan(1.0);
        HashSet scanResults = new HashSet();
        byte[] continuation = null;
        do {
            try (FDBRecordContext context = this.openContext();){
                this.openRecordStore(context, hook);
                EvaluationContext joinContext = this.bindCenter(5391959);
                ExecuteProperties executeProperties = ExecuteProperties.newBuilder().setScannedRecordsLimit(5000).build();
                recordCursor = scanPlan.execute(this.recordStore, joinContext, continuation, executeProperties);
                recordCursor.forEach(city -> {
                    TestRecordsGeoProto.City.Builder cityBuilder = TestRecordsGeoProto.City.newBuilder().mergeFrom(city.getRecord());
                    LOGGER.debug(KeyValueLogMessage.of((String)"Scan found", (Object[])new Object[]{"geo_name_id", cityBuilder.getGeoNameId(), "city", cityBuilder.getName()}));
                    scanResults.add(cityBuilder.getGeoNameId());
                }).join();
                continuation = recordCursor.getNext().getContinuation().toBytes();
                this.commit(context);
            }
        } while (continuation != null);
        RecordQueryPlan indexPlan = this.distanceSpatialQuery(1.0, false);
        HashSet indexResults = new HashSet();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, hook);
            recordCursor = indexPlan.execute(this.recordStore, this.bindCenter(5391959));
            recordCursor.forEach(city -> {
                TestRecordsGeoProto.City.Builder cityBuilder = TestRecordsGeoProto.City.newBuilder().mergeFrom(city.getRecord());
                LOGGER.debug(KeyValueLogMessage.of((String)"Index found", (Object[])new Object[]{"geo_name_id", cityBuilder.getGeoNameId(), "city", cityBuilder.getName()}));
                indexResults.add(cityBuilder.getGeoNameId());
            }).join();
            int given = this.timer.getCount((StoreTimer.Event)FDBStoreTimer.Counts.QUERY_FILTER_GIVEN);
            int passed = this.timer.getCount((StoreTimer.Event)FDBStoreTimer.Counts.QUERY_FILTER_PASSED);
            int discarded = this.timer.getCount((StoreTimer.Event)FDBStoreTimer.Counts.QUERY_DISCARDED);
            MatcherAssert.assertThat((String)"Should have passed more than discarded", (Object)passed, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(discarded)));
            this.commit(context);
        }
        RecordQueryPlan coveringPlan = this.distanceSpatialQuery(1.0, true);
        HashSet coveringResults = new HashSet();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, hook);
            RecordCursor recordCursor2 = indexPlan.execute(this.recordStore, this.bindCenter(5391959));
            recordCursor2.forEach(city -> {
                TestRecordsGeoProto.City.Builder cityBuilder = TestRecordsGeoProto.City.newBuilder().mergeFrom(city.getRecord());
                LOGGER.debug(KeyValueLogMessage.of((String)"Covering found", (Object[])new Object[]{"geo_name_id", cityBuilder.getGeoNameId(), "city", cityBuilder.getName()}));
                coveringResults.add(cityBuilder.getGeoNameId());
            }).join();
            this.commit(context);
        }
        Assertions.assertEquals(scanResults, indexResults);
        Assertions.assertEquals(scanResults, coveringResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Tag(value="Slow")
    public void testJoin() throws Exception {
        FDBRecordStoreTestBase.RecordMetaDataHook hook = md -> {
            md.setSplitLongRecords(true);
            md.addIndex("City", CITY_LOCATION_INDEX);
            md.addIndex("Country", COUNTRY_SHAPE_INDEX);
        };
        this.loadCities(hook, 500000);
        this.loadCountries(hook, 500000);
        this.loadCountryShapes(hook);
        GeophileSpatialIndexJoinPlan plan = new GeophileSpatialIndexJoinPlan("City$location", ScanComparisons.EMPTY, "Country$shape", ScanComparisons.EMPTY);
        int[] stats = new int[4];
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, hook);
            RecordCursor recordCursor = plan.execute((FDBRecordStoreBase)this.recordStore, EvaluationContext.EMPTY);
            GeometryFactory geometryFactory = new GeometryFactory();
            GeoJsonReader geoJsonReader = new GeoJsonReader(geometryFactory);
            recordCursor.forEach(pair -> {
                boolean contained;
                Geometry countryShape;
                TestRecordsGeoProto.City.Builder cityBuilder = TestRecordsGeoProto.City.newBuilder().mergeFrom(((FDBIndexedRecord)pair.getLeft()).getRecord());
                TestRecordsGeoProto.Country.Builder countryBuilder = TestRecordsGeoProto.Country.newBuilder().mergeFrom(((FDBIndexedRecord)pair.getRight()).getRecord());
                Point cityLocation = geometryFactory.createPoint(new Coordinate(cityBuilder.getLocation().getLatitude(), cityBuilder.getLocation().getLongitude()));
                try {
                    countryShape = GeophileSpatial.swapLatLong((Geometry)geoJsonReader.read(countryBuilder.getShape()));
                }
                catch (ParseException ex) {
                    throw new RuntimeException(ex);
                }
                try {
                    contained = countryShape.contains((Geometry)cityLocation);
                }
                catch (TopologyException ex) {
                    stats[3] = stats[3] + 1;
                    return;
                }
                if (!contained) {
                    stats[2] = stats[2] + 1;
                } else if (!countryBuilder.getCode().equals(cityBuilder.getCountry())) {
                    LOGGER.warn(KeyValueLogMessage.of((String)"Code does not match", (Object[])new Object[]{"country_code", countryBuilder.getCode(), "country_name", countryBuilder.getName(), "city_country", cityBuilder.getCountry(), "city", cityBuilder.getName()}));
                    stats[1] = stats[1] + 1;
                } else {
                    LOGGER.debug(KeyValueLogMessage.of((String)"join result", (Object[])new Object[]{"country_name", countryBuilder.getName(), "city", cityBuilder.getName()}));
                    stats[0] = stats[0] + 1;
                }
            }).join();
            this.commit(context);
        }
        catch (CompletionException ex) {
            try {
                MatcherAssert.assertThat((Object)Throwables.getRootCause((Throwable)ex), (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(FDBException.class), (Matcher)Matchers.hasProperty((String)"code", (Matcher)Matchers.equalTo((Object)1007))));
            }
            catch (Throwable throwable) {
                LOGGER.info(KeyValueLogMessage.of((String)"testJoin stats", (Object[])new Object[]{"match", stats[0], "no_match", stats[1], "no_overlap", stats[2], "invalid_geometry", stats[3]}));
                throw throwable;
            }
            LOGGER.info(KeyValueLogMessage.of((String)"testJoin stats", (Object[])new Object[]{"match", stats[0], "no_match", stats[1], "no_overlap", stats[2], "invalid_geometry", stats[3]}));
        }
        LOGGER.info(KeyValueLogMessage.of((String)"testJoin stats", (Object[])new Object[]{"match", stats[0], "no_match", stats[1], "no_overlap", stats[2], "invalid_geometry", stats[3]}));
    }

    @Test
    public void testNulls() throws Exception {
        FDBRecordStoreTestBase.RecordMetaDataHook hook = md -> {
            md.addIndex("City", CITY_LOCATION_INDEX);
            md.addIndex("Country", COUNTRY_SHAPE_INDEX);
        };
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, hook);
            TestRecordsGeoProto.City.Builder cityBuilder = TestRecordsGeoProto.City.newBuilder().setGeoNameId(-1);
            this.recordStore.saveRecord((Message)cityBuilder.build());
            TestRecordsGeoProto.Country.Builder countryBuilder = TestRecordsGeoProto.Country.newBuilder().setGeoNameId(-2);
            this.recordStore.saveRecord((Message)countryBuilder.build());
        }
    }
}

