/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.search;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.lucene.query.BitSetQuery;
import com.apple.foundationdb.record.lucene.search.BooleanPointsConfig;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.lucene.document.BinaryPoint;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;

public interface ConfigAwareQueryParser {
    @Nonnull
    public Map<String, PointsConfig> getPointsConfig();

    @Nonnull
    public Query constructFieldWithoutPointsConfig(String var1, String var2, boolean var3) throws ParseException;

    @Nonnull
    public Token nextToken();

    @Nonnull
    default public Query attemptConstructFieldQueryWithPointsConfig(String field, String queryText, boolean quoted) throws ParseException {
        Number point;
        Map<String, PointsConfig> pointsConfig = this.getPointsConfig();
        PointsConfig cfg = pointsConfig.get(field);
        if (cfg == null) {
            return this.constructFieldWithoutPointsConfig(field, queryText, quoted);
        }
        if ("BITSET_CONTAINS".equalsIgnoreCase(queryText)) {
            return this.constructBitSetQuery(field);
        }
        if (cfg instanceof BooleanPointsConfig) {
            if ("true".equalsIgnoreCase(queryText)) {
                return BinaryPoint.newExactQuery((String)field, (byte[])BooleanPointsConfig.TRUE_BYTES);
            }
            return BinaryPoint.newExactQuery((String)field, (byte[])BooleanPointsConfig.FALSE_BYTES);
        }
        NumberFormat format = cfg.getNumberFormat();
        try {
            point = format.parse(queryText);
        }
        catch (java.text.ParseException pe) {
            throw new ParseException(QueryParserMessages.COULD_NOT_PARSE_NUMBER);
        }
        if (Integer.class.equals((Object)cfg.getType())) {
            return IntPoint.newExactQuery((String)field, (int)point.intValue());
        }
        if (Long.class.equals((Object)cfg.getType())) {
            return LongPoint.newExactQuery((String)field, (long)point.longValue());
        }
        if (Double.class.equals((Object)cfg.getType())) {
            return DoublePoint.newExactQuery((String)field, (double)point.doubleValue());
        }
        if (Float.class.equals((Object)cfg.getType())) {
            return FloatPoint.newExactQuery((String)field, (float)point.floatValue());
        }
        throw new ParseException("Unknown numeric type: " + cfg.getType().getCanonicalName());
    }

    @Nonnull
    private Query constructBitSetQuery(@Nonnull String field) throws ParseException {
        if (!"(".equals(this.nextToken().toString())) {
            throw new ParseException("Missing ( from BITSET_CONTAINS");
        }
        Token nextToken = this.nextToken();
        String bitMaskStr = nextToken.toString();
        if (!")".equals(this.nextToken().toString())) {
            throw new ParseException("Missing ) from BITSET_CONTAINS");
        }
        PointsConfig cfg = Objects.requireNonNull(this.getPointsConfig()).get(field);
        if (!Long.class.equals((Object)cfg.getType())) {
            throw new ParseException("Cannot parse a BITSET_CONTAINS on a non-long data type");
        }
        long bitMask = -1L;
        try {
            bitMask = Long.parseLong(bitMaskStr);
        }
        catch (NumberFormatException pe) {
            throw new ParseException(QueryParserMessages.COULD_NOT_PARSE_NUMBER);
        }
        return new BitSetQuery(field, bitMask);
    }

    @Nonnull
    public Query constructRangeQueryWithoutPointsConfig(String var1, String var2, String var3, boolean var4, boolean var5) throws ParseException;

    @Nonnull
    default public Query attemptConstructRangeQueryWithPointsConfig(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        Number end;
        Number start;
        Map<String, PointsConfig> pointsConfig = this.getPointsConfig();
        PointsConfig cfg = pointsConfig.get(field);
        if (cfg == null) {
            return this.constructRangeQueryWithoutPointsConfig(field, part1, part2, startInclusive, endInclusive);
        }
        if (cfg instanceof BooleanPointsConfig) {
            byte[] p1 = "true".equalsIgnoreCase(part1) ? BooleanPointsConfig.TRUE_BYTES : BooleanPointsConfig.FALSE_BYTES;
            byte[] p2 = "true".equalsIgnoreCase(part2) ? BooleanPointsConfig.TRUE_BYTES : BooleanPointsConfig.FALSE_BYTES;
            return BinaryPoint.newRangeQuery((String)field, (byte[])p1, (byte[])p2);
        }
        NumberFormat format = cfg.getNumberFormat();
        try {
            start = format.parse(part1);
            end = format.parse(part2);
        }
        catch (java.text.ParseException pe) {
            throw new ParseException(QueryParserMessages.COULD_NOT_PARSE_NUMBER);
        }
        if (Integer.class.equals((Object)cfg.getType())) {
            return this.newIntegerRangeQuery(field, startInclusive, endInclusive, start, end);
        }
        if (Long.class.equals((Object)cfg.getType())) {
            return this.newLongRangeQuery(field, startInclusive, endInclusive, start, end);
        }
        if (Double.class.equals((Object)cfg.getType())) {
            return this.newDoubleRangeQuery(field, startInclusive, endInclusive, start, end);
        }
        if (Float.class.equals((Object)cfg.getType())) {
            return this.newFloatRangeQuery(field, startInclusive, endInclusive, start, end);
        }
        throw new ParseException(QueryParserMessages.UNSUPPORTED_NUMERIC_DATA_TYPE);
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="Floating point values are special sentinel values")
    private Query newFloatRangeQuery(String field, boolean startInclusive, boolean endInclusive, Number start, Number end) throws ParseException {
        float e;
        float s = start.floatValue();
        if (s > (e = end.floatValue())) {
            throw new ParseException(QueryParserMessages.INVALID_SYNTAX);
        }
        if (!startInclusive) {
            if (s == Float.MAX_VALUE || s == Float.POSITIVE_INFINITY) {
                return FloatPoint.newSetQuery((String)field, (float[])new float[0]);
            }
            s = Math.nextAfter(s, 3.4028234663852886E38);
        }
        if (!endInclusive) {
            if (e == Float.MIN_VALUE || e == Float.NEGATIVE_INFINITY) {
                return FloatPoint.newSetQuery((String)field, (float[])new float[0]);
            }
            e = Math.nextAfter(e, -3.4028234663852886E38);
        }
        return FloatPoint.newRangeQuery((String)field, (float)s, (float)e);
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="Floating point values are special sentinel values")
    private Query newDoubleRangeQuery(String field, boolean startInclusive, boolean endInclusive, Number start, Number end) throws ParseException {
        double e;
        double s = start.doubleValue();
        if (s > (e = end.doubleValue())) {
            throw new ParseException(QueryParserMessages.INVALID_SYNTAX);
        }
        if (!startInclusive) {
            if (s == Double.MAX_VALUE || s == Double.POSITIVE_INFINITY) {
                return DoublePoint.newSetQuery((String)field, (double[])new double[0]);
            }
            s = Math.nextAfter(s, Double.MAX_VALUE);
        }
        if (!endInclusive) {
            if (e == Double.MIN_VALUE || e == Double.NEGATIVE_INFINITY) {
                return DoublePoint.newSetQuery((String)field, (double[])new double[0]);
            }
            e = Math.nextAfter(e, -1.7976931348623157E308);
        }
        return DoublePoint.newRangeQuery((String)field, (double)s, (double)e);
    }

    @Nonnull
    private Query newLongRangeQuery(String field, boolean startInclusive, boolean endInclusive, Number start, Number end) throws ParseException {
        long e;
        long s = start.longValue();
        if (s > (e = end.longValue())) {
            throw new ParseException(QueryParserMessages.INVALID_SYNTAX);
        }
        if (!startInclusive) {
            if (s == Long.MAX_VALUE) {
                return LongPoint.newSetQuery((String)field, (long[])new long[0]);
            }
            s = Math.incrementExact(s);
        }
        if (!endInclusive) {
            if (e == Long.MIN_VALUE) {
                return LongPoint.newSetQuery((String)field, (long[])new long[0]);
            }
            e = Math.decrementExact(e);
        }
        return LongPoint.newRangeQuery((String)field, (long)s, (long)e);
    }

    @Nonnull
    private Query newIntegerRangeQuery(String field, boolean startInclusive, boolean endInclusive, Number start, Number end) throws ParseException {
        int e;
        int s = start.intValue();
        if (s > (e = end.intValue())) {
            throw new ParseException(QueryParserMessages.INVALID_SYNTAX);
        }
        if (!startInclusive) {
            if (s == Integer.MAX_VALUE) {
                return IntPoint.newSetQuery((String)field, (int[])new int[0]);
            }
            s = Math.addExact(s, 1);
        }
        if (!endInclusive) {
            if (e == Integer.MIN_VALUE) {
                return IntPoint.newSetQuery((String)field, (int[])new int[0]);
            }
            e = Math.addExact(e, -1);
        }
        return IntPoint.newRangeQuery((String)field, (int)s, (int)e);
    }

    @Nonnull
    default public Query addSlop(Query q, int slop) {
        SpanNearQuery snq;
        if (q instanceof PhraseQuery) {
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            PhraseQuery pq = (PhraseQuery)q;
            Term[] terms = pq.getTerms();
            int[] positions = pq.getPositions();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(terms[i], positions[i]);
            }
            q = builder.build();
        } else if (q instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)q;
            if (slop != mpq.getSlop()) {
                q = new MultiPhraseQuery.Builder(mpq).setSlop(slop).build();
            }
        } else if (q instanceof SpanNearQuery && slop != (snq = (SpanNearQuery)q).getSlop()) {
            SpanNearQuery.Builder builder = new SpanNearQuery.Builder(snq.getField(), snq.isInOrder());
            for (SpanQuery sq : snq.getClauses()) {
                builder.addClause(sq);
            }
            builder.setSlop(slop);
            q = builder.build();
        }
        return q;
    }
}

