/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.ngram;

import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.lucene.AnalyzerChooser;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerFactory;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import com.apple.foundationdb.record.metadata.Index;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;

public class NgramAnalyzer
extends StopwordAnalyzerBase {
    private static final String DEFAULT_MINIMUM_NGRAM_TOKEN_LENGTH = "3";
    private static final String DEFAULT_MAXIMUM_NGRAM_TOKEN_LENGTH = "30";
    private static final String DEFAULT_NGRAM_WITH_EDGES_ONLY = "false";
    private final int minTokenLength;
    private final int maxTokenLength;
    private final boolean edgesOnly;

    public NgramAnalyzer(@Nullable CharArraySet stopwords, int minTokenLength, int maxTokenLength, boolean edgesOnly) {
        super(stopwords);
        this.minTokenLength = minTokenLength;
        this.maxTokenLength = maxTokenLength;
        this.edgesOnly = edgesOnly;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        UAX29URLEmailTokenizer src = new UAX29URLEmailTokenizer();
        LowerCaseFilter tok = new LowerCaseFilter((TokenStream)src);
        tok = new StopFilter((TokenStream)tok, this.stopwords);
        tok = this.edgesOnly ? new EdgeNGramTokenFilter((TokenStream)tok, this.minTokenLength, this.maxTokenLength, true) : new NGramTokenFilter((TokenStream)tok, this.minTokenLength, this.maxTokenLength, true);
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tok);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    public static class NgramAnalyzerFactory
    implements LuceneAnalyzerFactory {
        public static final String ANALYZER_FACTORY_NAME = "NGRAM";

        @Override
        @Nonnull
        public String getName() {
            return ANALYZER_FACTORY_NAME;
        }

        @Override
        @Nonnull
        public LuceneAnalyzerType getType() {
            return LuceneAnalyzerType.FULL_TEXT;
        }

        @Override
        @Nonnull
        public AnalyzerChooser getIndexAnalyzerChooser(@Nonnull Index index) {
            try {
                String minLengthString = Optional.ofNullable(index.getOption("textTokenMinSize")).orElse(NgramAnalyzer.DEFAULT_MINIMUM_NGRAM_TOKEN_LENGTH);
                String maxLengthString = Optional.ofNullable(index.getOption("textTokenMaxSize")).orElse(NgramAnalyzer.DEFAULT_MAXIMUM_NGRAM_TOKEN_LENGTH);
                String edgesOnly = Optional.ofNullable(index.getOption("ngramTokenEdgesOnly")).orElse(NgramAnalyzer.DEFAULT_NGRAM_WITH_EDGES_ONLY);
                return () -> new LuceneAnalyzerWrapper(ANALYZER_FACTORY_NAME, (Analyzer)new NgramAnalyzer(EnglishAnalyzer.ENGLISH_STOP_WORDS_SET, Integer.parseInt(minLengthString), Integer.parseInt(maxLengthString), Boolean.parseBoolean(edgesOnly)));
            }
            catch (NumberFormatException ex) {
                throw new RecordCoreArgumentException("Invalid index option for token size", (Throwable)ex);
            }
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            NgramAnalyzerFactory otherFactory = (NgramAnalyzerFactory)other;
            return Objects.equals(this.getName(), otherFactory.getName());
        }

        public int hashCode() {
            return Objects.hashCode(this.getName());
        }
    }
}

