/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.lucene.directory.MergeUtils;
import com.apple.foundationdb.record.provider.foundationdb.IndexDeferredMaintenanceControl;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.TieredMergePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class FDBTieredMergePolicy
extends TieredMergePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBTieredMergePolicy.class);
    @Nullable
    private final IndexDeferredMaintenanceControl mergeControl;
    private final AgilityContext context;
    @Nonnull
    private final Subspace indexSubspace;
    @Nonnull
    private final Tuple key;
    @Nullable
    private final Exception exceptionAtCreation;

    public FDBTieredMergePolicy(@Nullable IndexDeferredMaintenanceControl mergeControl, @Nonnull AgilityContext context, @Nonnull Subspace indexSubspace, @Nonnull Tuple key, @Nullable Exception exceptionAtCreation) {
        this.mergeControl = mergeControl;
        this.context = context;
        this.indexSubspace = indexSubspace;
        this.key = key;
        this.exceptionAtCreation = exceptionAtCreation;
    }

    public static boolean usesCreationStack() {
        return LOGGER.isDebugEnabled();
    }

    boolean isAutoMergeDuringCommit(MergeTrigger mergeTrigger) {
        return mergeTrigger == MergeTrigger.FULL_FLUSH || mergeTrigger == MergeTrigger.COMMIT;
    }

    private int specSize(@Nullable MergePolicy.MergeSpecification spec) {
        return spec != null && spec.merges != null ? spec.merges.size() : 0;
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        if (this.mergeControl == null) {
            MergePolicy.MergeSpecification merges = super.findMerges(mergeTrigger, infos, mergeContext);
            MergeUtils.logFoundMerges(LOGGER, "Found Merges without mergeControl", this.context, this.indexSubspace, this.key, mergeTrigger, merges, this.exceptionAtCreation);
            return merges;
        }
        if (!this.mergeControl.shouldAutoMergeDuringCommit() && this.isAutoMergeDuringCommit(mergeTrigger)) {
            return null;
        }
        long startTime = System.nanoTime();
        MergePolicy.MergeSpecification spec = super.findMerges(mergeTrigger, infos, mergeContext);
        long mergesLimit = this.mergeControl.getMergesLimit();
        int originSpecSize = this.specSize(spec);
        this.mergeControl.setMergesFound((long)originSpecSize);
        if (mergesLimit > 0L && originSpecSize > 0 && mergesLimit < (long)originSpecSize) {
            MergePolicy.MergeSpecification dilutedSpec = new MergePolicy.MergeSpecification();
            int i = 0;
            while ((long)i < mergesLimit) {
                dilutedSpec.add((MergePolicy.OneMerge)spec.merges.get(i));
                ++i;
            }
            spec = dilutedSpec;
        }
        this.mergeControl.setMergesTried((long)this.specSize(spec));
        this.context.recordEvent(LuceneEvents.Events.LUCENE_FIND_MERGES, System.nanoTime() - startTime);
        MergeUtils.logFoundMerges(LOGGER, "Found Merges", this.context, this.indexSubspace, this.key, mergeTrigger, spec, this.exceptionAtCreation);
        return spec;
    }
}

