/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.google.common.base.Verify;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.store.IndexInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class FDBIndexInput
extends IndexInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBIndexInput.class);
    private final String fileName;
    private final FDBDirectory fdbDirectory;
    private final CompletableFuture<FDBLuceneFileReference> reference;
    private long position;
    private CompletableFuture<byte[]> currentData;
    private int currentBlock;
    private final long initialOffset;
    private int numberOfSeeks = 0;
    private byte[] actualCurrentData;
    private FDBLuceneFileReference actualReference;

    public FDBIndexInput(@Nonnull String fileName, @Nonnull FDBDirectory fdbDirectory) throws IOException {
        this(fileName, fileName, fdbDirectory, fdbDirectory.getFDBLuceneFileReferenceAsync(fileName), 0L, 0L, 0, null);
    }

    public FDBIndexInput(@Nonnull String resourceDescription, @Nonnull String fileName, @Nonnull FDBDirectory fdbDirectory, @Nonnull CompletableFuture<FDBLuceneFileReference> reference, long initialOffset, long position, int currentBlock, @Nullable CompletableFuture<byte[]> currentData) throws IOException {
        super(resourceDescription);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(KeyValueLogMessage.of((String)"init()", (Object[])new Object[]{LuceneLogMessageKeys.RESOURCE, fileName}));
        }
        this.fileName = fileName;
        this.fdbDirectory = fdbDirectory;
        this.reference = reference;
        this.position = position;
        this.currentBlock = currentBlock;
        this.currentData = currentData;
        this.initialOffset = initialOffset;
        if (currentData == null) {
            ++this.numberOfSeeks;
            this.readBlock();
        } else {
            this.seek(position);
        }
    }

    @Nonnull
    private FDBLuceneFileReference getFileReference() {
        if (this.actualReference == null) {
            this.actualReference = this.fdbDirectory.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_GET_FILE_REFERENCE, this.reference);
            if (this.actualReference == null) {
                throw new RecordCoreException("File Reference missing for open IndexInput", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.RESOURCE, this.fileName});
            }
        }
        return this.actualReference;
    }

    private byte[] getCurrentData() {
        if (this.actualCurrentData == null) {
            this.actualCurrentData = this.fdbDirectory.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_GET_DATA_BLOCK, this.currentData);
        }
        return this.actualCurrentData;
    }

    private void readBlock() {
        this.currentData = this.fdbDirectory.readBlock((IndexInput)this, this.fileName, this.reference, this.currentBlock);
        this.actualCurrentData = null;
    }

    public void close() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("close()", new Object[]{LuceneLogMessageKeys.SEEK_NUM, this.numberOfSeeks}));
        }
    }

    public long getFilePointer() {
        return this.position;
    }

    public void seek(long offset) throws IOException {
        try {
            if (this.currentBlock != this.getBlock(offset)) {
                this.position = offset;
                this.currentBlock = this.getBlock(this.position);
                ++this.numberOfSeeks;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(this.getLogMessage("actual seek", new Object[]{LuceneLogMessageKeys.OFFSET, offset}));
                }
                this.readBlock();
            } else {
                this.position = offset;
            }
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public long length() {
        return this.getFileReference().getSize();
    }

    @Nonnull
    public IndexInput slice(@Nonnull String sliceDescription, long offset, long length) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("slice", new Object[]{LogMessageKeys.DESCRIPTION, sliceDescription, LuceneLogMessageKeys.OFFSET, offset, LuceneLogMessageKeys.LENGTH, length}));
        }
        try {
            FDBLuceneFileReference fileReference = this.getFileReference();
            return new FDBIndexInput(this.getFullSliceDescription(sliceDescription), this.fileName, this.fdbDirectory, CompletableFuture.completedFuture(new FDBLuceneFileReference(fileReference.getId(), length, length, fileReference.getBlockSize())), offset + this.initialOffset, 0L, this.currentBlock, this.currentData);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    private long absolutePosition() {
        return this.position + this.initialOffset;
    }

    public byte readByte() throws IOException {
        FDBLuceneFileReference fileReference;
        try {
            fileReference = this.getFileReference();
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
        if (this.position >= fileReference.getSize()) {
            throw new EOFException("read past EOF: " + String.valueOf((Object)this));
        }
        try {
            int probe = (int)(this.absolutePosition() % fileReference.getBlockSize());
            ++this.position;
            byte[] data = this.getCurrentData();
            Verify.verify((data != null ? 1 : 0) != 0, (String)("current Data is null: " + this.fileName + " " + fileReference.getId()), (Object[])new Object[0]);
            byte by = data[probe];
            return by;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
        finally {
            if (this.absolutePosition() % fileReference.getBlockSize() == 0L) {
                ++this.currentBlock;
                ++this.numberOfSeeks;
                this.readBlock();
            }
        }
    }

    public void readBytes(@Nonnull byte[] bytes, int offset, int length) throws IOException {
        try {
            int bytesRead = 0;
            FDBLuceneFileReference fileReference = this.getFileReference();
            if (this.position + (long)length > fileReference.getSize()) {
                throw new EOFException("read past EOF: " + String.valueOf((Object)this));
            }
            long blockSize = fileReference.getBlockSize();
            while (bytesRead < length) {
                long inBlockPosition = this.absolutePosition() % blockSize;
                int toRead = (int)((long)(length - bytesRead) + inBlockPosition > blockSize ? blockSize - inBlockPosition : (long)(length - bytesRead));
                System.arraycopy(this.getCurrentData(), (int)inBlockPosition, bytes, bytesRead + offset, toRead);
                bytesRead += toRead;
                this.position += (long)toRead;
                if (this.absolutePosition() % blockSize != 0L) continue;
                ++this.currentBlock;
                ++this.numberOfSeeks;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(this.getLogMessage("hard seek", new Object[]{LuceneLogMessageKeys.CURRENT_BLOCK, this.currentBlock, LuceneLogMessageKeys.OFFSET, offset, LuceneLogMessageKeys.LENGTH, length, LuceneLogMessageKeys.POSITION, this.position, LuceneLogMessageKeys.INITIAL_OFFSET, this.initialOffset}));
                }
                this.readBlock();
            }
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public int getBlock(long position) {
        return (int)((position + this.initialOffset) / this.getFileReference().getBlockSize());
    }

    @Nonnull
    private String getLogMessage(@Nonnull String staticMsg, Object ... keysAndValues) {
        return KeyValueLogMessage.build((String)staticMsg, (Object[])keysAndValues).addKeyAndValue((Object)LogMessageKeys.SUBSPACE, (Object)this.fdbDirectory.getSubspace()).addKeyAndValue((Object)LuceneLogMessageKeys.RESOURCE, (Object)this.fileName).toString();
    }

    public int prefetch(int beginBlock, int length) {
        for (int i = 0; i < length; ++i) {
            this.fdbDirectory.readBlock((IndexInput)this, this.fileName, this.reference, beginBlock + i);
        }
        return length;
    }
}

