/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.lucene.directory.FDBDirectorySharedCache;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@API(value=API.Status.EXPERIMENTAL)
@ThreadSafe
public class FDBDirectorySharedCacheManager {
    public static final Object SHARED_CACHE_CONTEXT_KEY = new Object();
    @Nonnull
    private final Map<Tuple, FDBDirectorySharedCache> caches;
    @Nullable
    private final Subspace subspace;
    private final int maximumSize;
    private final int concurrencyLevel;
    private final int initialCapacity;

    @Nullable
    public Subspace getSubspace() {
        return this.subspace;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    @Nullable
    public static FDBDirectorySharedCacheManager forContext(@Nonnull FDBRecordContext context) {
        return (FDBDirectorySharedCacheManager)context.getInSession(SHARED_CACHE_CONTEXT_KEY, FDBDirectorySharedCacheManager.class);
    }

    public void setForContext(@Nonnull FDBRecordContext context) {
        context.putInSessionIfAbsent(SHARED_CACHE_CONTEXT_KEY, (Object)this);
    }

    protected FDBDirectorySharedCacheManager(@Nullable Subspace subspace, int maximumSize, int concurrencyLevel, int initialCapacity) {
        this.subspace = subspace;
        this.maximumSize = maximumSize;
        this.concurrencyLevel = concurrencyLevel;
        this.initialCapacity = initialCapacity;
        this.caches = new ConcurrentHashMap<Tuple, FDBDirectorySharedCache>();
    }

    @Nullable
    public FDBDirectorySharedCache getCache(@Nonnull Tuple key, long sequenceNumber) {
        FDBDirectorySharedCache storedCache = this.caches.compute(key, (ckey, cache) -> {
            if (cache == null || cache.getSequenceNumber() < sequenceNumber) {
                cache = new FDBDirectorySharedCache((Tuple)ckey, sequenceNumber, this.maximumSize, this.concurrencyLevel, this.initialCapacity);
            }
            return cache;
        });
        if (storedCache.getSequenceNumber() == sequenceNumber) {
            return storedCache;
        }
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Subspace subspace;
        private int maximumSize = 1024;
        private int concurrencyLevel = 16;
        private int initialCapacity = 128;

        protected Builder() {
        }

        public Builder setSubspace(Subspace subspace) {
            this.subspace = subspace;
            return this;
        }

        public Builder setMaximumSize(int maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public Builder setConcurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder setInitialCapacity(int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        public FDBDirectorySharedCacheManager build() {
            return new FDBDirectorySharedCacheManager(this.subspace, this.maximumSize, this.concurrencyLevel, this.initialCapacity);
        }
    }
}

