/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndex;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedStoredFieldsWriter;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.google.protobuf.ByteString;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SegmentInfo;

class PrimaryKeyAndStoredFieldsWriter
extends LuceneOptimizedStoredFieldsWriter {
    private final LucenePrimaryKeySegmentIndex lucenePrimaryKeySegmentIndex;
    private final long segmentId;
    private int documentId;

    PrimaryKeyAndStoredFieldsWriter(SegmentInfo segmentInfo, @Nonnull FDBDirectory directory) throws IOException {
        super(directory, segmentInfo);
        this.segmentId = directory.primaryKeySegmentId(segmentInfo.name, true);
        this.lucenePrimaryKeySegmentIndex = directory.getPrimaryKeySegmentIndex();
    }

    @Override
    public void finishDocument() throws IOException {
        super.finishDocument();
        ++this.documentId;
    }

    @Override
    public void writeField(FieldInfo info, IndexableField field) throws IOException {
        super.writeField(info, field);
        try {
            if ("_p".equals(info.name)) {
                byte[] primaryKey = field.binaryValue().bytes;
                this.lucenePrimaryKeySegmentIndex.addOrDeletePrimaryKeyEntry(primaryKey, this.segmentId, this.documentId, true, info.name);
                this.storedFields.setPrimaryKey(ByteString.copyFrom((byte[])primaryKey));
            }
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }
}

