/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneStoredFieldsProto;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneOptimizedStoredFieldsWriter
extends StoredFieldsWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneOptimizedStoredFieldsWriter.class);
    protected LuceneStoredFieldsProto.LuceneStoredFields.Builder storedFields;
    private final FDBDirectory directory;
    private final String segmentName;
    private int docId;

    public LuceneOptimizedStoredFieldsWriter(FDBDirectory directory, SegmentInfo si) throws IOException {
        this.directory = directory;
        this.docId = 0;
        this.segmentName = si.name;
    }

    public void startDocument() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("startDocument");
        }
        this.storedFields = LuceneStoredFieldsProto.LuceneStoredFields.newBuilder();
    }

    public void finishDocument() throws IOException {
        try {
            this.directory.writeStoredFields(this.segmentName, this.docId, this.storedFields.build().toByteArray());
            ++this.docId;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeField(FieldInfo info, IndexableField field) throws IOException {
        try {
            LuceneStoredFieldsProto.StoredField.Builder builder = LuceneStoredFieldsProto.StoredField.newBuilder();
            builder.setFieldNumber(info.number);
            Number number = field.numericValue();
            if (number != null) {
                if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
                    builder.setIntValue(number.intValue());
                } else if (number instanceof Long) {
                    builder.setLongValue(number.longValue());
                } else if (number instanceof Float) {
                    builder.setFloatValue(number.floatValue());
                } else {
                    if (!(number instanceof Double)) throw new IllegalArgumentException("cannot store numeric type " + String.valueOf(number.getClass()));
                    builder.setDoubleValue(number.doubleValue());
                }
            } else {
                BytesRef bytes = field.binaryValue();
                if (bytes != null) {
                    builder.setBytesValue(ByteString.copyFrom((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length));
                } else {
                    String string = field.stringValue();
                    if (string == null) {
                        throw new IllegalArgumentException("field " + field.name() + " is stored but does not have binaryValue, stringValue nor numericValue");
                    }
                    builder.setStringValue(string);
                }
            }
            this.storedFields.addStoredFields(builder);
            return;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public void finish(FieldInfos fis, int numDocs) throws IOException {
        if (this.docId != numDocs) {
            throw new RuntimeException("Wrote " + this.docId + " docs, finish called with numDocs=" + numDocs);
        }
    }

    public int merge(MergeState mergeState) throws IOException {
        try {
            StoredFieldsMergeSub sub;
            ArrayList<StoredFieldsMergeSub> subs = new ArrayList<StoredFieldsMergeSub>();
            for (int i = 0; i < mergeState.storedFieldsReaders.length; ++i) {
                subs.add(new StoredFieldsMergeSub(new StoredFieldsWriter.MergeVisitor((StoredFieldsWriter)this, mergeState, i), mergeState.docMaps[i], mergeState.storedFieldsReaders[i], mergeState.maxDocs[i]));
            }
            DocIDMerger docIDMerger = DocIDMerger.of(subs, (boolean)mergeState.needsIndexSort);
            int docCount = 0;
            while ((sub = (StoredFieldsMergeSub)docIDMerger.next()) != null) {
                assert (sub.mappedDocID == docCount);
                this.startDocument();
                sub.reader.visitDocument(sub.docID, (StoredFieldVisitor)sub.visitor);
                this.finishDocument();
                ++docCount;
            }
            this.finish(mergeState.mergeFieldInfos, docCount);
            return docCount;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public void close() throws IOException {
    }

    public long ramBytesUsed() {
        return 1L;
    }

    public Collection<Accountable> getChildResources() {
        return super.getChildResources();
    }

    private static class StoredFieldsMergeSub
    extends DocIDMerger.Sub {
        private final StoredFieldsReader reader;
        private final int maxDoc;
        private final StoredFieldsWriter.MergeVisitor visitor;
        int docID = -1;

        public StoredFieldsMergeSub(StoredFieldsWriter.MergeVisitor visitor, MergeState.DocMap docMap, StoredFieldsReader reader, int maxDoc) {
            super(docMap);
            this.maxDoc = maxDoc;
            this.reader = reader;
            this.visitor = visitor;
        }

        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }
}

