/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.LazyOpener;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;

public class LuceneOptimizedLiveDocsFormat
extends LiveDocsFormat {
    private LiveDocsFormat liveDocsFormat;

    public LuceneOptimizedLiveDocsFormat(LiveDocsFormat liveDocsFormat) {
        this.liveDocsFormat = liveDocsFormat;
    }

    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        return new LazyBits(dir, info, context);
    }

    public void writeLiveDocs(Bits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        this.liveDocsFormat.writeLiveDocs(bits, dir, info, newDelCount, context);
    }

    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        this.liveDocsFormat.files(info, files);
    }

    private class LazyBits
    implements Bits {
        private final LazyOpener<Bits> bits = LazyOpener.supply(() -> LuceneOptimizedLiveDocsFormat.this.liveDocsFormat.readLiveDocs(dir, info, context));

        public LazyBits(Directory dir, SegmentCommitInfo info, IOContext context) {
        }

        public boolean get(int index) {
            return this.bits.getUnchecked().get(index);
        }

        public int length() {
            return this.bits.getUnchecked().length();
        }
    }
}

