/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.LazyCloseable;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedPostingsFormat;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.CompoundDirectory;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;

public final class LuceneOptimizedCompoundReader
extends CompoundDirectory {
    private final Directory directory;
    private final String segmentName;
    private final Map<String, FileEntry> entries;
    private final String entriesFileName;
    private LazyCloseable<IndexInput> dataInput;
    private final String dataFileName;

    public LuceneOptimizedCompoundReader(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        this.directory = directory;
        this.segmentName = si.name;
        this.dataFileName = IndexFileNames.segmentFileName((String)this.segmentName, (String)"", (String)"cfs");
        this.entriesFileName = IndexFileNames.segmentFileName((String)this.segmentName, (String)"", (String)"cfe");
        this.entries = this.readEntries(si.getId(), directory, this.entriesFileName);
        this.dataInput = LazyCloseable.supply(() -> directory.openInput(this.dataFileName, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FileEntry> readEntries(byte[] segmentID, Directory dir, String entriesFileName) throws IOException {
        HashMap<String, FileEntry> mapping;
        block13: {
            mapping = null;
            try (ChecksumIndexInput entriesStream = dir.openChecksumInput(entriesFileName, IOContext.READONCE);){
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader((DataInput)entriesStream, (String)"Lucene50CompoundEntries", (int)0, (int)0, (byte[])segmentID, (String)"");
                    int numEntries = entriesStream.readVInt();
                    mapping = new HashMap<String, FileEntry>(numEntries);
                    for (int i = 0; i < numEntries; ++i) {
                        FileEntry fileEntry = new FileEntry();
                        String id = entriesStream.readString();
                        FileEntry previous = mapping.put(id, fileEntry);
                        if (previous != null) {
                            throw new CorruptIndexException("Duplicate cfs entry id=" + id + " in CFS ", (DataInput)entriesStream);
                        }
                        fileEntry.offset = entriesStream.readLong();
                        fileEntry.length = entriesStream.readLong();
                    }
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)entriesStream, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)entriesStream, (Throwable)priorE);
            }
        }
        return Collections.unmodifiableMap(mapping);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.dataInput});
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        if (FDBDirectory.isFieldInfoFile(name)) {
            throw new FileNotFoundException("Tried to read fieldInfo file: " + name);
        }
        String id = IndexFileNames.stripSegmentName((String)name);
        FileEntry entry = this.entries.get(id);
        if (entry == null) {
            String datFileName = IndexFileNames.segmentFileName((String)this.segmentName, (String)"", (String)"cfs");
            throw new FileNotFoundException("No sub-file with id " + id + " found in compound file \"" + datFileName + "\" (fileName=" + name + " files: " + String.valueOf(this.entries.keySet()) + ")");
        }
        return this.dataInput.get().slice(name, entry.offset, entry.length);
    }

    public String[] listAll() {
        this.ensureOpen();
        String[] res = this.entries.keySet().toArray(new String[this.entries.size()]);
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.segmentName + res[i];
        }
        return res;
    }

    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        FileEntry e = this.entries.get(IndexFileNames.stripSegmentName((String)name));
        if (e == null) {
            throw new FileNotFoundException(name);
        }
        return e.length;
    }

    public String toString() {
        return "CompoundFileDirectory(segment=\"" + this.segmentName + "\" in dir=" + String.valueOf(this.directory) + ")";
    }

    public Set<String> getPendingDeletions() {
        return Collections.emptySet();
    }

    public void checkIntegrity() throws IOException {
        if (LuceneOptimizedPostingsFormat.allowCheckDataIntegrity) {
            CodecUtil.checksumEntireFile((IndexInput)this.dataInput.get());
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getEntriesFileName() {
        return this.entriesFileName;
    }

    private static final class FileEntry {
        long offset;
        long length;

        private FileEntry() {
        }
    }
}

