/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndexV1;
import com.apple.foundationdb.record.lucene.codec.LazyCloseable;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedPostingsFormat;
import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

public class LazyStoredFieldsReader
extends StoredFieldsReader
implements LucenePrimaryKeySegmentIndexV1.StoredFieldsReaderSegmentInfo {
    private LazyCloseable<StoredFieldsReader> storedFieldsReader;
    private Directory directory;
    private SegmentInfo si;
    private FieldInfos fn;
    private IOContext context;

    public LazyStoredFieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context, LazyCloseable<StoredFieldsReader> storedFieldsReader) {
        this.directory = directory;
        this.si = si;
        this.fn = fn;
        this.context = context;
        this.storedFieldsReader = storedFieldsReader;
    }

    public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
        this.storedFieldsReader.get().visitDocument(docID, visitor);
    }

    @SpotBugsSuppressWarnings(value={"CN"})
    public LazyStoredFieldsReader clone() {
        return new LazyStoredFieldsReader(this.directory, this.si, this.fn, this.context, LazyCloseable.supply(() -> this.storedFieldsReader.get().clone()));
    }

    public void checkIntegrity() throws IOException {
        if (LuceneOptimizedPostingsFormat.allowCheckDataIntegrity) {
            this.storedFieldsReader.get().checkIntegrity();
        }
    }

    public void close() throws IOException {
        this.storedFieldsReader.close();
    }

    public long ramBytesUsed() {
        return this.storedFieldsReader.getUnchecked().ramBytesUsed();
    }

    @Override
    public SegmentInfo getSegmentInfo() {
        return this.si;
    }
}

