/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneScanParameters;
import com.apple.foundationdb.record.lucene.LuceneScanQuery;
import com.apple.foundationdb.record.lucene.LuceneScanTypes;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.planprotos.PIndexScanParameters;
import com.apple.foundationdb.record.planprotos.PLuceneScanQueryParameters;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

@API(value=API.Status.UNSTABLE)
public class LuceneScanQueryParameters
extends LuceneScanParameters
implements PlanSerializable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash((Object)"Lucene-Scan-Query");
    @Nonnull
    final LuceneQueryClause query;
    @Nullable
    final Sort sort;
    @Nullable
    final List<String> storedFields;
    @Nullable
    final List<LuceneIndexExpressions.DocumentFieldType> storedFieldTypes;
    @Nullable
    final LuceneQueryHighlightParameters luceneQueryHighlightParameters;

    @SpotBugsSuppressWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
    protected LuceneScanQueryParameters(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneScanQueryParameters luceneScanQueryParametersProto) {
        super(serializationContext, Objects.requireNonNull(luceneScanQueryParametersProto.getSuper()));
        this.query = null;
        this.sort = null;
        this.storedFields = null;
        this.storedFieldTypes = null;
        this.luceneQueryHighlightParameters = null;
    }

    public LuceneScanQueryParameters(@Nonnull ScanComparisons groupComparisons, @Nonnull LuceneQueryClause query) {
        this(groupComparisons, query, null, null, null, null);
    }

    public LuceneScanQueryParameters(@Nonnull ScanComparisons groupComparisons, @Nonnull LuceneQueryClause query, @Nullable Sort sort, @Nullable List<String> storedFields, @Nullable List<LuceneIndexExpressions.DocumentFieldType> storedFieldTypes, @Nullable LuceneQueryHighlightParameters luceneQueryHighlightParameters) {
        super(LuceneScanTypes.BY_LUCENE, groupComparisons);
        this.query = query;
        this.sort = sort;
        this.storedFields = storedFields;
        this.storedFieldTypes = storedFieldTypes;
        this.luceneQueryHighlightParameters = luceneQueryHighlightParameters;
    }

    @Nonnull
    public LuceneQueryClause getQuery() {
        return this.query;
    }

    @Nullable
    public Sort getSort() {
        return this.sort;
    }

    @Nullable
    public List<String> getStoredFields() {
        return this.storedFields;
    }

    @Nullable
    public List<LuceneIndexExpressions.DocumentFieldType> getStoredFieldTypes() {
        return this.storedFieldTypes;
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{BASE_HASH, this.scanType, this.groupComparisons, this.query, this.sort == null ? null : this.sort.toString(), this.storedFields, this.storedFieldTypes});
    }

    @Override
    @Nonnull
    public LuceneScanQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
        LuceneQueryClause.BoundQuery boundQuery = this.query.bind(store, index, context);
        if (this.luceneQueryHighlightParameters != null) {
            this.luceneQueryHighlightParameters.query = boundQuery.getLuceneQuery();
            Objects.requireNonNull(boundQuery.getHighlightingTermsMap());
        }
        return new LuceneScanQuery(this.scanType, this.getGroupKey(store, context), boundQuery.getLuceneQuery(), this.sort, this.storedFields, this.storedFieldTypes, this.luceneQueryHighlightParameters, boundQuery.getHighlightingTermsMap());
    }

    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        return ExplainTokensWithPrecedence.of((ExplainTokens)new ExplainTokens().addToString((Object)(this.getGroupScanDetails() + " " + String.valueOf(this.query))));
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        super.getPlannerGraphDetails(detailsBuilder, attributeMapBuilder);
        this.query.getPlannerGraphDetails(detailsBuilder, attributeMapBuilder);
        if (this.sort != null) {
            detailsBuilder.add((Object)"sort: {{sort}}");
            attributeMapBuilder.put((Object)"sort", (Object)Attribute.gml((Object)this.sort.toString()));
        }
        if (this.storedFields != null) {
            StringBuilder stored = new StringBuilder();
            for (int i = 0; i < this.storedFields.size(); ++i) {
                if (i > 0) {
                    stored.append(", ");
                }
                stored.append(this.storedFields.get(i) + ":" + String.valueOf((Object)this.storedFieldTypes.get(i)));
            }
            detailsBuilder.add((Object)"stored: {{stored}}");
            attributeMapBuilder.put((Object)"stored", (Object)Attribute.gml((Object)stored.toString()));
        }
    }

    @Nonnull
    public IndexScanParameters translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        return this;
    }

    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        return ImmutableSet.of();
    }

    @Nonnull
    public IndexScanParameters rebase(@Nonnull AliasMap translationMap) {
        return this.translateCorrelations((TranslationMap)TranslationMap.rebaseWithAliasMap((AliasMap)translationMap), false);
    }

    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        LuceneScanQueryParameters that = (LuceneScanQueryParameters)other;
        return this.query.equals(that.query) && Objects.equals(this.sort, that.sort);
    }

    public int semanticHashCode() {
        int result = super.hashCode();
        result = 31 * result + this.query.hashCode();
        if (this.sort != null) {
            result = 31 * result + this.sort.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.query);
    }

    @Override
    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    @Override
    public int hashCode() {
        return this.semanticHashCode();
    }

    @Nonnull
    public PLuceneScanQueryParameters toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PLuceneScanQueryParameters.newBuilder().setSuper(this.toLuceneScanParametersProto(serializationContext)).build();
    }

    @Nonnull
    public PIndexScanParameters toIndexScanParametersProto(@Nonnull PlanSerializationContext serializationContext) {
        return PIndexScanParameters.newBuilder().setAdditionalIndexScanParameters(PlanSerialization.protoObjectToAny((PlanSerializationContext)serializationContext, (Message)this.toProto(serializationContext))).build();
    }

    @Nonnull
    public static LuceneScanQueryParameters fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneScanQueryParameters luceneScanQueryParametersProto) {
        return new LuceneScanQueryParameters(serializationContext, luceneScanQueryParametersProto);
    }

    public static class LuceneQueryHighlightParameters {
        private final int snippedSize;
        private final int maxMatchCount;
        private Query query;

        public LuceneQueryHighlightParameters(int snippetSize, int maxMatchCount) {
            this(snippetSize, maxMatchCount, null);
        }

        public LuceneQueryHighlightParameters(int snippetSize, int maxMatchCount, Query theQuery) {
            this.snippedSize = snippetSize;
            this.maxMatchCount = maxMatchCount;
            this.query = theQuery;
        }

        public Query getQuery() {
            return this.query;
        }

        public boolean isCutSnippets() {
            return this.snippedSize > 1;
        }

        public int getSnippedSize() {
            return this.snippedSize;
        }

        public int getMaxMatchCount() {
            return this.maxMatchCount;
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PLuceneScanQueryParameters, LuceneScanQueryParameters> {
        @Nonnull
        public Class<PLuceneScanQueryParameters> getProtoMessageClass() {
            return PLuceneScanQueryParameters.class;
        }

        @Nonnull
        public LuceneScanQueryParameters fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneScanQueryParameters luceneScanQueryParametersProto) {
            return LuceneScanQueryParameters.fromProto(serializationContext, luceneScanQueryParametersProto);
        }
    }
}

