/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.KeyRange;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.cursors.ChainedCursor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerRegistryImpl;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneComparisonQuery;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneIndexMaintainer;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LuceneQuerySearchClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.LuceneRecordCursor;
import com.apple.foundationdb.record.lucene.LuceneRepartitionPlanner;
import com.apple.foundationdb.record.lucene.LuceneScanParameters;
import com.apple.foundationdb.record.lucene.LuceneScanQuery;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryManager;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.common.StoreTimerSnapshot;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class LucenePartitioner {
    private static final FDBStoreTimer.Waits WAIT_LOAD_LUCENE_PARTITION_METADATA = FDBStoreTimer.Waits.WAIT_LOAD_LUCENE_PARTITION_METADATA;
    private static final Logger LOGGER = LoggerFactory.getLogger(LucenePartitioner.class);
    static final int DEFAULT_PARTITION_HIGH_WATERMARK = 400000;
    @VisibleForTesting
    public static final int DEFAULT_PARTITION_LOW_WATERMARK = 0;
    private static final ConcurrentHashMap<String, KeyExpression> partitioningKeyExpressionCache = new ConcurrentHashMap();
    public static final int PARTITION_META_SUBSPACE = 0;
    public static final int PARTITION_DATA_SUBSPACE = 1;
    private final IndexMaintainerState state;
    private final boolean partitioningEnabled;
    private final String partitionFieldNameInLucene;
    private final int indexPartitionHighWatermark;
    private final int indexPartitionLowWatermark;
    private final KeyExpression partitioningKeyExpression;
    private final LuceneRepartitionPlanner repartitionPlanner;

    public LucenePartitioner(@Nonnull IndexMaintainerState state) {
        this.state = state;
        String partitionFieldName = state.index.getOption("partitionFieldName");
        boolean bl = this.partitioningEnabled = partitionFieldName != null;
        if (this.partitioningEnabled && (partitionFieldName.isEmpty() || partitionFieldName.isBlank())) {
            throw new RecordCoreArgumentException("Invalid partition field name", new Object[]{LogMessageKeys.FIELD_NAME, partitionFieldName});
        }
        this.partitionFieldNameInLucene = partitionFieldName == null ? null : partitionFieldName.replace('.', '_');
        String strIndexPartitionHighWatermark = state.index.getOption("partitionHighWatermark");
        this.indexPartitionHighWatermark = strIndexPartitionHighWatermark == null ? 400000 : Integer.parseInt(strIndexPartitionHighWatermark);
        String strIndexPartitionLowWatermark = state.index.getOption("partitionLowWatermark");
        this.indexPartitionLowWatermark = strIndexPartitionLowWatermark == null ? 0 : Integer.parseInt(strIndexPartitionLowWatermark);
        this.partitioningKeyExpression = this.makePartitioningKeyExpression(partitionFieldName);
        if (this.indexPartitionHighWatermark < this.indexPartitionLowWatermark) {
            throw new RecordCoreArgumentException("High watermark must be greater than low watermark", new Object[0]);
        }
        this.repartitionPlanner = new LuceneRepartitionPlanner(this.indexPartitionLowWatermark, this.indexPartitionHighWatermark);
    }

    @Nullable
    private KeyExpression makePartitioningKeyExpression(@Nullable String partitionFieldName) {
        if (partitionFieldName == null) {
            return null;
        }
        return partitioningKeyExpressionCache.computeIfAbsent(partitionFieldName, k -> {
            String[] nameComponents = k.split("\\.");
            if (nameComponents.length == 1) {
                return Key.Expressions.field((String)nameComponents[0]);
            }
            List fields = Arrays.stream(nameComponents).map(Key.Expressions::field).collect(Collectors.toList());
            for (int i = fields.size() - 1; i > 0; --i) {
                fields.set(i - 1, ((FieldKeyExpression)fields.get(i - 1)).nest((KeyExpression)fields.get(i)));
            }
            return (KeyExpression)fields.get(0);
        });
    }

    @Nullable
    public Integer selectQueryPartitionId(@Nonnull Tuple groupKey) {
        LucenePartitionInfoProto.LucenePartitionInfo partitionInfo;
        if (this.isPartitioningEnabled() && (partitionInfo = this.selectQueryPartition((Tuple)groupKey, null).startPartition) != null) {
            return partitionInfo.getId();
        }
        return null;
    }

    public PartitionedQueryHint selectQueryPartition(@Nonnull Tuple groupKey, @Nullable LuceneScanQuery luceneScanQuery) {
        return LuceneConcurrency.asyncToSync((StoreTimer.Wait)WAIT_LOAD_LUCENE_PARTITION_METADATA, this.selectQueryPartitionAsync(groupKey, luceneScanQuery), this.state.context);
    }

    public CompletableFuture<PartitionedQueryHint> selectQueryPartitionAsync(@Nonnull Tuple groupKey, @Nullable LuceneScanQuery luceneScanQuery) {
        Comparisons.Type comparisonType;
        if (!this.isPartitioningEnabled()) {
            return CompletableFuture.completedFuture(new PartitionedQueryHint(true, null));
        }
        if (luceneScanQuery == null) {
            return LucenePartitioner.getNewestPartition(groupKey, this.state.context, this.state.indexSubspace).thenApply(newestPartition -> new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)newestPartition));
        }
        PartitionedSortContext sortCriteria = luceneScanQuery.getSort() == null ? null : this.isSortedByPartitionField(luceneScanQuery.getSort());
        LuceneComparisonQuery partitionFieldPredicate = this.checkQueryForPartitionFieldPredicate(luceneScanQuery);
        boolean isAscending = sortCriteria != null && sortCriteria.isByPartitionField && !sortCriteria.isReverse;
        Comparisons.Type type = comparisonType = partitionFieldPredicate == null ? null : partitionFieldPredicate.getComparisonType();
        if (comparisonType == null) {
            CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> noPredicatePartition = isAscending ? this.getOldestPartition(groupKey) : LucenePartitioner.getNewestPartition(groupKey, this.state.context, this.state.indexSubspace);
            return noPredicatePartition.thenApply(partition -> new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)partition));
        }
        Tuple partitionField = Tuple.from((Object[])new Object[]{Objects.requireNonNull(partitionFieldPredicate).getComparand()});
        byte[] lowEnd = this.state.indexSubspace.subspace(groupKey.add(0L)).pack();
        byte[] highEnd = ByteArrayUtil.strinc((byte[])this.state.indexSubspace.subspace(groupKey.add(0L)).pack());
        byte[] partitionFieldSubspace = this.state.indexSubspace.subspace(groupKey.add(0L).addAll(partitionField)).pack();
        byte[] partitionFieldSubsequentValueSubspace = ByteArrayUtil.strinc((byte[])this.state.indexSubspace.subspace(groupKey.add(0L).addAll(partitionField)).pack());
        Range lowEndToPartitionField = new Range(lowEnd, partitionFieldSubspace);
        Range partitionFieldToHighEnd = new Range(partitionFieldSubspace, highEnd);
        Range lowEndToPartitionFieldSubsequent = new Range(lowEnd, partitionFieldSubsequentValueSubspace);
        Range partitionFieldSubsequentToHighEnd = new Range(partitionFieldSubsequentValueSubspace, highEnd);
        if (isAscending) {
            switch (comparisonType) {
                case EQUALS: {
                    return this.scanRange(lowEndToPartitionField, true).thenCompose(candidate1 -> {
                        if (candidate1 == null || LucenePartitioner.isNewerThan(partitionField, candidate1)) {
                            return this.scanRange(partitionFieldToHighEnd, false).thenApply(candidate2 -> candidate2 == null || LucenePartitioner.isPrefixOlderThanPartition(partitionField, candidate2) ? PartitionedQueryHint.NO_MATCHES : new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate2));
                        }
                        return CompletableFuture.completedFuture(new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate1));
                    });
                }
                case GREATER_THAN_OR_EQUALS: {
                    return this.scanRange(lowEndToPartitionField, true).thenCompose(candidate1 -> {
                        if (candidate1 == null || LucenePartitioner.isNewerThan(partitionField, candidate1)) {
                            return this.scanRange(partitionFieldToHighEnd, false).thenApply(candidate2 -> candidate2 == null ? PartitionedQueryHint.NO_MATCHES : new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate2));
                        }
                        return CompletableFuture.completedFuture(new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate1));
                    });
                }
                case GREATER_THAN: {
                    return this.scanRange(lowEndToPartitionFieldSubsequent, true).thenCompose(candidate1 -> {
                        if (candidate1 == null || LucenePartitioner.isNewerThan(partitionField, candidate1)) {
                            return this.scanRange(partitionFieldSubsequentToHighEnd, false).thenApply(candidate2 -> candidate2 == null ? PartitionedQueryHint.NO_MATCHES : new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate2));
                        }
                        return CompletableFuture.completedFuture(new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate1));
                    });
                }
                case LESS_THAN: 
                case LESS_THAN_OR_EQUALS: {
                    return this.getOldestPartition(groupKey).thenApply(candidate -> candidate == null || comparisonType == Comparisons.Type.LESS_THAN && LucenePartitioner.isOlderThan(partitionField, candidate) || comparisonType == Comparisons.Type.LESS_THAN_OR_EQUALS && LucenePartitioner.isPrefixOlderThanPartition(partitionField, candidate) ? PartitionedQueryHint.NO_MATCHES : new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate));
                }
            }
            return this.getOldestPartition(groupKey).thenApply(oldestPartition -> new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)oldestPartition));
        }
        switch (comparisonType) {
            case EQUALS: {
                return this.scanRange(lowEndToPartitionFieldSubsequent, true).thenApply(candidate -> candidate == null || LucenePartitioner.isNewerThan(partitionField, candidate) ? PartitionedQueryHint.NO_MATCHES : new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate));
            }
            case LESS_THAN_OR_EQUALS: {
                return this.scanRange(lowEndToPartitionFieldSubsequent, true).thenApply(candidate -> candidate == null ? PartitionedQueryHint.NO_MATCHES : new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate));
            }
            case LESS_THAN: {
                return this.scanRange(lowEndToPartitionField, true).thenApply(candidate -> candidate == null ? PartitionedQueryHint.NO_MATCHES : new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate));
            }
            case GREATER_THAN_OR_EQUALS: 
            case GREATER_THAN: {
                return LucenePartitioner.getNewestPartition(groupKey, this.state.context, this.state.indexSubspace).thenApply(candidate -> candidate == null || LucenePartitioner.isNewerThan(partitionField, candidate) ? PartitionedQueryHint.NO_MATCHES : new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)candidate));
            }
        }
        return LucenePartitioner.getNewestPartition(groupKey, this.state.context, this.state.indexSubspace).thenApply(newestPartition -> new PartitionedQueryHint(true, (LucenePartitionInfoProto.LucenePartitionInfo)newestPartition));
    }

    @Nonnull
    private CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> scanRange(Range range, boolean reverse) {
        AsyncIterable rangeIterable = this.state.context.ensureActive().getRange(range, 1, reverse, StreamingMode.WANT_ALL);
        return AsyncUtil.collect((AsyncIterable)rangeIterable, (Executor)this.state.context.getExecutor()).thenApply(targetPartitions -> targetPartitions.isEmpty() ? null : LucenePartitioner.partitionInfoFromKV((KeyValue)targetPartitions.get(0)));
    }

    @Nullable
    LuceneComparisonQuery checkQueryForPartitionFieldPredicate(@Nonnull LuceneScanQuery luceneScanQuery) {
        Query query = luceneScanQuery.getQuery();
        if (this.isAPartitionFieldPredicate(query)) {
            return (LuceneComparisonQuery)query;
        }
        if (query instanceof BooleanQuery) {
            List clauses = ((BooleanQuery)query).clauses();
            ArrayList<LuceneComparisonQuery> partitionFieldPredicates = new ArrayList<LuceneComparisonQuery>();
            for (BooleanClause clause : clauses) {
                Query clauseQuery;
                if (clause.getOccur() != BooleanClause.Occur.MUST && clause.getOccur() != BooleanClause.Occur.FILTER && (clause.getOccur() != BooleanClause.Occur.SHOULD || clauses.size() != 1) || !this.isAPartitionFieldPredicate(clauseQuery = clause.getQuery())) continue;
                partitionFieldPredicates.add((LuceneComparisonQuery)clauseQuery);
            }
            return partitionFieldPredicates.size() == 1 ? (LuceneComparisonQuery)((Object)partitionFieldPredicates.get(0)) : null;
        }
        return null;
    }

    private boolean isAPartitionFieldPredicate(Query query) {
        return query instanceof LuceneComparisonQuery && ((LuceneComparisonQuery)query).getFieldName().equals(this.partitionFieldNameInLucene);
    }

    @Nonnull
    public PartitionedSortContext isSortedByPartitionField(@Nonnull Sort sort) {
        boolean sortedByPartitioningKey = false;
        boolean isReverseSort = false;
        SortField[] updatedSortFields = null;
        int sortFieldCount = Objects.requireNonNull(sort.getSort()).length;
        if (sortFieldCount > 0) {
            SortField sortField = sort.getSort()[0];
            String sortFieldName = sortField.getField();
            String partitioningFieldName = Objects.requireNonNull(this.getPartitionFieldNameInLucene());
            if (partitioningFieldName.equals(sortFieldName)) {
                sortedByPartitioningKey = sortFieldCount == 1 || sortFieldCount == 2 && "_s".equals(sort.getSort()[1].getField());
                updatedSortFields = this.ensurePrimaryKeyIsInSort(sort);
            }
            isReverseSort = sortField.getReverse();
        }
        return new PartitionedSortContext(sortedByPartitioningKey, isReverseSort, updatedSortFields);
    }

    @Nullable
    private SortField[] ensurePrimaryKeyIsInSort(Sort sort) {
        SortField[] fields = sort.getSort();
        if (fields.length < 2) {
            SortField[] updatedFields = new SortField[]{fields[0], new SortField("_s", SortField.Type.STRING, fields[0].getReverse())};
            return updatedFields;
        }
        return null;
    }

    public boolean isPartitioningEnabled() {
        return this.partitioningEnabled;
    }

    @Nullable
    public String getPartitionFieldNameInLucene() {
        return this.partitionFieldNameInLucene;
    }

    @Nonnull
    public <M extends Message> CompletableFuture<Integer> addToAndSavePartitionMetadata(@Nonnull FDBIndexableRecord<M> newRecord, @Nonnull Tuple groupingKey, @Nullable Integer assignedPartitionId) {
        if (!this.isPartitioningEnabled()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.addToAndSavePartitionMetadata(groupingKey, this.toPartitionKey(newRecord), assignedPartitionId);
    }

    @Nonnull
    private CompletableFuture<Integer> addToAndSavePartitionMetadata(@Nonnull Tuple groupingKey, @Nonnull Tuple partitioningKey, @Nullable Integer assignedPartitionIdOverride) {
        CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> assignmentFuture = assignedPartitionIdOverride != null ? this.getPartitionMetaInfoById(assignedPartitionIdOverride, groupingKey) : this.getOrCreatePartitionInfo(groupingKey, partitioningKey);
        return assignmentFuture.thenApply(assignedPartition -> {
            LucenePartitionInfoProto.LucenePartitionInfo.Builder builder = Objects.requireNonNull(assignedPartition).toBuilder();
            builder.setCount(assignedPartition.getCount() + 1);
            if (LucenePartitioner.isOlderThan(partitioningKey, assignedPartition)) {
                this.state.context.ensureActive().clear(this.partitionMetadataKeyFromPartitioningValue(groupingKey, LucenePartitioner.getPartitionKey(assignedPartition)));
                builder.setFrom(ByteString.copyFrom((byte[])partitioningKey.pack()));
            }
            if (LucenePartitioner.isNewerThan(partitioningKey, assignedPartition)) {
                builder.setTo(ByteString.copyFrom((byte[])partitioningKey.pack()));
            }
            this.savePartitionMetadata(groupingKey, builder);
            return assignedPartition.getId();
        });
    }

    @Nonnull
    byte[] partitionMetadataKeyFromPartitioningValue(@Nonnull Tuple groupKey, @Nonnull Tuple partitionKey) {
        return this.state.indexSubspace.pack(LucenePartitioner.partitionMetadataKeyTuple(groupKey, partitionKey));
    }

    private static Tuple partitionMetadataKeyTuple(@Nonnull Tuple groupKey, @Nonnull Tuple partitionKey) {
        return groupKey.add(0L).addAll(partitionKey);
    }

    void savePartitionMetadata(@Nonnull Tuple groupingKey, @Nonnull LucenePartitionInfoProto.LucenePartitionInfo.Builder builder) {
        LucenePartitionInfoProto.LucenePartitionInfo updatedPartition = builder.build();
        this.state.context.ensureActive().set(this.partitionMetadataKeyFromPartitioningValue(groupingKey, LucenePartitioner.getPartitionKey(updatedPartition)), updatedPartition.toByteArray());
    }

    @Nonnull
    CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> findPartitionInfo(@Nonnull Tuple groupingKey, @Nonnull Tuple partitioningKey) {
        Range range = new Range(this.state.indexSubspace.subspace(groupingKey.add(0L)).pack(), this.state.indexSubspace.subspace(groupingKey.add(0L).addAll(partitioningKey)).pack());
        AsyncIterable rangeIterable = this.state.context.ensureActive().getRange(range, 1, true, StreamingMode.WANT_ALL);
        return AsyncUtil.collect((AsyncIterable)rangeIterable, (Executor)this.state.context.getExecutor()).thenApply(targetPartition -> targetPartition.isEmpty() ? null : LucenePartitioner.partitionInfoFromKV((KeyValue)targetPartition.get(0)));
    }

    @Nonnull
    private CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> getOrCreatePartitionInfo(@Nonnull Tuple groupingKey, @Nonnull Tuple partitioningKey) {
        return this.assignPartitionInternal(groupingKey, partitioningKey, true).thenCompose(assignedPartitionInfo -> {
            if (assignedPartitionInfo.getCount() >= this.indexPartitionHighWatermark && LucenePartitioner.isOlderThan(partitioningKey, assignedPartitionInfo)) {
                return this.getAllPartitionMetaInfo(groupingKey).thenApply(partitionInfos -> {
                    int maxPartitionId = partitionInfos.stream().map(LucenePartitionInfoProto.LucenePartitionInfo::getId).max(Integer::compare).orElse(0);
                    return this.newPartitionMetadata(partitioningKey, maxPartitionId + 1);
                });
            }
            return CompletableFuture.completedFuture(assignedPartitionInfo);
        });
    }

    @Nonnull
    <M extends Message> CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> tryGetPartitionInfo(@Nonnull FDBIndexableRecord<M> record, @Nonnull Tuple groupingKey) {
        if (!this.isPartitioningEnabled()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.assignPartitionInternal(groupingKey, this.toPartitionKey(record), false);
    }

    void decrementCountAndSave(@Nonnull Tuple groupingKey, @Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo, int amount) {
        LucenePartitionInfoProto.LucenePartitionInfo.Builder builder = Objects.requireNonNull(partitionInfo).toBuilder();
        builder.setCount(partitionInfo.getCount() - amount);
        if (builder.getCount() < 0) {
            throw new RecordCoreException("Issue updating Lucene partition metadata (resulting count < 0)", new Object[]{LogMessageKeys.PARTITION_ID, partitionInfo.getId()});
        }
        this.savePartitionMetadata(groupingKey, builder);
    }

    @Nonnull
    private CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> assignPartitionInternal(@Nonnull Tuple groupingKey, @Nonnull Tuple partitioningKey, boolean createIfNotExists) {
        Range range = TupleRange.toRange((byte[])this.state.indexSubspace.subspace(groupingKey.add(0L)).pack(), (byte[])this.state.indexSubspace.subspace(groupingKey.add(0L).addAll(partitioningKey)).pack(), (EndpointType)EndpointType.RANGE_INCLUSIVE, (EndpointType)EndpointType.RANGE_INCLUSIVE);
        AsyncIterable rangeIterable = this.state.context.ensureActive().getRange(range, 1, true, StreamingMode.WANT_ALL);
        return AsyncUtil.collect((AsyncIterable)rangeIterable, (Executor)this.state.context.getExecutor()).thenCompose(targetPartition -> {
            if (targetPartition.isEmpty()) {
                return this.getOldestPartition(groupingKey).thenApply(oldestPartition -> {
                    if (oldestPartition == null) {
                        if (createIfNotExists) {
                            return this.newPartitionMetadata(partitioningKey, 0);
                        }
                        return null;
                    }
                    return oldestPartition;
                });
            }
            return CompletableFuture.completedFuture(LucenePartitioner.partitionInfoFromKV((KeyValue)targetPartition.get(0)));
        });
    }

    @Nonnull
    private <M extends Message> Object getPartitioningFieldValue(@Nonnull FDBIndexableRecord<M> rec) {
        Key.Evaluated evaluatedKey = this.partitioningKeyExpression.evaluateSingleton(rec);
        if (evaluatedKey.size() == 1) {
            Object value = evaluatedKey.getObject(0);
            if (value == null) {
                throw new RecordCoreException("partitioning field is null", new Object[0]);
            }
            return value;
        }
        throw new RecordCoreException("unexpected result when evaluating partition field", new Object[0]);
    }

    @Nonnull
    private LucenePartitionInfoProto.LucenePartitionInfo newPartitionMetadata(@Nonnull Tuple partitioningKey, int id) {
        return LucenePartitionInfoProto.LucenePartitionInfo.newBuilder().setCount(0).setTo(ByteString.copyFrom((byte[])partitioningKey.pack())).setFrom(ByteString.copyFrom((byte[])partitioningKey.pack())).setId(id).build();
    }

    @Nonnull
    private static CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> getNewestPartition(@Nonnull Tuple groupKey, @Nonnull FDBRecordContext context, @Nonnull Subspace indexSubspace) {
        return LucenePartitioner.getEdgePartition(groupKey, true, context, indexSubspace);
    }

    @Nonnull
    private CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> getOldestPartition(@Nonnull Tuple groupKey) {
        return LucenePartitioner.getEdgePartition(groupKey, false, this.state.context, this.state.indexSubspace);
    }

    @Nonnull
    private static CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> getEdgePartition(@Nonnull Tuple groupKey, boolean reverse, @Nonnull FDBRecordContext context, @Nonnull Subspace indexSubspace) {
        Range range = indexSubspace.subspace(groupKey.add(0L)).range();
        AsyncIterable rangeIterable = context.ensureActive().getRange(range, 1, reverse, StreamingMode.WANT_ALL);
        return AsyncUtil.collect((AsyncIterable)rangeIterable, (Executor)context.getExecutor()).thenApply(all -> all.isEmpty() ? null : LucenePartitioner.partitionInfoFromKV((KeyValue)all.get(0)));
    }

    @Nonnull
    static LucenePartitionInfoProto.LucenePartitionInfo partitionInfoFromKV(@Nonnull KeyValue keyValue) {
        try {
            return LucenePartitionInfoProto.LucenePartitionInfo.parseFrom(keyValue.getValue());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RecordCoreException((Throwable)e);
        }
    }

    @Nonnull
    public CompletableFuture<RecordCursorContinuation> rebalancePartitions(RecordCursorContinuation start, int documentCount, RepartitioningLogMessages logMessages) {
        KeyExpression rootExpression = this.state.index.getRootExpression();
        if (!(rootExpression instanceof GroupingKeyExpression)) {
            return this.processPartitionRebalancing(Tuple.from((Object[])new Object[0]), documentCount, logMessages).thenApply(movedCount -> {
                if (movedCount > 0) {
                    return RecordCursorStartContinuation.START;
                }
                return RecordCursorEndContinuation.END;
            });
        }
        GroupingKeyExpression expression = (GroupingKeyExpression)rootExpression;
        int groupingCount = expression.getGroupingCount();
        ScanProperties scanProperties = ScanProperties.FORWARD_SCAN.with(props -> props.clearState().setReturnedRowLimit(1));
        Range range = this.state.indexSubspace.range();
        KeyRange keyRange = new KeyRange(range.begin, range.end);
        Subspace subspace = this.state.indexSubspace;
        try (ChainedCursor cursor = new ChainedCursor(this.state.context, lastKey -> FDBDirectoryManager.nextTuple(this.state.context, subspace, keyRange, lastKey, scanProperties, groupingCount), Tuple::pack, Tuple::fromBytes, start.toBytes(), ScanProperties.FORWARD_SCAN);){
            AtomicReference<RecordCursorContinuation> continuation = new AtomicReference<RecordCursorContinuation>(start);
            CompletionStage completionStage = AsyncUtil.whileTrue(() -> this.lambda$rebalancePartitions$29((RecordCursor)cursor, groupingCount, documentCount, logMessages, continuation), (Executor)this.state.context.getExecutor()).thenApply(ignored -> (RecordCursorContinuation)continuation.get());
            return completionStage;
        }
    }

    @Nonnull
    public CompletableFuture<Integer> processPartitionRebalancing(@Nonnull Tuple groupingKey, int repartitionDocumentCount, RepartitioningLogMessages logMessages) {
        if (repartitionDocumentCount <= 0) {
            throw new IllegalArgumentException("number of documents to move can't be zero");
        }
        return this.getAllPartitionMetaInfo(groupingKey).thenCompose(partitionInfos -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(partitionInfos.stream().sorted(Comparator.comparing(pi -> Tuple.fromBytes((byte[])pi.getFrom().toByteArray()))).map(pi -> "pi[" + pi.getId() + "]@" + pi.getCount() + String.valueOf(Tuple.fromBytes((byte[])pi.getFrom().toByteArray())) + "->" + String.valueOf(Tuple.fromBytes((byte[])pi.getTo().toByteArray()))).collect(Collectors.joining(", ", "Rebalancing partitions (group=" + String.valueOf(groupingKey) + "): ", "")));
            }
            for (int i = 0; i < partitionInfos.size(); ++i) {
                LucenePartitionInfoProto.LucenePartitionInfo partitionInfo = (LucenePartitionInfoProto.LucenePartitionInfo)partitionInfos.get(i);
                LuceneRepartitionPlanner.RepartitioningContext repartitioningContext = this.repartitionPlanner.determineRepartitioningAction(groupingKey, (List<LucenePartitionInfoProto.LucenePartitionInfo>)partitionInfos, i, repartitionDocumentCount);
                if (repartitioningContext.action == LuceneRepartitionPlanner.RepartitioningAction.NOT_REQUIRED || repartitioningContext.action == LuceneRepartitionPlanner.RepartitioningAction.NO_CAPACITY_FOR_MERGE) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(this.repartitionLogMessage("Repartitioning records", groupingKey, repartitioningContext.countToMove, partitionInfo).toString());
                }
                return this.moveDocsFromPartitionThenLog(repartitioningContext, logMessages);
            }
            return CompletableFuture.completedFuture(0);
        });
    }

    @Nonnull
    private CompletableFuture<Integer> moveDocsFromPartitionThenLog(@Nonnull LuceneRepartitionPlanner.RepartitioningContext repartitioningContext, RepartitioningLogMessages logMessages) {
        logMessages.setPartitionId(repartitioningContext.sourcePartition.getId()).setPartitionKey(LucenePartitioner.getPartitionKey(repartitioningContext.sourcePartition)).setRepartitionDocCount(repartitioningContext.countToMove);
        long startTimeNanos = System.nanoTime();
        return this.moveDocsFromPartition(repartitioningContext).thenApply(movedCount -> {
            this.state.context.record((StoreTimer.Event)LuceneEvents.Events.LUCENE_REBALANCE_PARTITION, System.nanoTime() - startTimeNanos);
            this.state.context.recordSize((StoreTimer.SizeEvent)LuceneEvents.SizeEvents.LUCENE_REBALANCE_PARTITION_DOCS, (long)movedCount.intValue());
            return movedCount;
        });
    }

    private KeyValueLogMessage repartitionLogMessage(String staticMessage, @Nonnull Tuple groupingKey, int repartitionDocumentCount, @Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo) {
        return KeyValueLogMessage.build((String)staticMessage, (Object[])new Object[]{LogMessageKeys.INDEX_SUBSPACE, this.state.indexSubspace, LuceneLogMessageKeys.GROUP, groupingKey, LuceneLogMessageKeys.INDEX_PARTITION, partitionInfo.getId(), LuceneLogMessageKeys.TOTAL_COUNT, partitionInfo.getCount(), LuceneLogMessageKeys.COUNT, repartitionDocumentCount, LuceneLogMessageKeys.PARTITION_HIGH_WATERMARK, this.indexPartitionHighWatermark, LuceneLogMessageKeys.PARTITION_LOW_WATERMARK, this.indexPartitionLowWatermark});
    }

    @Nonnull
    public LuceneRecordCursor getNewestNDocuments(@Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo, @Nonnull Tuple groupingKey, int count) {
        return this.getEdgeNDocuments(partitionInfo, groupingKey, count, true);
    }

    @Nonnull
    public LuceneRecordCursor getOldestNDocuments(@Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo, @Nonnull Tuple groupingKey, int count) {
        return this.getEdgeNDocuments(partitionInfo, groupingKey, count, false);
    }

    @Nonnull
    private LuceneRecordCursor getEdgeNDocuments(@Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo, @Nonnull Tuple groupingKey, int count, boolean newest) {
        Map<String, LuceneIndexExpressions.DocumentFieldDerivation> fieldInfos = LuceneIndexExpressions.getDocumentFieldDerivations(this.state.index, this.state.store.getRecordMetaData());
        ScanComparisons comparisons = groupingKey.isEmpty() ? ScanComparisons.EMPTY : Objects.requireNonNull(ScanComparisons.from((Comparisons.Comparison)new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, groupingKey.get(0))));
        LuceneScanQueryParameters scan = new LuceneScanQueryParameters(comparisons, new LuceneQuerySearchClause(LuceneQueryType.QUERY, "*:*", false), new Sort(new SortField[]{new SortField(this.partitionFieldNameInLucene, SortField.Type.LONG, newest), new SortField("_s", SortField.Type.STRING, newest)}), null, null, null);
        ScanProperties scanProperties = ExecuteProperties.newBuilder().setReturnedRowLimit(count).build().asScanProperties(false);
        LuceneScanQuery scanQuery = (LuceneScanQuery)((LuceneScanParameters)scan).bind((FDBRecordStoreBase)this.state.store, this.state.index, EvaluationContext.EMPTY);
        return new LuceneRecordCursor(this.state.context.getExecutor(), (ExecutorService)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_EXECUTOR_SERVICE), this, Objects.requireNonNull((Integer)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE)), scanProperties, this.state, scanQuery.getQuery(), scanQuery.getSort(), null, scanQuery.getGroupKey(), partitionInfo, scanQuery.getLuceneQueryHighlightParameters(), scanQuery.getTermMap(), scanQuery.getStoredFields(), scanQuery.getStoredFieldTypes(), LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(this.state.index, LuceneAnalyzerType.FULL_TEXT, fieldInfos), LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(this.state.index, LuceneAnalyzerType.AUTO_COMPLETE, fieldInfos));
    }

    @Nonnull
    private CompletableFuture<Integer> moveDocsFromPartition(@Nonnull LuceneRepartitionPlanner.RepartitioningContext repartitioningContext) {
        if (repartitioningContext.countToMove <= 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("moveDocsFromPartition called with invalid countToMove {}", (Object)repartitioningContext.countToMove);
            }
            return CompletableFuture.completedFuture(0);
        }
        RepartitionTimings timings = new RepartitionTimings();
        StoreTimerSnapshot timerSnapshot = LOGGER.isDebugEnabled() && this.state.context.getTimer() != null ? StoreTimerSnapshot.from((StoreTimer)this.state.context.getTimer()) : null;
        timings.startNanos = System.nanoTime();
        Collection recordTypes = this.state.store.getRecordMetaData().recordTypesForIndex(this.state.index);
        if (recordTypes.stream().map(RecordType::isSynthetic).distinct().count() > 1L) {
            throw new RecordCoreException("mix of synthetic and non-synthetic record types in index is not supported", new Object[0]);
        }
        boolean removingOldest = repartitioningContext.action == LuceneRepartitionPlanner.RepartitioningAction.MERGE_INTO_OLDER || repartitioningContext.action == LuceneRepartitionPlanner.RepartitioningAction.MERGE_INTO_BOTH || repartitioningContext.action == LuceneRepartitionPlanner.RepartitioningAction.OVERFLOW;
        LucenePartitionInfoProto.LucenePartitionInfo partitionInfo = repartitioningContext.sourcePartition;
        Tuple groupingKey = repartitioningContext.groupingKey;
        LuceneRecordCursor cursor = removingOldest ? this.getOldestNDocuments(partitionInfo, groupingKey, repartitioningContext.countToMove) : this.getNewestNDocuments(partitionInfo, groupingKey, repartitioningContext.countToMove);
        CompletionStage fetchedRecordsFuture = ((RecordType)recordTypes.iterator().next()).isSynthetic() ? cursor.mapPipelined(indexEntry -> this.state.store.loadSyntheticRecord(indexEntry.getPrimaryKey()), this.state.store.getPipelineSize(PipelineOperation.INDEX_TO_RECORD)).asList() : this.state.store.fetchIndexRecords((RecordCursor)cursor, IndexOrphanBehavior.SKIP).map(FDBIndexedRecord::getStoredRecord).asList();
        timings.initializationNanos = System.nanoTime();
        fetchedRecordsFuture = ((CompletableFuture)fetchedRecordsFuture).whenComplete((ignored, throwable) -> cursor.close());
        return ((CompletableFuture)fetchedRecordsFuture).thenCompose(records -> {
            LucenePartitionInfoProto.LucenePartitionInfo destinationPartition;
            timings.searchNanos = System.nanoTime();
            if (records.size() == 0) {
                throw new RecordCoreException("Unexpected error: 0 records fetched. repartitionContext {}", new Object[]{repartitioningContext});
            }
            Tuple newBoundaryPartitionKey = null;
            if (!repartitioningContext.emptyingPartition && repartitioningContext.newBoundaryRecordPresent) {
                newBoundaryPartitionKey = this.toPartitionKey((FDBIndexableRecord)records.get(records.size() - 1));
                records.remove(records.size() - 1);
            }
            if (records.size() == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("no records to move, partition {}", (Object)partitionInfo);
                }
                return CompletableFuture.completedFuture(0);
            }
            this.state.context.ensureActive().clear(this.partitionMetadataKeyFromPartitioningValue(groupingKey, LucenePartitioner.getPartitionKey(partitionInfo)));
            LuceneIndexMaintainer indexMaintainer = (LuceneIndexMaintainer)this.state.store.getIndexMaintainer(this.state.index);
            timings.clearInfoNanos = System.nanoTime();
            if (repartitioningContext.emptyingPartition) {
                Range partitionDataRange = Range.startsWith((byte[])this.state.indexSubspace.subspace(groupingKey.add(1L).add((long)partitionInfo.getId())).pack());
                this.state.context.clear(partitionDataRange);
                timings.emptyingNanos = System.nanoTime();
            } else {
                records.forEach(r -> {
                    try {
                        indexMaintainer.deleteDocument(groupingKey, partitionInfo.getId(), r.getPrimaryKey());
                    }
                    catch (IOException e) {
                        throw LuceneExceptions.toRecordCoreException(e.getMessage(), e, new Object[0]);
                    }
                });
                timings.deleteNanos = System.nanoTime();
                LucenePartitionInfoProto.LucenePartitionInfo.Builder builder = partitionInfo.toBuilder().setCount(partitionInfo.getCount() - records.size());
                if (removingOldest) {
                    builder.setFrom(ByteString.copyFrom((byte[])Objects.requireNonNull(newBoundaryPartitionKey).pack()));
                } else {
                    builder.setTo(ByteString.copyFrom((byte[])Objects.requireNonNull(newBoundaryPartitionKey).pack()));
                }
                this.savePartitionMetadata(groupingKey, builder);
                timings.metadataUpdateNanos = System.nanoTime();
            }
            long endCleanupNanos = System.nanoTime();
            Tuple overflowPartitioningKey = this.toPartitionKey((FDBIndexableRecord)records.get(0));
            LucenePartitionInfoProto.LucenePartitionInfo lucenePartitionInfo = destinationPartition = removingOldest ? repartitioningContext.olderPartition : repartitioningContext.newerPartition;
            if (destinationPartition == null || destinationPartition.getCount() + records.size() > this.indexPartitionHighWatermark || destinationPartition.getId() == partitionInfo.getId()) {
                destinationPartition = this.newPartitionMetadata(overflowPartitioningKey, repartitioningContext.maxPartitionId + 1);
                this.savePartitionMetadata(groupingKey, destinationPartition.toBuilder());
                timings.createPartitionNanos = System.nanoTime();
            }
            long updateStart = System.nanoTime();
            Iterator recordIterator = records.iterator();
            int destinationPartitionId = destinationPartition.getId();
            return AsyncUtil.whileTrue(() -> indexMaintainer.update(null, (FDBIndexableRecord)recordIterator.next(), destinationPartitionId).thenApply(ignored -> recordIterator.hasNext()), (Executor)this.state.context.getExecutor()).thenApply(ignored -> {
                if (LOGGER.isDebugEnabled()) {
                    long updateNanos = System.nanoTime();
                    KeyValueLogMessage logMessage = this.repartitionLogMessage("Repartitioned records", groupingKey, records.size(), partitionInfo);
                    logMessage.addKeyAndValue((Object)"totalMicros", (Object)TimeUnit.NANOSECONDS.toMicros(updateNanos - timings.startNanos));
                    logMessage.addKeyAndValue((Object)"initializationMicros", (Object)TimeUnit.NANOSECONDS.toMicros(timings.initializationNanos - timings.startNanos));
                    logMessage.addKeyAndValue((Object)"searchMicros", (Object)TimeUnit.NANOSECONDS.toMicros(timings.searchNanos - timings.initializationNanos));
                    logMessage.addKeyAndValue((Object)"clearInfoMicros", (Object)TimeUnit.NANOSECONDS.toMicros(timings.clearInfoNanos - timings.searchNanos));
                    if (timings.emptyingNanos > 0L) {
                        logMessage.addKeyAndValue((Object)"emptyingMicros", (Object)TimeUnit.NANOSECONDS.toMicros(timings.emptyingNanos - timings.clearInfoNanos));
                    }
                    if (timings.deleteNanos > 0L) {
                        logMessage.addKeyAndValue((Object)"deleteMicros", (Object)TimeUnit.NANOSECONDS.toMicros(timings.deleteNanos - timings.clearInfoNanos));
                    }
                    if (timings.metadataUpdateNanos > 0L) {
                        logMessage.addKeyAndValue((Object)"metadataUpdateMicros", (Object)TimeUnit.NANOSECONDS.toMicros(timings.metadataUpdateNanos - timings.deleteNanos));
                    }
                    if (timings.createPartitionNanos > 0L) {
                        logMessage.addKeyAndValue((Object)"createPartitionMicros", (Object)TimeUnit.NANOSECONDS.toMicros(timings.createPartitionNanos - endCleanupNanos));
                    }
                    logMessage.addKeyAndValue((Object)"updateMicros", (Object)TimeUnit.NANOSECONDS.toMicros(updateNanos - updateStart));
                    if (timerSnapshot != null && this.state.context.getTimer() != null) {
                        logMessage.addKeysAndValues(StoreTimer.getDifference((StoreTimer)this.state.context.getTimer(), (StoreTimerSnapshot)timerSnapshot).getKeysAndValues());
                    }
                    LOGGER.debug(logMessage.toString());
                }
                return records.size();
            });
        });
    }

    @VisibleForTesting
    public CompletableFuture<List<LucenePartitionInfoProto.LucenePartitionInfo>> getAllPartitionMetaInfo(@Nonnull Tuple groupingKey) {
        Range range = this.state.indexSubspace.subspace(groupingKey.add(0L)).range();
        AsyncIterable rangeIterable = this.state.context.ensureActive().getRange(range, Integer.MAX_VALUE, true, StreamingMode.WANT_ALL);
        return AsyncUtil.collect((AsyncIterable)rangeIterable, (Executor)this.state.context.getExecutor()).thenApply(all -> all.stream().map(LucenePartitioner::partitionInfoFromKV).collect(Collectors.toList()));
    }

    @Nonnull
    public CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> getPartitionMetaInfoById(int partitionId, @Nonnull Tuple groupingKey) {
        return this.getAllPartitionMetaInfo(groupingKey).thenApply(partitionInfos -> partitionInfos.stream().filter(partition -> partition.getId() == partitionId).findAny().orElse(null));
    }

    @Nonnull
    public static CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> getNextOlderPartitionInfo(@Nonnull FDBRecordContext context, @Nonnull Tuple groupingKey, @Nullable Tuple previousKey, @Nonnull Subspace indexSubspace) {
        if (previousKey == null) {
            return LucenePartitioner.getNewestPartition(groupingKey, context, indexSubspace);
        }
        Range range = new TupleRange(groupingKey.add(0L), groupingKey.add(0L).addAll(previousKey), EndpointType.TREE_START, EndpointType.RANGE_EXCLUSIVE).toRange(indexSubspace);
        AsyncIterable rangeIterable = context.ensureActive().getRange(range, Integer.MAX_VALUE, true, StreamingMode.WANT_ALL);
        return AsyncUtil.collect((AsyncIterable)rangeIterable, (Executor)context.getExecutor()).thenApply(all -> all.stream().map(LucenePartitioner::partitionInfoFromKV).findFirst().orElse(null));
    }

    @Nonnull
    public static CompletableFuture<LucenePartitionInfoProto.LucenePartitionInfo> getNextNewerPartitionInfo(@Nonnull FDBRecordContext context, @Nonnull Tuple groupingKey, @Nullable Tuple currentPartitionKey, @Nonnull Subspace indexSubspace) {
        if (currentPartitionKey == null) {
            return LucenePartitioner.getNewestPartition(groupingKey, context, indexSubspace);
        }
        Range range = new Range(ByteArrayUtil.strinc((byte[])indexSubspace.subspace(groupingKey.add(0L).addAll(currentPartitionKey)).pack()), ByteArrayUtil.strinc((byte[])indexSubspace.subspace(groupingKey.add(0L)).pack()));
        AsyncIterable rangeIterable = context.ensureActive().getRange(range, 1, false, StreamingMode.WANT_ALL);
        return AsyncUtil.collect((AsyncIterable)rangeIterable, (Executor)context.getExecutor()).thenApply(all -> all.stream().map(LucenePartitioner::partitionInfoFromKV).findFirst().orElse(null));
    }

    @Nonnull
    private <M extends Message> Tuple toPartitionKey(@Nonnull FDBIndexableRecord<M> record) {
        return this.toPartitionKey(this.getPartitioningFieldValue(record), record.getPrimaryKey());
    }

    @Nonnull
    public Tuple toPartitionKey(@Nonnull Object partitioningFieldValue, @Nonnull Tuple primaryKey) {
        return Tuple.from((Object[])new Object[]{partitioningFieldValue}).addAll(primaryKey);
    }

    public static boolean isOlderThan(@Nonnull Tuple key, @Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo) {
        return key.compareTo(Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray())) < 0;
    }

    public static boolean isPrefixOlderThanPartition(@Nonnull Tuple prefix, @Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo) {
        return ByteArrayUtil.compareUnsigned((byte[])LucenePartitioner.getPartitionKey(partitionInfo).pack(), (byte[])ByteArrayUtil.strinc((byte[])prefix.pack())) >= 0;
    }

    public static boolean isNewerThan(@Nonnull Tuple key, @Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo) {
        return key.compareTo(Tuple.fromBytes((byte[])partitionInfo.getTo().toByteArray())) > 0;
    }

    @Nonnull
    public static Tuple getPartitionKey(@Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo) {
        return Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray());
    }

    @Nonnull
    public static Tuple getToTuple(@Nonnull LucenePartitionInfoProto.LucenePartitionInfo partitionInfo) {
        return Tuple.fromBytes((byte[])partitionInfo.getTo().toByteArray());
    }

    @Nonnull
    public static Pair<LucenePartitionInfoProto.LucenePartitionInfo, LucenePartitionInfoProto.LucenePartitionInfo> getPartitionNeighbors(@Nonnull List<LucenePartitionInfoProto.LucenePartitionInfo> allPartitions, int currentPartitionPosition) {
        LucenePartitionInfoProto.LucenePartitionInfo leftPartition = currentPartitionPosition == 0 ? null : allPartitions.get(currentPartitionPosition - 1);
        LucenePartitionInfoProto.LucenePartitionInfo rightPartition = currentPartitionPosition == allPartitions.size() - 1 ? null : allPartitions.get(currentPartitionPosition + 1);
        return Pair.of((Object)leftPartition, rightPartition);
    }

    private /* synthetic */ CompletableFuture lambda$rebalancePartitions$29(RecordCursor cursor, int groupingCount, int documentCount, RepartitioningLogMessages logMessages, AtomicReference continuation) {
        return cursor.onNext().thenCompose(cursorResult -> {
            if (cursorResult.hasNext()) {
                Tuple groupingKey = Tuple.fromItems(((Tuple)cursorResult.get()).getItems().subList(0, groupingCount));
                return this.processPartitionRebalancing(groupingKey, documentCount, logMessages).thenCompose(movedCount -> {
                    if (movedCount > 0) {
                        return AsyncUtil.READY_FALSE;
                    }
                    continuation.set(cursorResult.getContinuation());
                    return AsyncUtil.READY_TRUE;
                });
            }
            continuation.set(cursorResult.getContinuation());
            return AsyncUtil.READY_FALSE;
        });
    }

    static class PartitionedQueryHint {
        static final PartitionedQueryHint NO_MATCHES = new PartitionedQueryHint(false, null);
        @Nullable
        final LucenePartitionInfoProto.LucenePartitionInfo startPartition;
        final boolean canHaveMatches;

        PartitionedQueryHint(boolean canHaveMatches, LucenePartitionInfoProto.LucenePartitionInfo startPartition) {
            this.canHaveMatches = canHaveMatches;
            this.startPartition = startPartition;
        }

        public String toString() {
            return "PartitionedQueryHint{startPartition=" + String.valueOf(this.startPartition) + ", canHaveMatches=" + this.canHaveMatches + "}";
        }
    }

    static class PartitionedSortContext {
        boolean isByPartitionField;
        boolean isReverse;
        @Nullable
        SortField[] updatedSortFields;

        PartitionedSortContext(boolean isByPartitionField, boolean isReverse, @Nullable SortField[] updatedSortFields) {
            this.isByPartitionField = isByPartitionField;
            this.isReverse = isReverse;
            this.updatedSortFields = updatedSortFields;
        }
    }

    public static class RepartitioningLogMessages {
        List<Object> logMessages;

        public RepartitioningLogMessages(int partitionId, Tuple partitionKey, int repartitionDocCount) {
            this.logMessages = Arrays.asList(LogMessageKeys.PARTITION_ID, partitionId, LogMessageKeys.PARTITIONING_KEY, partitionKey, LogMessageKeys.INDEX_REPARTITION_DOCUMENT_COUNT, repartitionDocCount);
        }

        public RepartitioningLogMessages setPartitionId(int partitionId) {
            this.logMessages.set(1, partitionId);
            return this;
        }

        public RepartitioningLogMessages setPartitionKey(Tuple partitionKey) {
            this.logMessages.set(3, partitionKey);
            return this;
        }

        public RepartitioningLogMessages setRepartitionDocCount(int repartitionDocCount) {
            this.logMessages.set(5, repartitionDocCount);
            return this;
        }
    }

    private static class RepartitionTimings {
        long initializationNanos;
        long clearInfoNanos;
        long startNanos;
        long searchNanos;
        long emptyingNanos;
        long deleteNanos;
        long metadataUpdateNanos;
        long createPartitionNanos;

        private RepartitionTimings() {
        }
    }
}

