/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.IndexFetchMethod;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.lucene.LuceneBooleanQuery;
import com.apple.foundationdb.record.lucene.LuceneFunctionKeyExpression;
import com.apple.foundationdb.record.lucene.LuceneIndexSpellCheckQueryPlan;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryFieldComparisonClause;
import com.apple.foundationdb.record.lucene.LuceneScanParameters;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.LuceneScanTypes;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.planprotos.PLuceneIndexQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.PlanOrderingKey;
import com.apple.foundationdb.record.query.plan.PlanWithOrderingKey;
import com.apple.foundationdb.record.query.plan.PlanWithStoredFields;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithExplain;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SpotBugsSuppressWarnings(value={"HE_EQUALS_NO_HASHCODE"})
public class LuceneIndexQueryPlan
extends RecordQueryIndexPlan
implements PlanWithOrderingKey,
PlanWithStoredFields,
RecordQueryPlanWithExplain {
    @Nullable
    private final PlanOrderingKey planOrderingKey;
    @Nullable
    private final List<KeyExpression> storedFields;

    protected LuceneIndexQueryPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneIndexQueryPlan luceneIndexQueryPlanProto) {
        super(serializationContext, Objects.requireNonNull(luceneIndexQueryPlanProto.getSuper()));
        this.planOrderingKey = null;
        Verify.verify((boolean)luceneIndexQueryPlanProto.hasHasStoredFields());
        if (luceneIndexQueryPlanProto.getHasStoredFields()) {
            this.storedFields = Lists.newArrayList();
            for (int i = 0; i < luceneIndexQueryPlanProto.getStoredFieldsCount(); ++i) {
                this.storedFields.add(KeyExpression.fromProto((RecordKeyExpressionProto.KeyExpression)luceneIndexQueryPlanProto.getStoredFields(i)));
            }
        } else {
            this.storedFields = null;
        }
    }

    protected LuceneIndexQueryPlan(@Nonnull String indexName, @Nonnull LuceneScanParameters scanParameters, @Nonnull RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords, boolean reverse, @Nullable PlanOrderingKey planOrderingKey, @Nullable List<KeyExpression> storedFields) {
        super(indexName, null, (IndexScanParameters)scanParameters, IndexFetchMethod.SCAN_AND_FETCH, fetchIndexRecords, reverse, false);
        this.planOrderingKey = planOrderingKey;
        this.storedFields = storedFields;
    }

    public boolean allowedForCoveringIndexPlan() {
        return true;
    }

    public boolean hasComparisons() {
        return true;
    }

    public Set<Comparisons.Comparison> getComparisons() {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        if (this.scanParameters instanceof LuceneScanParameters) {
            LuceneScanParameters luceneScanParameters = (LuceneScanParameters)this.scanParameters;
            ScanComparisons groupScanComparisons = luceneScanParameters.getGroupComparisons();
            resultBuilder.addAll((Iterable)groupScanComparisons.getEqualityComparisons());
            resultBuilder.addAll((Iterable)groupScanComparisons.getInequalityComparisons());
            if (luceneScanParameters instanceof LuceneScanQueryParameters) {
                LuceneScanQueryParameters luceneScanQueryParameters = (LuceneScanQueryParameters)luceneScanParameters;
                LuceneQueryClause queryClause = luceneScanQueryParameters.getQuery();
                resultBuilder.addAll(this.collectComparisons(queryClause));
            }
        }
        return resultBuilder.build();
    }

    @Nonnull
    private Set<Comparisons.Comparison> collectComparisons(@Nonnull LuceneQueryClause queryClause) {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        if (queryClause instanceof LuceneQueryFieldComparisonClause) {
            resultBuilder.add((Object)((LuceneQueryFieldComparisonClause)queryClause).getComparison());
        } else if (queryClause instanceof LuceneBooleanQuery) {
            for (LuceneQueryClause andTerm : ((LuceneBooleanQuery)queryClause).getChildren()) {
                resultBuilder.addAll(this.collectComparisons(andTerm));
            }
        }
        return resultBuilder.build();
    }

    @Nullable
    public PlanOrderingKey getPlanOrderingKey() {
        return this.planOrderingKey;
    }

    @Nullable
    public List<KeyExpression> getStoredFields() {
        return this.storedFields;
    }

    public void getStoredFields(@Nonnull List<KeyExpression> keyFields, @Nonnull List<KeyExpression> nonStoredFields, @Nonnull List<KeyExpression> otherFields) {
        int i = 0;
        while (i < nonStoredFields.size()) {
            KeyExpression origField = nonStoredFields.get(i);
            KeyExpression field = LuceneIndexQueryPlan.removeLuceneAnnotations(origField);
            if (field != origField) {
                nonStoredFields.set(i, field);
                int j = keyFields.indexOf(origField);
                if (j >= 0) {
                    keyFields.set(j, field);
                }
            }
            if (this.storedFields != null && this.storedFields.contains(origField)) {
                nonStoredFields.remove(i);
                continue;
            }
            ++i;
        }
        if (this.planOrderingKey != null) {
            for (KeyExpression orderingKey : this.planOrderingKey.getKeys()) {
                if (!(orderingKey instanceof LuceneFunctionKeyExpression.LuceneSortBy)) continue;
                otherFields.add(orderingKey);
            }
        }
    }

    private static KeyExpression removeLuceneAnnotations(@Nonnull KeyExpression field) {
        if (field instanceof NestingKeyExpression) {
            KeyExpression origChild = ((NestingKeyExpression)field).getChild();
            KeyExpression child = LuceneIndexQueryPlan.removeLuceneAnnotations(origChild);
            if (child == origChild) {
                return field;
            }
            return new NestingKeyExpression(((NestingKeyExpression)field).getParent(), child);
        }
        while (field instanceof LuceneFunctionKeyExpression) {
            if (field instanceof LuceneFunctionKeyExpression.LuceneSorted) {
                field = ((LuceneFunctionKeyExpression.LuceneSorted)field).getSortedExpression();
                continue;
            }
            if (!(field instanceof LuceneFunctionKeyExpression.LuceneStored)) break;
            field = ((LuceneFunctionKeyExpression.LuceneStored)field).getStoredExpression();
        }
        return field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LuceneIndexQueryPlan that = (LuceneIndexQueryPlan)((Object)o);
        return Objects.equals(this.planOrderingKey, that.planOrderingKey) && Objects.equals(this.storedFields, that.storedFields);
    }

    public int computeHashCodeWithoutChildren() {
        return Objects.hash(super.computeHashCodeWithoutChildren(), this.planOrderingKey, this.storedFields);
    }

    @Nonnull
    protected RecordQueryIndexPlan withIndexScanParameters(@Nonnull IndexScanParameters newIndexScanParameters) {
        Verify.verify((boolean)(newIndexScanParameters instanceof LuceneScanParameters));
        Verify.verify((boolean)newIndexScanParameters.getScanType().equals((Object)LuceneScanTypes.BY_LUCENE));
        return new LuceneIndexQueryPlan(this.getIndexName(), (LuceneScanParameters)newIndexScanParameters, this.getFetchIndexRecords(), this.reverse, this.planOrderingKey, this.storedFields);
    }

    @Nonnull
    public static LuceneIndexQueryPlan of(@Nonnull String indexName, @Nonnull LuceneScanParameters scanParameters, @Nonnull RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords, boolean reverse, @Nullable PlanOrderingKey planOrderingKey, @Nullable List<KeyExpression> storedFields) {
        if (scanParameters.getScanType().equals((Object)LuceneScanTypes.BY_LUCENE)) {
            return new LuceneIndexQueryPlan(indexName, scanParameters, fetchIndexRecords, reverse, planOrderingKey, storedFields);
        }
        if (scanParameters.getScanType().equals((Object)LuceneScanTypes.BY_LUCENE_SPELL_CHECK)) {
            return new LuceneIndexSpellCheckQueryPlan(indexName, scanParameters, fetchIndexRecords, reverse, planOrderingKey, storedFields);
        }
        throw new RecordCoreException("unknown lucene scan warranted by caller", new Object[0]);
    }

    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        return ExplainTokensWithPrecedence.of((ExplainTokens)new ExplainTokens().addKeyword("LISCAN").addOptionalWhitespace().addOpeningParen().addNested(ExplainPlanVisitor.indexDetails((RecordQueryIndexPlan)this)).addOptionalWhitespace().addClosingParen());
    }

    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        return this.toLuceneIndexPlanProto(serializationContext);
    }

    @Nonnull
    public PLuceneIndexQueryPlan toLuceneIndexPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        PLuceneIndexQueryPlan.Builder builder = PLuceneIndexQueryPlan.newBuilder().setSuper(this.toRecordQueryIndexPlanProto(serializationContext));
        builder.setHasStoredFields(this.storedFields != null);
        if (this.storedFields != null) {
            for (KeyExpression storedField : this.storedFields) {
                builder.addStoredFields(storedField.toKeyExpression());
            }
        }
        return builder.build();
    }

    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setAdditionalPlans(PlanSerialization.protoObjectToAny((PlanSerializationContext)serializationContext, (Message)this.toLuceneIndexPlanProto(serializationContext))).build();
    }

    @Nonnull
    public static LuceneIndexQueryPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneIndexQueryPlan luceneIndexQueryPlanProto) {
        return new LuceneIndexQueryPlan(serializationContext, luceneIndexQueryPlanProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PLuceneIndexQueryPlan, LuceneIndexQueryPlan> {
        @Nonnull
        public Class<PLuceneIndexQueryPlan> getProtoMessageClass() {
            return PLuceneIndexQueryPlan.class;
        }

        @Nonnull
        public LuceneIndexQueryPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneIndexQueryPlan luceneIndexQueryPlanProto) {
            return LuceneIndexQueryPlan.fromProto(serializationContext, luceneIndexQueryPlanProto);
        }
    }
}

