/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneFunctionKeyExpression;
import com.apple.foundationdb.record.lucene.search.BooleanPointsConfig;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.RecordTypeKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.google.common.collect.Streams;
import com.google.protobuf.Descriptors;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;

public class LuceneIndexExpressions {
    private LuceneIndexExpressions() {
    }

    public static void validate(@Nonnull KeyExpression root, @Nonnull Descriptors.Descriptor recordType) {
        LuceneIndexExpressions.getFields(root, new MetaDataSource(recordType), (source, fieldName, value, type, fieldNameOverride, namedFieldPath, namedFieldSuffix, stored, sorted, overriddeKeyRanges, groupingKeyIndex, keyIndex, fieldConfigsIgnored) -> {}, null);
    }

    @Nonnull
    public static Map<String, DocumentFieldDerivation> getDocumentFieldDerivations(@Nonnull Index index, @Nonnull RecordMetaData metadata) {
        Map<String, DocumentFieldDerivation> combined = null;
        for (RecordType recordType : metadata.recordTypesForIndex(index)) {
            Map<String, DocumentFieldDerivation> documentFields = LuceneIndexExpressions.getDocumentFieldDerivations(index.getRootExpression(), recordType.getDescriptor());
            if (combined == null) {
                combined = documentFields;
                continue;
            }
            combined.putAll(documentFields);
        }
        if (combined == null) {
            combined = Collections.emptyMap();
        }
        return combined;
    }

    public static Map<String, DocumentFieldDerivation> getDocumentFieldDerivations(@Nonnull KeyExpression root, @Nonnull Descriptors.Descriptor recordType) {
        HashMap<String, DocumentFieldDerivation> fields = new HashMap<String, DocumentFieldDerivation>();
        LuceneIndexExpressions.getFields(root, new MetaDataSource(recordType), (source, fieldName, value, type, fieldNameOverride, namedFieldPath, namedFieldSuffix, stored, sorted, overriddenKeyRanges, groupingKeyIndex, keyIndex, fieldConfigsIgnored) -> {
            ArrayList<String> path = new ArrayList<String>();
            for (MetaDataSource metaDataSource = source; metaDataSource != null; metaDataSource = metaDataSource.getParent()) {
                if (metaDataSource.getField() == null) continue;
                path.add(0, metaDataSource.getField());
            }
            if (fieldNameOverride && namedFieldPath != null) {
                path.addAll(namedFieldPath);
            } else {
                path.add((String)value);
            }
            DocumentFieldDerivation derivation = new DocumentFieldDerivation(fieldName, path, type, fieldNameOverride, namedFieldSuffix, stored, sorted);
            fields.put(fieldName, derivation);
        }, null);
        return fields;
    }

    @Nonnull
    public static Map<String, PointsConfig> constructPointConfigMap(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index) {
        HashMap<String, PointsConfig> result = new HashMap<String, PointsConfig>();
        for (RecordType type : store.getRecordMetaData().recordTypesForIndex(index)) {
            LuceneIndexExpressions.getDocumentFieldDerivations(index.getRootExpression(), type.getDescriptor()).forEach((key, value) -> {
                PointsConfig valueConfig = value.getPointsConfig();
                if (valueConfig != null) {
                    PointsConfig oldConfig = (PointsConfig)result.get(key);
                    if (oldConfig == null) {
                        result.put((String)key, valueConfig);
                    } else if (!oldConfig.equals((Object)valueConfig)) {
                        throw new RecordCoreException("The same key has two different points config types", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.KEY, key});
                    }
                }
            });
        }
        return result;
    }

    @Nonnull
    public static <T extends RecordSource<T>> void getFields(@Nonnull KeyExpression root, @Nonnull T source, @Nonnull DocumentDestination<T> destination, @Nullable String fieldNamePrefix) {
        KeyExpression expression = root instanceof GroupingKeyExpression ? ((GroupingKeyExpression)root).getGroupedSubKey() : root;
        LuceneIndexExpressions.getFieldsRecursively(expression, source, destination, fieldNamePrefix, 0, root instanceof GroupingKeyExpression ? ((GroupingKeyExpression)root).getGroupingCount() : 0, new ArrayList<Integer>());
    }

    public static <T extends RecordSource<T>> void getFieldsRecursively(@Nonnull KeyExpression expression, @Nonnull T source, @Nonnull DocumentDestination<T> destination, @Nullable String fieldNamePrefix, int keyIndex, int groupingCount, @Nonnull List<Integer> overriddenKeyRanges) {
        block35: {
            DocumentFieldType fieldType;
            String fieldName;
            FieldKeyExpression fieldExpression;
            Map<String, Object> configs;
            boolean fieldStored;
            boolean fieldSorted;
            List<String> namedFieldPath;
            boolean suffixOverride;
            String fieldNameSuffix;
            block37: {
                Descriptors.FieldDescriptor fieldDescriptor;
                block36: {
                    if (expression instanceof RecordTypeKeyExpression) {
                        return;
                    }
                    if (expression instanceof ThenKeyExpression) {
                        int count = 0;
                        for (KeyExpression child : ((ThenKeyExpression)expression).getChildren()) {
                            LuceneIndexExpressions.getFieldsRecursively(child, source, destination, fieldNamePrefix, keyIndex + count, groupingCount, overriddenKeyRanges);
                            count += child.getColumnSize();
                        }
                        return;
                    }
                    fieldNameSuffix = null;
                    suffixOverride = false;
                    namedFieldPath = null;
                    if (expression instanceof LuceneFunctionKeyExpression.LuceneFieldName) {
                        LuceneFunctionKeyExpression.LuceneFieldName fieldNameExpression = (LuceneFunctionKeyExpression.LuceneFieldName)expression;
                        KeyExpression nameExpression = fieldNameExpression.getNameExpression();
                        if (nameExpression instanceof LiteralKeyExpression) {
                            fieldNameSuffix = (String)((LiteralKeyExpression)nameExpression).getValue();
                        } else if (nameExpression instanceof FieldKeyExpression) {
                            Iterator<Object> names = source.getValues(nameExpression).iterator();
                            if (names.hasNext()) {
                                fieldNameSuffix = (String)names.next();
                                if (names.hasNext()) {
                                    throw new RecordCoreException("Lucene field name override should evaluate to single value", new Object[0]);
                                }
                                namedFieldPath = Collections.singletonList(fieldNameSuffix);
                            }
                        } else if (nameExpression instanceof NestingKeyExpression) {
                            Iterable<Object> values = source.getValues(nameExpression);
                            namedFieldPath = Streams.stream(values).map(String.class::cast).collect(Collectors.toList());
                            fieldNameSuffix = String.join((CharSequence)"_", namedFieldPath);
                        } else {
                            throw new RecordCoreException("Lucene field name override should be a literal or a field", new Object[0]);
                        }
                        suffixOverride = true;
                        expression = fieldNameExpression.getNamedExpression();
                    }
                    if (expression instanceof NestingKeyExpression) {
                        NestingKeyExpression nestingExpression = (NestingKeyExpression)expression;
                        FieldKeyExpression parentExpression = nestingExpression.getParent();
                        KeyExpression child = nestingExpression.getChild();
                        if (!suffixOverride) {
                            fieldNameSuffix = parentExpression.getFieldName();
                        } else {
                            LuceneIndexExpressions.addOverriddenKeyRange(overriddenKeyRanges, fieldNamePrefix, fieldNameSuffix);
                        }
                        String fieldName2 = LuceneIndexExpressions.appendFieldName(fieldNamePrefix, fieldNameSuffix);
                        for (RecordSource subsource : source.getChildren(parentExpression)) {
                            LuceneIndexExpressions.getFieldsRecursively(child, subsource, destination, fieldName2, keyIndex, groupingCount, overriddenKeyRanges);
                        }
                        if (suffixOverride) {
                            LuceneIndexExpressions.removedLastOverriddenKeyRange(overriddenKeyRanges);
                        }
                        return;
                    }
                    fieldSorted = false;
                    fieldStored = false;
                    boolean fieldText = false;
                    configs = Collections.emptyMap();
                    while (true) {
                        if (expression instanceof LuceneFunctionKeyExpression.LuceneSorted) {
                            LuceneFunctionKeyExpression.LuceneSorted sortedExpression = (LuceneFunctionKeyExpression.LuceneSorted)expression;
                            fieldSorted = true;
                            expression = sortedExpression.getSortedExpression();
                            continue;
                        }
                        if (expression instanceof LuceneFunctionKeyExpression.LuceneStored) {
                            LuceneFunctionKeyExpression.LuceneStored storedExpression = (LuceneFunctionKeyExpression.LuceneStored)expression;
                            fieldStored = true;
                            expression = storedExpression.getStoredExpression();
                            continue;
                        }
                        if (!(expression instanceof LuceneFunctionKeyExpression.LuceneText)) break;
                        LuceneFunctionKeyExpression.LuceneText textExpression = (LuceneFunctionKeyExpression.LuceneText)expression;
                        fieldText = true;
                        expression = textExpression.getFieldExpression();
                        configs = textExpression.getFieldConfigs();
                    }
                    if (!(expression instanceof FieldKeyExpression)) break block35;
                    fieldExpression = (FieldKeyExpression)expression;
                    if (!suffixOverride) {
                        fieldNameSuffix = fieldExpression.getFieldName();
                    } else {
                        LuceneIndexExpressions.addOverriddenKeyRange(overriddenKeyRanges, fieldNamePrefix, fieldNameSuffix);
                    }
                    fieldName = LuceneIndexExpressions.appendFieldName(fieldNamePrefix, fieldNameSuffix);
                    if (fieldName == null) {
                        fieldName = "_";
                    }
                    Descriptors.Descriptor recordDescriptor = source.getDescriptor();
                    fieldDescriptor = recordDescriptor.findFieldByName(fieldExpression.getFieldName());
                    if (!fieldText) break block36;
                    switch (fieldDescriptor.getJavaType()) {
                        case STRING: {
                            fieldType = DocumentFieldType.TEXT;
                            break block37;
                        }
                        default: {
                            throw new RecordCoreException("Unknown Lucene text field type", new Object[0]);
                        }
                    }
                }
                switch (fieldDescriptor.getJavaType()) {
                    case STRING: {
                        fieldType = DocumentFieldType.STRING;
                        break;
                    }
                    case INT: {
                        fieldType = DocumentFieldType.INT;
                        break;
                    }
                    case LONG: {
                        fieldType = DocumentFieldType.LONG;
                        break;
                    }
                    case DOUBLE: {
                        fieldType = DocumentFieldType.DOUBLE;
                        break;
                    }
                    case BOOLEAN: {
                        fieldType = DocumentFieldType.BOOLEAN;
                        break;
                    }
                    default: {
                        throw new RecordCoreException("Unknown Lucene field type", new Object[0]);
                    }
                }
            }
            for (Object value : source.getValues((KeyExpression)fieldExpression)) {
                destination.addField(source, fieldName, value, fieldType, suffixOverride, namedFieldPath, fieldNameSuffix, fieldStored, fieldSorted, overriddenKeyRanges, keyIndex < groupingCount ? keyIndex : -1, keyIndex, configs);
            }
            if (suffixOverride) {
                LuceneIndexExpressions.removedLastOverriddenKeyRange(overriddenKeyRanges);
            }
            return;
        }
        throw new RecordCoreException("Unknown Lucene field key expression", new Object[0]);
    }

    private static void addOverriddenKeyRange(@Nonnull List<Integer> overriddenKeyRanges, @Nullable String fieldNamePrefix, @Nullable String fieldNameSuffix) {
        if (fieldNamePrefix == null) {
            overriddenKeyRanges.add(0);
            overriddenKeyRanges.add(fieldNameSuffix == null || fieldNameSuffix.isEmpty() ? 0 : fieldNameSuffix.length());
        } else {
            overriddenKeyRanges.add(fieldNamePrefix.length() + 1);
            overriddenKeyRanges.add(fieldNameSuffix == null || fieldNameSuffix.isEmpty() ? fieldNamePrefix.length() + 1 : fieldNamePrefix.length() + fieldNameSuffix.length() + 1);
        }
    }

    private static void removedLastOverriddenKeyRange(@Nonnull List<Integer> overriddenKeyRanges) {
        if (overriddenKeyRanges.size() < 2) {
            throw new RecordCoreException("Invalid call to remove last overridden key range, since the list has not a full range to remove", new Object[0]);
        }
        overriddenKeyRanges.remove(overriddenKeyRanges.size() - 1);
        overriddenKeyRanges.remove(overriddenKeyRanges.size() - 1);
    }

    @Nullable
    private static String appendFieldName(@Nullable String fieldNamePrefix, @Nullable String fieldNameSuffix) {
        if (fieldNamePrefix == null) {
            return fieldNameSuffix;
        }
        if (fieldNameSuffix == null) {
            return fieldNamePrefix;
        }
        return fieldNamePrefix + "_" + fieldNameSuffix;
    }

    static class MetaDataSource
    implements RecordSource<MetaDataSource> {
        @Nullable
        private final MetaDataSource parent;
        @Nullable
        private final String field;
        @Nonnull
        private final Descriptors.Descriptor descriptor;

        MetaDataSource(@Nonnull Descriptors.Descriptor descriptor) {
            this(null, null, descriptor);
        }

        MetaDataSource(@Nullable MetaDataSource parent, @Nullable String field, @Nonnull Descriptors.Descriptor descriptor) {
            this.parent = parent;
            this.field = field;
            this.descriptor = descriptor;
        }

        @Nullable
        public MetaDataSource getParent() {
            return this.parent;
        }

        @Nullable
        public String getField() {
            return this.field;
        }

        @Override
        public Descriptors.Descriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Iterable<MetaDataSource> getChildren(@Nonnull FieldKeyExpression parentExpression) {
            String parentField = parentExpression.getFieldName();
            Descriptors.FieldDescriptor fieldDescriptor = this.descriptor.findFieldByName(parentField);
            return Collections.singletonList(new MetaDataSource(this, parentField, fieldDescriptor.getMessageType()));
        }

        @Override
        public Iterable<Object> getValues(@Nonnull KeyExpression keyExpression) {
            ArrayList<Object> result = new ArrayList<Object>();
            KeyExpression current = keyExpression;
            while (current != null) {
                if (current instanceof NestingKeyExpression) {
                    NestingKeyExpression expression = (NestingKeyExpression)current;
                    result.add(expression.getParent().getFieldName());
                    current = expression.getChild();
                    continue;
                }
                if (current instanceof FieldKeyExpression) {
                    result.add(((FieldKeyExpression)current).getFieldName());
                    current = null;
                    continue;
                }
                throw new RecordCoreArgumentException("Nested key type not supported for values", new Object[0]).addLogInfo("keyType", (Object)current.getClass().getName());
            }
            return result;
        }
    }

    public static interface DocumentDestination<T extends RecordSource<T>> {
        public void addField(@Nonnull T var1, @Nonnull String var2, @Nullable Object var3, @Nonnull DocumentFieldType var4, boolean var5, @Nullable List<String> var6, @Nullable String var7, boolean var8, boolean var9, @Nonnull List<Integer> var10, int var11, int var12, @Nonnull Map<String, Object> var13);
    }

    public static interface RecordSource<T extends RecordSource<T>> {
        @Nonnull
        public Descriptors.Descriptor getDescriptor();

        @Nonnull
        public Iterable<T> getChildren(@Nonnull FieldKeyExpression var1);

        @Nonnull
        public Iterable<Object> getValues(@Nonnull KeyExpression var1);
    }

    public static enum DocumentFieldType {
        STRING,
        TEXT,
        INT,
        LONG,
        DOUBLE,
        BOOLEAN;

    }

    public static class DocumentFieldDerivation {
        @Nonnull
        private final String documentField;
        @Nonnull
        private final List<String> recordFieldPath;
        @Nonnull
        private final DocumentFieldType type;
        private final boolean fieldNameOverride;
        @Nullable
        private final String namedFieldSuffix;
        private final boolean stored;
        private final boolean sorted;

        public DocumentFieldDerivation(@Nonnull String documentField, @Nonnull List<String> recordFieldPath, @Nonnull DocumentFieldType type, boolean fieldNameOverride, @Nullable String namedFieldSuffix, boolean stored, boolean sorted) {
            this.documentField = documentField;
            this.recordFieldPath = recordFieldPath;
            this.type = type;
            this.fieldNameOverride = fieldNameOverride;
            this.namedFieldSuffix = namedFieldSuffix;
            this.stored = stored;
            this.sorted = sorted;
        }

        @Nonnull
        public String getDocumentField() {
            return this.documentField;
        }

        @Nonnull
        public List<String> getRecordFieldPath() {
            return this.recordFieldPath;
        }

        @Nonnull
        public DocumentFieldType getType() {
            return this.type;
        }

        public boolean isFieldNameOverride() {
            return this.fieldNameOverride;
        }

        @Nullable
        public String getNamedFieldSuffix() {
            return this.namedFieldSuffix;
        }

        public boolean isStored() {
            return this.stored;
        }

        public boolean isSorted() {
            return this.sorted;
        }

        public PointsConfig getPointsConfig() {
            switch (this.type) {
                case INT: {
                    return new PointsConfig(NumberFormat.getInstance(Locale.ROOT), Integer.class);
                }
                case LONG: {
                    return new PointsConfig(NumberFormat.getInstance(Locale.ROOT), Long.class);
                }
                case DOUBLE: {
                    return new PointsConfig(NumberFormat.getInstance(Locale.ROOT), Double.class);
                }
                case BOOLEAN: {
                    return new BooleanPointsConfig(NumberFormat.getInstance(Locale.ROOT));
                }
            }
            return null;
        }
    }
}

