/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.lucene.LuceneContinuationProto;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ByteString;
import com.google.protobuf.ZeroCopyByteString;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.BytesRef;

class LuceneCursorContinuation
implements RecordCursorContinuation {
    @Nonnull
    private final LuceneContinuationProto.LuceneIndexContinuation protoContinuation;
    private volatile byte[] byteContinuation;

    private LuceneCursorContinuation(@Nonnull LuceneContinuationProto.LuceneIndexContinuation protoContinuation) {
        this.protoContinuation = protoContinuation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] toBytes() {
        if (this.byteContinuation == null) {
            LuceneCursorContinuation luceneCursorContinuation = this;
            synchronized (luceneCursorContinuation) {
                if (this.byteContinuation == null) {
                    this.byteContinuation = this.toByteString().toByteArray();
                }
            }
        }
        return this.byteContinuation;
    }

    @Nonnull
    public ByteString toByteString() {
        return this.protoContinuation.toByteString();
    }

    public boolean isEnd() {
        return false;
    }

    public static LuceneCursorContinuation fromScoreDoc(ScoreDoc scoreDoc, @Nullable Integer partitionId, @Nullable Tuple partitionKey) {
        LuceneContinuationProto.LuceneIndexContinuation.Builder builder = LuceneContinuationProto.LuceneIndexContinuation.newBuilder().setDoc(scoreDoc.doc).setShard(scoreDoc.shardIndex).setScore(scoreDoc.score);
        if (partitionId != null) {
            builder.setPartitionId(partitionId);
        }
        if (partitionKey != null) {
            builder.setPartitionKey(ByteString.copyFrom((byte[])partitionKey.pack()));
        }
        if (scoreDoc instanceof FieldDoc) {
            for (Object field : ((FieldDoc)scoreDoc).fields) {
                LuceneContinuationProto.LuceneIndexContinuation.Field.Builder value = builder.addFieldsBuilder();
                if (field instanceof BytesRef) {
                    BytesRef bytesRefField = (BytesRef)field;
                    value.setB(ZeroCopyByteString.wrap((byte[])bytesRefField.bytes, (int)0, (int)bytesRefField.length));
                    continue;
                }
                if (field instanceof String) {
                    value.setS((String)field);
                    continue;
                }
                if (field instanceof Float) {
                    value.setF(((Float)field).floatValue());
                    continue;
                }
                if (field instanceof Double) {
                    value.setD((Double)field);
                    continue;
                }
                if (field instanceof Integer) {
                    value.setI((Integer)field);
                    continue;
                }
                if (field instanceof Long) {
                    value.setL((Long)field);
                    continue;
                }
                throw new RecordCoreException("Unknown sort field type", new Object[0]);
            }
        }
        return new LuceneCursorContinuation(builder.build());
    }

    @Nonnull
    public static ScoreDoc toScoreDoc(@Nonnull LuceneContinuationProto.LuceneIndexContinuation luceneIndexContinuation) {
        int doc = (int)luceneIndexContinuation.getDoc();
        float score = luceneIndexContinuation.getScore();
        int shard = (int)luceneIndexContinuation.getShard();
        int nfields = luceneIndexContinuation.getFieldsCount();
        if (nfields == 0) {
            return new ScoreDoc(doc, score, shard);
        }
        Object[] fields = new Object[nfields];
        for (int i = 0; i < nfields; ++i) {
            Object value;
            LuceneContinuationProto.LuceneIndexContinuation.Field field = luceneIndexContinuation.getFields(i);
            switch (field.getValueCase()) {
                case I: {
                    value = field.getI();
                    break;
                }
                case L: {
                    value = field.getL();
                    break;
                }
                case F: {
                    value = Float.valueOf(field.getF());
                    break;
                }
                case D: {
                    value = field.getD();
                    break;
                }
                case S: {
                    value = field.getS();
                    break;
                }
                case B: {
                    value = new BytesRef(field.getB().toByteArray());
                    break;
                }
                default: {
                    value = null;
                }
            }
            fields[i] = value;
        }
        return new FieldDoc(doc, score, fields, shard);
    }
}

