/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.AutoCompleteAnalyzer;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerRegistryImpl;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneAutoCompleteHelpers;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.search.LuceneQueryParserFactory;
import com.apple.foundationdb.record.lucene.search.LuceneQueryParserFactoryProvider;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.FieldMaskingSpanQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneAutoCompleteQueryClause
extends LuceneQueryClause {
    public static final Logger LOGGER = LoggerFactory.getLogger(LuceneAutoCompleteQueryClause.class);
    private static final String NONSTOPWORD = "$nonstopword";
    @Nonnull
    private final String search;
    private final boolean isParameter;
    @Nonnull
    private final Set<String> fields;

    public LuceneAutoCompleteQueryClause(@Nonnull String search, boolean isParameter, @Nonnull Iterable<String> fields) {
        super(LuceneQueryType.AUTO_COMPLETE);
        this.search = search;
        this.isParameter = isParameter;
        this.fields = ImmutableSet.copyOf(fields);
    }

    @Nonnull
    public String getSearch() {
        return this.search;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    @Override
    public LuceneQueryClause.BoundQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
        Query finalQuery;
        String searchArgument = this.isParameter ? (String)Verify.verifyNotNull((Object)((String)context.getBinding(this.search))) : this.search;
        boolean phraseQueryNeeded = LuceneAutoCompleteHelpers.isPhraseSearch(searchArgument);
        String searchKey = LuceneAutoCompleteHelpers.searchKeyFromSearchArgument(searchArgument, phraseQueryNeeded);
        Map<String, LuceneIndexExpressions.DocumentFieldDerivation> fieldDerivationMap = LuceneIndexExpressions.getDocumentFieldDerivations(index, store.getRecordMetaData());
        LuceneAnalyzerCombinationProvider analyzerSelector = LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(index, LuceneAnalyzerType.FULL_TEXT, fieldDerivationMap);
        Map<String, PointsConfig> pointsConfigMap = LuceneIndexExpressions.constructPointConfigMap(store, index);
        LuceneQueryParserFactory parserFactory = LuceneQueryParserFactoryProvider.instance().getParserFactory();
        QueryParser parser = parserFactory.createMultiFieldQueryParser(this.fields.toArray(new String[0]), analyzerSelector.provideIndexAnalyzer().getAnalyzer(), pointsConfigMap);
        Query query = finalQuery = phraseQueryNeeded ? LuceneAutoCompleteQueryClause.buildQueryForPhraseMatching(parser, this.fields, searchKey) : LuceneAutoCompleteQueryClause.buildQueryForTermsMatching(analyzerSelector.provideIndexAnalyzer().getAnalyzer(), this.fields, searchKey);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(KeyValueLogMessage.build((String)"query for auto-complete", (Object[])new Object[0]).addKeyAndValue((Object)LogMessageKeys.INDEX_NAME, (Object)index.getName()).addKeyAndValue((Object)LogMessageKeys.QUERY, (Object)this.search.replace("\"", "\\\"")).addKeyAndValue((Object)"lucene_query", (Object)finalQuery).toString());
        }
        return this.toBoundQuery(finalQuery);
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        if (this.isParameter) {
            detailsBuilder.add((Object)"param: {{param}}");
            attributeMapBuilder.put((Object)"param", (Object)Attribute.gml((Object)this.search));
        } else {
            detailsBuilder.add((Object)"search: {{search}}");
            attributeMapBuilder.put((Object)"search", (Object)Attribute.gml((Object)this.search));
        }
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{this.search, this.isParameter});
    }

    public String toString() {
        return "AUTO COMPLETE " + (String)(this.isParameter ? "$" + this.search : this.search);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneAutoCompleteQueryClause that = (LuceneAutoCompleteQueryClause)o;
        if (this.isParameter != that.isParameter) {
            return false;
        }
        return this.search.equals(that.search);
    }

    public int hashCode() {
        int result = this.search.hashCode();
        result = 31 * result + (this.isParameter ? 1 : 0);
        return result;
    }

    @Nullable
    @VisibleForTesting
    static String getQueryTokens(Analyzer queryAnalyzer, String searchKey, @Nonnull List<String> tokens) {
        String prefixToken = null;
        try (TokenStream ts = queryAnalyzer.tokenStream("", (Reader)new StringReader(searchKey));){
            ts.reset();
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            String lastToken = null;
            int maxEndOffset = -1;
            while (ts.incrementToken()) {
                if (lastToken != null) {
                    tokens.add(lastToken);
                }
                if ((lastToken = termAtt.toString()) == null) continue;
                maxEndOffset = Math.max(maxEndOffset, offsetAtt.endOffset());
            }
            ts.end();
            if (lastToken != null) {
                if (maxEndOffset == offsetAtt.endOffset()) {
                    prefixToken = lastToken;
                } else {
                    tokens.add(lastToken);
                }
            }
        }
        catch (IOException iOE) {
            throw LuceneExceptions.toRecordCoreException("in-memory tokenization threw an IOException", iOE, new Object[0]);
        }
        return prefixToken;
    }

    @Nonnull
    public static Query buildPhraseQueryWithPrefix(@Nonnull QueryParser parser, @Nonnull Collection<String> fieldNames, @Nonnull String phrase, @Nullable String prefix, boolean useGapForPrefix) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (String field : fieldNames) {
            Query phraseQuery = parser.createPhraseQuery(field, phrase + " $nonstopword");
            if (!(phraseQuery instanceof TermQuery || phraseQuery instanceof PhraseQuery || phraseQuery instanceof MultiPhraseQuery)) {
                throw new RecordCoreException("Unsupported phrase type in auto-complete: " + phraseQuery.getClass().getName(), new Object[0]);
            }
            SpanNearQuery.Builder spanQuery = new SpanNearQuery.Builder(field, true).setSlop(0);
            if (phraseQuery instanceof PhraseQuery) {
                PhraseQuery pq = (PhraseQuery)phraseQuery;
                Term[] terms = pq.getTerms();
                LuceneAutoCompleteQueryClause.buildSpanQuery(spanQuery, terms, pq.getPositions(), useGapForPrefix);
            } else if (phraseQuery instanceof MultiPhraseQuery) {
                MultiPhraseQuery mpq = (MultiPhraseQuery)phraseQuery;
                Term[][] termArrays = mpq.getTermArrays();
                ArrayList<Term> terms = new ArrayList<Term>();
                for (Term[] t : termArrays) {
                    terms.add(t[t.length - 1]);
                }
                LuceneAutoCompleteQueryClause.buildSpanQuery(spanQuery, (Term[])terms.toArray(Term[]::new), mpq.getPositions(), useGapForPrefix);
            } else {
                spanQuery.addGap(1);
            }
            if (!useGapForPrefix && prefix != null) {
                SpanMultiTermQueryWrapper lastTokenQuery = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(new Term(field, prefix)));
                FieldMaskingSpanQuery fieldMask = new FieldMaskingSpanQuery((SpanQuery)lastTokenQuery, field);
                spanQuery.addClause((SpanQuery)fieldMask);
            }
            queryBuilder.add((Query)spanQuery.build(), BooleanClause.Occur.SHOULD);
        }
        queryBuilder.setMinimumNumberShouldMatch(1);
        return queryBuilder.build();
    }

    private static void buildSpanQuery(SpanNearQuery.Builder spanQuery, Term[] terms, int[] positions, boolean useGapForPrefix) {
        int prevPosition = -1;
        boolean endsWithGap = false;
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] - 1 > prevPosition) {
                spanQuery.addGap(positions[i] - 1 - prevPosition);
                endsWithGap = true;
            }
            if (i < positions.length - 1) {
                spanQuery.addClause((SpanQuery)new SpanTermQuery(terms[i]));
                endsWithGap = false;
            }
            prevPosition = positions[i];
        }
        if (useGapForPrefix && !endsWithGap) {
            spanQuery.addGap(1);
        }
    }

    @Nonnull
    public static Query buildQueryForPhraseMatching(@Nonnull QueryParser parser, @Nonnull Collection<String> fieldNames, @Nonnull String searchKey) {
        String lowercasedSearchKey = searchKey.toLowerCase(Locale.ROOT);
        ArrayList<String> tokens = new ArrayList<String>();
        String phrase = null;
        String prefix = LuceneAutoCompleteQueryClause.getQueryTokens((Analyzer)new AutoCompleteAnalyzer(), lowercasedSearchKey, tokens);
        if (!tokens.isEmpty()) {
            String lastToken = (String)tokens.get(tokens.size() - 1);
            int phraseEnd = lowercasedSearchKey.lastIndexOf(lastToken.toLowerCase(Locale.ROOT)) + lastToken.length();
            phrase = lowercasedSearchKey.substring(0, phraseEnd);
        }
        if (phrase == null && prefix == null) {
            throw new RecordCoreException("Invalid auto-complete input: empty key", new Object[0]);
        }
        if (phrase != null) {
            BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
            booleanQueryBuilder.add(LuceneAutoCompleteQueryClause.buildPhraseQueryWithPrefix(parser, fieldNames, phrase, prefix, false), BooleanClause.Occur.SHOULD);
            if (prefix != null && LuceneAutoCompleteQueryClause.isStopWord(parser, prefix)) {
                booleanQueryBuilder.add(LuceneAutoCompleteQueryClause.buildPhraseQueryWithPrefix(parser, fieldNames, phrase, prefix, true), BooleanClause.Occur.SHOULD);
            }
            booleanQueryBuilder.setMinimumNumberShouldMatch(1);
            return booleanQueryBuilder.build();
        }
        try {
            return parser.parse(prefix + "*");
        }
        catch (Exception ioe) {
            throw new RecordCoreException("Unable to parse search given for query", (Throwable)ioe);
        }
    }

    private static boolean isStopWord(@Nonnull QueryParser queryParser, @Nonnull String prefix) {
        try {
            Query query = queryParser.parse(prefix);
            if (query instanceof BooleanQuery) {
                return ((BooleanQuery)query).clauses().isEmpty();
            }
            return false;
        }
        catch (Exception ioe) {
            return false;
        }
    }

    @Nonnull
    private static Query buildQueryForTermsMatching(@Nonnull Analyzer queryAnalyzer, @Nonnull Collection<String> fieldNames, @Nonnull String searchKey) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixToken = LuceneAutoCompleteQueryClause.getQueryTokens(queryAnalyzer, searchKey, tokens);
        HashSet tokenSet = Sets.newHashSet(tokens);
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (String field : fieldNames) {
            BooleanQuery.Builder fieldQuery = new BooleanQuery.Builder();
            for (String token : tokenSet) {
                fieldQuery.add((Query)new TermQuery(new Term(field, token)), BooleanClause.Occur.MUST);
            }
            if (prefixToken != null) {
                fieldQuery.add((Query)new PrefixQuery(new Term(field, prefixToken)), BooleanClause.Occur.MUST);
            }
            queryBuilder.add((Query)fieldQuery.build(), BooleanClause.Occur.SHOULD);
        }
        queryBuilder.setMinimumNumberShouldMatch(1);
        return queryBuilder.build();
    }
}

