/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.idformat;

import com.apple.foundationdb.record.lucene.idformat.LuceneIndexKeySerializer;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitTest {
    @Test
    void emptyArray() {
        List actual = LuceneIndexKeySerializer.split((byte[])new byte[0], (int)9);
        this.assertEquals(Collections.emptyList(), actual);
    }

    @Test
    void shortArray() {
        List actual = LuceneIndexKeySerializer.split((byte[])new byte[]{1, 2, 3, 4, 5}, (int)9);
        this.assertEquals(Collections.singletonList(new byte[]{1, 2, 3, 4, 5, 0, 0, 0, 0}), actual);
    }

    @Test
    void exactLengthArray() {
        List actual = LuceneIndexKeySerializer.split((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, (int)9);
        this.assertEquals(Collections.singletonList(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}), actual);
    }

    @Test
    void longArray() {
        List actual = LuceneIndexKeySerializer.split((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, (int)9);
        this.assertEquals(List.of(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, new byte[]{10, 11, 12, 0, 0, 0, 0, 0, 0}), actual);
    }

    @Test
    void twiceExactArray() {
        List actual = LuceneIndexKeySerializer.split((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}, (int)9);
        this.assertEquals(List.of(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, new byte[]{10, 11, 12, 13, 14, 15, 16, 17, 18}), actual);
    }

    @Test
    void veryLongArray() {
        List actual = LuceneIndexKeySerializer.split((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}, (int)9);
        this.assertEquals(List.of(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, new byte[]{10, 11, 12, 13, 14, 15, 16, 17, 18}, new byte[]{19, 20, 0, 0, 0, 0, 0, 0, 0}), actual);
    }

    private void assertEquals(List<byte[]> expected, List<byte[]> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertArrayEquals((byte[])expected.get(i), (byte[])actual.get(i));
        }
    }
}

