/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.highlight;

import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LucenePlanner;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.test.TestKeySpace;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Tags(value={@Tag(value="RequiresFDB"), @Tag(value="Performance")})
@Timeout(value=8L, unit=TimeUnit.DAYS)
public class LuceneScaleTest
extends FDBRecordStoreTestBase {
    private static final Logger logger = LogManager.getLogger(LuceneScaleTest.class);
    private static final String RECORD_COUNT_COLUMN = "recordCount";
    private static final String OPERATION_MILLIS = "operationMillis";
    private static final String TOTAL_TEST_MILLIS = "totalTestMillis";
    private static final String INDEX_MAINTENANCE = "indexEnabled";
    static final List<String> CSV_COLUMNS = List.of("recordCount", "operationMillis", "totalTestMillis", "indexEnabled", "bytes_deleted_count", "bytes_fetched_count", "bytes_read_count", "bytes_written_count", "commit_count", "commit_micros", "commit_read_only_count", "commit_read_only_micros", "commits_count", "commits_micros", "deletes_count", "empty_scans_count", "fetches_count", "fetches_micros", "get_read_version_count", "get_read_version_micros", "get_record_range_raw_first_chunk_count", "get_scan_range_raw_first_chunk_count", "jni_calls_count", "lucene_delete_file_count", "lucene_fdb_read_block_count", "lucene_get_file_length_count", "lucene_get_increment_calls_count", "lucene_list_all_count", "lucene_load_file_cache_count", "lucene_merge_count", "lucene_read_block_count", "lucene_rename_file_count", "lucene_write_call_count", "lucene_write_file_reference_call_count", "lucene_write_file_reference_size_count", "lucene_write_size_count", "mutations_count", "open_context_count", "range_deletes_count", "range_fetches_count", "range_keyvalues_fetched_count", "range_query_direct_buffer_miss_count", "range_reads_count", "reads_count", "save_record_count", "writes_count", "lucene_delete_document_by_query_count", "lucene_delete_document_by_primary_key_count", "lucene_merge_count", "lucene_agile_commits_size_quota", "lucene_agile_commits_time_quota");
    private static final String INDEX_NAME = "text_and_number_idx";
    private static final Index INDEX = new Index("text_and_number_idx", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen")), (KeyExpression[])new KeyExpression[0]), "lucene", LuceneScaleTest.configIndexOptions());

    private static Map<String, String> configIndexOptions() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"primaryKeySegmentIndexEnabled", (Object)"true");
        return map.build();
    }

    public LuceneScaleTest() {
        super(TestKeySpace.getKeyspacePath((Object[])new Object[]{"record-test", "performance", "luceneScaleTest"}).add("run", (Object)"default"));
    }

    @BeforeAll
    public static void setup() {
        SynonymMapRegistryImpl.instance().getSynonymMap("EXPANDED_US_EN");
    }

    @BeforeEach
    protected void clear() {
        this.fdb.run(context -> {
            this.path.deleteAllData(context);
            return null;
        });
    }

    public void setupPlanner(@Nullable PlannableIndexTypes indexTypes) {
        if (this.isUseCascadesPlanner()) {
            this.planner = this.recordStore.getCascadesPlanner();
        } else {
            if (indexTypes == null) {
                indexTypes = new PlannableIndexTypes((Set)Sets.newHashSet((Object[])new String[]{"value", "version"}), (Set)Sets.newHashSet((Object[])new String[]{"rank", "time_window_leaderboard"}), (Set)Sets.newHashSet((Object[])new String[]{"text"}), (Set)Sets.newHashSet((Object[])new String[]{"lucene"}));
            }
            this.planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), indexTypes, this.recordStore.getTimer());
        }
    }

    @Test
    void updateProfile() {
        DataModel dataModel = new DataModel();
        dataModel.prep();
        int updatesPerContext = 10;
        int updateBatches = 1000;
        String recordCount = RECORD_COUNT_COLUMN;
        this.timer.reset();
        for (int j = 0; j < 1000; ++j) {
            dataModel.updateRecords(10);
        }
        Map keysAndValues = this.timer.getKeysAndValues();
        logger.info(KeyValueLogMessage.build((String)"Did updates", (Object[])new Object[0]).addKeysAndValues(keysAndValues).addKeyAndValue((Object)"updatesPerContext", (Object)10).addKeyAndValue((Object)"updateBatches", (Object)1000).addKeyAndValue((Object)RECORD_COUNT_COLUMN, (Object)dataModel.maxDocId).toString());
    }

    @Test
    void runPerfTest() throws IOException, ExecutionException, InterruptedException {
        DataModel dataModel = new DataModel();
        dataModel.prep();
        int updatesPerContext = 10;
        int operationCount = 10;
        long testStartMillis = System.currentTimeMillis();
        try (PrintStream updatesCsv = LuceneScaleTest.createCsv("updates", dataModel.continuing);
             PrintStream insertsCsv = LuceneScaleTest.createCsv("inserts", dataModel.continuing);
             PrintStream searchesCsv = LuceneScaleTest.createCsv("searches", dataModel.continuing);
             PrintStream mergeCsv = LuceneScaleTest.createCsv("merges", dataModel.continuing);){
            for (int i = 0; i < 1000; ++i) {
                int j;
                long startMillis;
                Set<Index> indexesRequireMerge;
                logger.info("Running loop " + i + " with " + dataModel.maxDocId + " records so far");
                if (Config.COMMANDS_TO_RUN.contains((Object)Command.IncreaseCount)) {
                    for (int i1 = 0; i1 < 90; ++i1) {
                        indexesRequireMerge = dataModel.saveNewRecord();
                        this.mergeIndexes(indexesRequireMerge, null, testStartMillis, dataModel);
                    }
                }
                if (Config.COMMANDS_TO_RUN.contains((Object)Command.Insert)) {
                    this.timer.reset();
                    startMillis = System.currentTimeMillis();
                    for (j = 0; j < 10; ++j) {
                        indexesRequireMerge = dataModel.saveNewRecord();
                        this.mergeIndexes(indexesRequireMerge, mergeCsv, testStartMillis, dataModel);
                    }
                    LuceneScaleTest.updateCsv("Did insert", dataModel, insertsCsv, startMillis, testStartMillis, Map.of(), this.timer);
                }
                if (Config.COMMANDS_TO_RUN.contains((Object)Command.Update)) {
                    this.timer.reset();
                    startMillis = System.currentTimeMillis();
                    for (j = 0; j < 10; ++j) {
                        indexesRequireMerge = dataModel.updateRecords(10);
                        this.mergeIndexes(indexesRequireMerge, mergeCsv, testStartMillis, dataModel);
                    }
                    LuceneScaleTest.updateCsv("Did updates", dataModel, updatesCsv, startMillis, testStartMillis, Map.of("updatesPerContext", 10, "updateBatches", 10), this.timer);
                }
                if (!Config.COMMANDS_TO_RUN.contains((Object)Command.Search)) continue;
                this.timer.reset();
                startMillis = System.currentTimeMillis();
                for (j = 0; j < 10; ++j) {
                    dataModel.search();
                }
                LuceneScaleTest.updateCsv("Did Search", dataModel, searchesCsv, startMillis, testStartMillis, Map.of(), this.timer);
                dataModel.updateSearchWords();
            }
        }
    }

    public FDBRecordContext openContext() {
        RecordLayerPropertyStorage.Builder props = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_MAX_SIZE, (Object)50.0);
        return super.openContext(props);
    }

    private void mergeIndexes(Set<Index> indexesRequireMerge, @Nullable PrintStream mergeCsv, long testStartMillis, DataModel dataModel) {
        long startMillis;
        if (indexesRequireMerge == null) {
            return;
        }
        if (ThreadLocalRandom.current().nextInt(1000) < 975) {
            return;
        }
        FDBStoreTimer mergeTimer = new FDBStoreTimer();
        try (FDBRecordContext context = this.openContext();){
            this.createOrOpenRecordStore(context, (RecordMetaDataProvider)this.recordStore.getRecordMetaData());
            startMillis = System.currentTimeMillis();
            for (Index index : indexesRequireMerge) {
                OnlineIndexer onlineIndexer = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().addTargetIndex(index).setRecordStore(this.recordStore)).setTimer(mergeTimer)).build();
                onlineIndexer.mergeIndex();
            }
        }
        if (mergeCsv != null) {
            LuceneScaleTest.updateCsv("Did merge", dataModel, mergeCsv, startMillis, testStartMillis, Map.of("indexCount", indexesRequireMerge), mergeTimer);
        }
    }

    private static void updateCsv(String logTtl, DataModel dataModel, PrintStream csvPrintStream, long startMillis, long testStartMillis, Map<?, ?> additionalKeysAndValues, FDBStoreTimer timer1) {
        Map keysAndValues = timer1.getKeysAndValues();
        logger.info(KeyValueLogMessage.build((String)logTtl, (Object[])new Object[0]).addKeysAndValues(keysAndValues).addKeysAndValues(additionalKeysAndValues).addKeyAndValue((Object)RECORD_COUNT_COLUMN, (Object)dataModel.maxDocId).toString());
        for (String key : CSV_COLUMNS) {
            if (Objects.equals(key, RECORD_COUNT_COLUMN)) {
                csvPrintStream.print(dataModel.maxDocId);
            } else if (Objects.equals(key, OPERATION_MILLIS)) {
                csvPrintStream.print(System.currentTimeMillis() - startMillis);
            } else if (Objects.equals(key, TOTAL_TEST_MILLIS)) {
                csvPrintStream.print(System.currentTimeMillis() - testStartMillis);
            } else if (Objects.equals(key, INDEX_MAINTENANCE)) {
                csvPrintStream.print((Object)Config.INDEX_MAINTENANCE);
            } else {
                csvPrintStream.print(keysAndValues.get(key));
            }
            csvPrintStream.print(",");
        }
        csvPrintStream.println();
    }

    private void dumpTimer(String title, DataModel dataModel, long startMillis, long testStartMillis, Map<String, Integer> extraKeysAndValues, FDBStoreTimer timer, String fullDump) throws FileNotFoundException {
        try (PrintStream out = LuceneScaleTest.createJson(fullDump);){
            out.println("{");
            this.printJsonPair(out, "title", title);
            this.printJsonPair(out, RECORD_COUNT_COLUMN, dataModel.maxDocId);
            this.printJsonPair(out, OPERATION_MILLIS, System.currentTimeMillis() - startMillis);
            this.printJsonPair(out, INDEX_MAINTENANCE, Config.INDEX_MAINTENANCE.name());
            extraKeysAndValues.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> this.printJsonPair(out, (String)entry.getKey(), (Number)entry.getValue()));
            Comparator<Map.Entry> sortByMetricType = Comparator.comparing(e -> {
                String[] split = ((String)e.getKey()).split("_");
                return split[split.length - 1];
            });
            Comparator<Map.Entry> sortByMetricTypeThenValue = sortByMetricType.thenComparing(e -> ((Number)e.getValue()).doubleValue());
            Comparator sortByName = Map.Entry.comparingByKey();
            timer.getKeysAndValues().entrySet().stream().sorted(sortByName).forEach(entry -> this.printJsonPair(out, (String)entry.getKey(), (Number)entry.getValue()));
            out.println("\"foo\": 0");
            out.println("}");
        }
    }

    private void printJsonPair(PrintStream out, String key, String value) {
        out.println("\"" + key + "\": \"" + value + "\",");
    }

    private void printJsonPair(PrintStream out, String key, Number value) {
        out.println("\"" + key + "\": " + String.valueOf(value) + ",");
    }

    @Nonnull
    private static PrintStream createJson(String name) throws FileNotFoundException {
        String filename = ".out/LuceneScaleTest.default." + name + ".json";
        return new PrintStream(new FileOutputStream(filename, false), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static PrintStream createCsv(String name, boolean append) throws FileNotFoundException {
        String filename = ".out/LuceneScaleTest.default." + name + ".csv";
        boolean writeHeader = !append || !new File(filename).exists();
        PrintStream printStream = new PrintStream(new FileOutputStream(filename, append), true);
        boolean success = false;
        try {
            if (writeHeader) {
                printStream.println(String.join((CharSequence)",", CSV_COLUMNS));
            }
            success = true;
        }
        finally {
            if (!success) {
                printStream.close();
            }
        }
        return printStream;
    }

    private static class Config {
        public static final int LOOP_COUNT = 1000;
        static final boolean USE_PRIMARY_KEY_SERIALIZATION = false;
        static final boolean USE_PRIMARY_KEY_SEGMENT_INDEX = true;
        static final boolean AUTOMERGE_DURING_COMMIT = false;
        static final boolean CLEAR_BEFORE_RUN = true;
        static final IndexMaintenance INDEX_MAINTENANCE = IndexMaintenance.Build;
        static final Set<Command> COMMANDS_TO_RUN = EnumSet.allOf(Command.class);
        static final String ISOLATION_ID = "default";
        static final int MERGE_PROBABLITY_OF_1000 = 25;
        static final double LUCENE_MERGE_MAX_SIZE = 50.0;

        private Config() {
        }
    }

    private class DataModel {
        int maxDocId = 0;
        Random random = new Random();
        private boolean continuing;
        private final List<String> searchWords = !this.maintainSearchWords() ? List.of() : new ArrayList<String>(20);
        private static final int SEARCH_WORD_COUNT = 20;
        private int lastSearchWordsUpdate = -10000;

        private DataModel() {
        }

        void prep() {
            switch (Config.INDEX_MAINTENANCE) {
                case Disable: {
                    this.disableIndex();
                    break;
                }
                case Rebuild: {
                    this.disableIndex();
                    this.buildIndex();
                    break;
                }
                case Build: {
                    this.buildIndex();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown enum: " + String.valueOf((Object)Config.INDEX_MAINTENANCE));
                }
            }
            if (this.maxDocId > 0) {
                this.updateSearchWords();
            }
        }

        private void disableIndex() {
            try (FDBRecordContext context = LuceneScaleTest.this.openContext();){
                FDBRecordStore store = this.openStore(context);
                this.maxDocId = (Integer)LuceneConcurrency.asyncToSync((StoreTimer.Wait)FDBStoreTimer.Waits.WAIT_LOAD_SYSTEM_KEY, (CompletableFuture)store.scanRecords(TupleRange.ALL, null, ScanProperties.FORWARD_SCAN).getCount(), (FDBRecordContext)context);
                this.continuing = this.maxDocId > 0;
                logger.info("Disabling index");
                store.markIndexDisabled(INDEX.getName());
                context.commit();
            }
        }

        private void buildIndex() {
            OnlineIndexer.Builder indexBuilder = null;
            try (FDBRecordContext context = LuceneScaleTest.this.openContext();){
                FDBRecordStore store = this.openStore(context);
                this.maxDocId = (Integer)LuceneConcurrency.asyncToSync((StoreTimer.Wait)FDBStoreTimer.Waits.WAIT_LOAD_SYSTEM_KEY, (CompletableFuture)store.scanRecords(TupleRange.ALL, null, ScanProperties.FORWARD_SCAN).getCount(), (FDBRecordContext)context);
                boolean bl = this.continuing = this.maxDocId > 0;
                if (!store.isIndexReadable(INDEX.getName())) {
                    indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(store)).addTargetIndex(INDEX.getName());
                }
                context.commit();
            }
            if (indexBuilder != null) {
                logger.info("Building index");
                try (OnlineIndexer indexer = indexBuilder.build();){
                    indexer.buildIndex();
                }
                logger.info("Done Building index");
            }
        }

        private void updateSearchWords() {
            if (!this.maintainSearchWords()) {
                return;
            }
            if (Math.floor((double)this.lastSearchWordsUpdate / 1000.0) >= Math.floor((double)this.maxDocId / 1000.0)) {
                return;
            }
            logger.info("Updating search words " + this.maxDocId);
            try (FDBRecordContext context = LuceneScaleTest.this.openContext();){
                FDBRecordStore store = this.openStore(context);
                int count = Math.min(20, this.maxDocId);
                for (int i = 0; i < count; ++i) {
                    String text = TestRecordsTextProto.ComplexDocument.newBuilder().mergeFrom(this.getRandomRecord(store)).getText();
                    String messageWord = this.getRandomWord(text);
                    this.searchWords.add(messageWord);
                }
            }
            this.lastSearchWordsUpdate = this.maxDocId;
        }

        private boolean maintainSearchWords() {
            return Config.COMMANDS_TO_RUN.contains((Object)Command.Search);
        }

        private String getRandomWord(String text) {
            String[] messageWords = text.split(" ");
            return messageWords[this.random.nextInt(messageWords.length)];
        }

        void saveNewRecords(int count) {
            for (int i = 0; i < count; ++i) {
                this.saveNewRecord();
            }
        }

        private FDBRecordStore openStore(FDBRecordContext context) {
            Pair<FDBRecordStore, QueryPlanner> res = LuceneIndexTestUtils.rebuildIndexMetaData(context, LuceneScaleTest.this.path, "ComplexDocument", INDEX, false);
            LuceneScaleTest.this.recordStore = (FDBRecordStore)res.getLeft();
            LuceneScaleTest.this.planner = (QueryPlanner)res.getRight();
            return LuceneScaleTest.this.recordStore;
        }

        Set<Index> saveNewRecord() {
            try (FDBRecordContext context = LuceneScaleTest.this.openContext();){
                FDBRecordStore store = this.openStore(context);
                store.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
                String text = LuceneIndexTestUtils.generateRandomWords(500)[1];
                store.saveRecord((Message)TestRecordsTextProto.ComplexDocument.newBuilder().setDocId((long)this.maxDocId).setText(text).setIsSeen(this.random.nextBoolean()).setGroup(1L).build());
                ++this.maxDocId;
                if (this.maintainSearchWords()) {
                    String messageWord;
                    if (this.searchWords.size() < 20) {
                        messageWord = this.getRandomWord(text);
                        this.searchWords.add(messageWord);
                    } else if (this.random.nextInt(100) == 0) {
                        messageWord = this.getRandomWord(text);
                        this.searchWords.set(this.random.nextInt(20), messageWord);
                    }
                }
                context.commit();
                Set set = store.getIndexDeferredMaintenanceControl().getMergeRequiredIndexes();
                return set;
            }
        }

        public Set<Index> updateRecords(int count) {
            try (FDBRecordContext context = LuceneScaleTest.this.openContext();){
                FDBRecordStore store = this.openStore(context);
                store.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
                for (int i = 0; i < count; ++i) {
                    TestRecordsTextProto.ComplexDocument.Builder builder;
                    builder.setIsSeen(!(builder = TestRecordsTextProto.ComplexDocument.newBuilder().mergeFrom(this.getRandomRecord(store))).getIsSeen());
                    store.saveRecord((Message)builder.build());
                }
                context.commit();
                Set set = store.getIndexDeferredMaintenanceControl().getMergeRequiredIndexes();
                return set;
            }
        }

        @Nonnull
        private Message getRandomRecord(FDBRecordStore store) {
            return store.loadRecord(Tuple.from((Object[])new Object[]{1, this.random.nextInt(this.maxDocId)})).getRecord();
        }

        public void search() throws ExecutionException, InterruptedException {
            LuceneScaleTest.this.setUseCascadesPlanner(false);
            try (FDBRecordContext context = LuceneScaleTest.this.openContext();){
                FDBRecordStore store = this.openStore(context);
                Assertions.assertTrue((boolean)this.maintainSearchWords());
                String searchWord = this.searchWords.get(this.random.nextInt(this.searchWords.size()));
                LuceneQueryComponent filter = new LuceneQueryComponent("text:" + searchWord, List.of("text"));
                RecordQuery query = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter((QueryComponent)filter).build();
                RecordQueryPlan plan = LuceneScaleTest.this.planner.plan(query);
                MatcherAssert.assertThat((Object)plan.getUsedIndexes(), (Matcher)Matchers.contains((Object[])new String[]{LuceneScaleTest.INDEX_NAME}));
                try (RecordCursor results = plan.execute(store);){
                    MatcherAssert.assertThat((Object)((Integer)results.getCount().get()), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                }
            }
        }
    }

    private static enum Command {
        IncreaseCount,
        Insert,
        Update,
        Search;

    }

    private static enum IndexMaintenance {
        Disable,
        Rebuild,
        Build;

    }
}

