/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.highlight;

import com.apple.foundationdb.record.lucene.AlphanumericCjkAnalyzer;
import com.apple.foundationdb.record.lucene.AlphanumericLengthFilterFactory;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import com.apple.foundationdb.record.lucene.RegistrySynonymGraphFilterFactory;
import com.apple.foundationdb.record.lucene.Utf8Chars;
import com.apple.foundationdb.record.lucene.highlight.HighlightedTerm;
import com.apple.foundationdb.record.lucene.highlight.LuceneHighlighting;
import com.apple.foundationdb.record.lucene.ngram.NgramAnalyzer;
import com.apple.foundationdb.record.lucene.search.LuceneQueryParserFactoryProvider;
import com.apple.foundationdb.record.lucene.synonym.SynonymAnalyzer;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.cjk.CJKWidthFilterFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilterFactory;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.UAX29URLEmailAnalyzer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizerFactory;
import org.apache.lucene.analysis.synonym.SynonymGraphFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class LuceneHighlighterTest {
    private static final String ROSE_BY_ANY_OTHER_NAME = "'Tis but thy name that is my enemy;\nThou art thyself, though not a Montague.\nWhat's Montague? It is nor hand, nor foot,\nNor arm, nor face, nor any other part\nBelonging to a man. O, be some other name!\nWhat's in a name? That which we call a rose\nBy any other name would smell as sweet;\nSo Romeo would, were he not Romeo call'd,\nRetain that dear perfection which he owes\nWithout that title. Romeo, doff thy name,\nAnd for that name which is no part of thee\nTake all myself.";
    private static final CharArraySet stopWords = EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;

    @BeforeAll
    public static void setup() {
        SynonymMapRegistryImpl.instance().getSynonymMap("EXPANDED_US_EN");
    }

    public static Stream<Arguments.ArgumentSet> analyzers() throws IOException {
        CustomAnalyzer acjkWithSynonyms = CustomAnalyzer.builder().withTokenizer(UAX29URLEmailTokenizerFactory.class, new HashMap<String, String>(Map.of("maxTokenLength", "30"))).addTokenFilter(CJKWidthFilterFactory.class, new String[0]).addTokenFilter(LowerCaseFilterFactory.class, new String[0]).addTokenFilter(ASCIIFoldingFilterFactory.class, new String[0]).addTokenFilter(AlphanumericLengthFilterFactory.class, new HashMap<String, String>(Map.of("min", "1", "max", "30"))).addTokenFilter(StopFilterFactory.class, new String[0]).addTokenFilter(RegistrySynonymGraphFilterFactory.class, new HashMap<String, String>(Map.of("synonyms", "EXPANDED_US_EN"))).build();
        UAX29URLEmailAnalyzer noStopWords = new UAX29URLEmailAnalyzer(CharArraySet.EMPTY_SET);
        noStopWords.setMaxTokenLength(30);
        AnalyzerSupplier standardAnalyzerSupplier = () -> LuceneAnalyzerWrapper.getStandardAnalyzerWrapper().getAnalyzer();
        AnalyzerSupplier acjkNoSynonymsSupplier = () -> new AlphanumericCjkAnalyzer(stopWords, 1, 30, true, null);
        Analyzer acjkNoSynonyms1 = acjkNoSynonymsSupplier.get();
        SynonymAnalyzer customSynonymAnalyzer = new SynonymAnalyzer(stopWords, "EXPANDED_US_EN", 30);
        Analyzer standardAnalyzer1 = standardAnalyzerSupplier.get();
        NgramAnalyzer ngramAnalyzer = new NgramAnalyzer(stopWords, 3, 30, false);
        return Stream.of(Arguments.argumentSet((String)"Standard", (Object[])new Object[]{standardAnalyzer1, standardAnalyzer1}), Arguments.argumentSet((String)"Synonym", (Object[])new Object[]{customSynonymAnalyzer, standardAnalyzerSupplier.get()}), Arguments.argumentSet((String)"Ngram", (Object[])new Object[]{standardAnalyzerSupplier.get(), ngramAnalyzer}), Arguments.argumentSet((String)"AlphaCjk-NoSynonyms", (Object[])new Object[]{acjkNoSynonyms1, acjkNoSynonyms1}), Arguments.argumentSet((String)"AlphaCjk-Synonyms", (Object[])new Object[]{acjkWithSynonyms, acjkNoSynonymsSupplier.get()}), Arguments.argumentSet((String)"Standard-noStopWords", (Object[])new Object[]{noStopWords, noStopWords}));
    }

    public static Stream<Arguments> specialCharacterAnalyzerCombinations() {
        return Utf8Chars.getUnusualTokenizableChars().flatMap(ch -> ((Stream)Assertions.assertDoesNotThrow(LuceneHighlighterTest::analyzers)).map(args -> {
            Object[] analyzerArgs = args.get();
            String name = args.getName();
            return Arguments.argumentSet((String)(name + ":" + ch), (Object[])new Object[]{analyzerArgs[0], analyzerArgs[1], ch, Integer.toHexString(ch.codePointAt(0))});
        }));
    }

    @MethodSource(value={"analyzers"})
    @ParameterizedTest
    void highlightsSimpleTextWithNoSnippets(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws IOException {
        String text = "Hello record layer";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:hello", -1);
        this.assertHighlightCorrect(new HighlightedTerm("text", text, new int[]{0}, new int[]{5}), result);
    }

    @MethodSource(value={"analyzers"})
    @ParameterizedTest
    void highlightsSynonyms(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws IOException {
        HighlightedTerm result;
        String text = "apple apple apple apple park apple apple";
        if (this.isSynonymAnalyzer(queryAnalyzer)) {
            result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:\"malus pumila park\"", -1);
            this.assertHighlightCorrect(new HighlightedTerm("text", text, new int[]{18, 24}, new int[]{23, 28}), result);
        }
        result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:\"apple park\"", -1);
        this.assertHighlightCorrect(new HighlightedTerm("text", text, new int[]{18, 24}, new int[]{23, 28}), result);
    }

    @MethodSource(value={"analyzers"})
    @ParameterizedTest
    void ngramHighlightsNgrams(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws IOException {
        Assumptions.assumeTrue((boolean)(indexAnalyzer instanceof NgramAnalyzer), (String)"Only care about Ngram analyzers");
        String text = "Hello record layer";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:hel", -1);
        this.assertHighlightCorrect(new HighlightedTerm("text", text, new int[]{0}, new int[]{5}), result);
        result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:cord", -1);
        this.assertHighlightCorrect(new HighlightedTerm("text", text, new int[]{6}, new int[]{12}), result);
    }

    @MethodSource(value={"analyzers"})
    @ParameterizedTest
    void highlightsSimpleTextWithSnippets(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws IOException {
        String text = "Good Morning From Apple News It?s Monday, July 11. Here?s what you need to know. ";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:appl*");
        String correctString = "Good Morning From Apple News It?s...";
        this.assertHighlightCorrect(new HighlightedTerm("text", correctString, new int[]{18}, new int[]{23}), result);
    }

    @MethodSource(value={"analyzers"})
    @ParameterizedTest
    void highlightsSimpleTextWithWildcardSnippetsInsideHtml(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws IOException {
        String link = "https://apple.news/AgZ7a_IT4TpKFF3kAyZsvUg";
        String text = "Good Morning From Apple News It?s Monday, July 11. Here?s what you need to know. Top Stories Former Trump adviser Steve Bannon agreed to testify to the January 6 committee after months of defying a congressional subpoena. The Washington Post " + link + "?";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:*appl*");
        String correctString = "Good Morning From Apple News It?s...The Washington Post " + link + "?";
        int maxTokenLength = this.getMaxTokenSize(indexAnalyzer);
        if (maxTokenLength < 0) {
            int[] starts = new int[]{18, 56};
            int[] ends = new int[]{23, 99};
            this.assertHighlightCorrect(new HighlightedTerm("text", correctString, starts, ends), result);
        } else {
            int[] starts = new int[]{18, 56};
            int[] ends = new int[]{23, Math.min(starts[1] + maxTokenLength, 99)};
            this.assertHighlightCorrect(new HighlightedTerm("text", correctString, starts, ends), result);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightTextWithMultipleTermMatches(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        HighlightedTerm expected;
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, ROSE_BY_ANY_OTHER_NAME, "text:name");
        if (this.isSynonymAnalyzer(queryAnalyzer)) {
            String correctString = "'Tis but thy name that is my...be some other name!\nWhat's in a name? That which we call a rose\nBy any other name would smell as..., doff thy name,\nAnd for that name which is no...";
            expected = new HighlightedTerm("text", correctString, new int[]{13, 45, 63, 83, 108, 141, 160}, new int[]{17, 49, 67, 87, 112, 145, 164});
        } else {
            String correctString = "'Tis but thy name that is my...be some other name!\nWhat's in a name? That which...By any other name would smell as..., doff thy name,\nAnd for that name which is no...";
            expected = new HighlightedTerm("text", correctString, new int[]{13, 45, 63, 95, 128, 147}, new int[]{17, 49, 67, 99, 132, 151});
        }
        this.assertHighlightCorrect(expected, result);
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightMultiplePrefixMatches(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, ROSE_BY_ANY_OTHER_NAME, "text:monta*");
        String correctString = "...though not a Montague.\nWhat's Montague? It is...";
        this.assertHighlightCorrect(new HighlightedTerm("text", correctString, new int[]{16, 33}, new int[]{24, 41}), result);
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightLinesUp(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        String text = "record record record record record record layer record record record record record record record record record record layer record record layer record record record record record record record record";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, "record record record record record record layer record record record record record record record record record record layer record record layer record record record record record record record record", "text:layer", 4);
        Assertions.assertEquals((int)3, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        for (int i = 0; i < result.getNumHighlights(); ++i) {
            int s = result.getHighlightStart(i);
            int e = result.getHighlightEnd(i);
            String highlightedText = result.getSummarizedText().substring(s, e);
            Assertions.assertEquals((Object)"layer", (Object)highlightedText, (String)"Incorrect highlight!");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightEmailsInTermQueries(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        String text = "Date: Thu, 10 Mar 2022 02:21:41 -0800 (PST)\nFrom: Jamison Gisele Lilia Bank Alerts <alerts@JamisonGiseleLilia.com>\nTo: jannette.rawhouser@demo.org\nBcc: bcc70@example.com\nMessage-ID: <659260106.1.1646907701959@localhost>\nSubject: much out.  And we 'll do it\nMIME-Version: 1.0\nContent-Type: multipart/mixed;\n        boundary=\"----=_Part_0_247087736.1646907701951\"\n\n------=_Part_0_247087736.1646907701951\nContent-Type: text/plain; charset=us-ascii\nContent-Transfer-Encoding: 7bit";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, "Date: Thu, 10 Mar 2022 02:21:41 -0800 (PST)\nFrom: Jamison Gisele Lilia Bank Alerts <alerts@JamisonGiseleLilia.com>\nTo: jannette.rawhouser@demo.org\nBcc: bcc70@example.com\nMessage-ID: <659260106.1.1646907701959@localhost>\nSubject: much out.  And we 'll do it\nMIME-Version: 1.0\nContent-Type: multipart/mixed;\n        boundary=\"----=_Part_0_247087736.1646907701951\"\n\n------=_Part_0_247087736.1646907701951\nContent-Type: text/plain; charset=us-ascii\nContent-Transfer-Encoding: 7bit", "text:bcc70@example.com", 4);
        Assertions.assertEquals((int)1, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        for (int i = 0; i < result.getNumHighlights(); ++i) {
            int s = result.getHighlightStart(i);
            int e = result.getHighlightEnd(i);
            Assertions.assertEquals((Object)"bcc70@example.com", (Object)result.getSummarizedText().substring(s, e), (String)"Incorrect highlight positions!");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightEmailsInPrefixQueries(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        int e;
        int s;
        int i;
        String text = "Date: Thu, 10 Mar 2022 02:21:41 -0800 (PST)\nFrom: Jamison Gisele Lilia Bank Alerts <alerts@JamisonGiseleLilia.com>\nTo: jannette.rawhouser@demo.org\nBcc: bcc70@example.com\nMessage-ID: <659260106.1.1646907701959@localhost>\nSubject: much out.  And we 'll do it\nMIME-Version: 1.0\nContent-Type: multipart/mixed;\n        boundary=\"----=_Part_0_247087736.1646907701951\"\n\n------=_Part_0_247087736.1646907701951\nContent-Type: text/plain; charset=us-ascii\nContent-Transfer-Encoding: 7bit";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, "Date: Thu, 10 Mar 2022 02:21:41 -0800 (PST)\nFrom: Jamison Gisele Lilia Bank Alerts <alerts@JamisonGiseleLilia.com>\nTo: jannette.rawhouser@demo.org\nBcc: bcc70@example.com\nMessage-ID: <659260106.1.1646907701959@localhost>\nSubject: much out.  And we 'll do it\nMIME-Version: 1.0\nContent-Type: multipart/mixed;\n        boundary=\"----=_Part_0_247087736.1646907701951\"\n\n------=_Part_0_247087736.1646907701951\nContent-Type: text/plain; charset=us-ascii\nContent-Transfer-Encoding: 7bit", "text:bcc70@example.com*", 4);
        Assertions.assertEquals((int)1, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        for (i = 0; i < result.getNumHighlights(); ++i) {
            s = result.getHighlightStart(i);
            e = result.getHighlightEnd(i);
            Assertions.assertEquals((Object)"bcc70@example.com", (Object)result.getSummarizedText().substring(s, e), (String)"Incorrect highlight positions!");
        }
        result = this.doHighlight(queryAnalyzer, indexAnalyzer, "Date: Thu, 10 Mar 2022 02:21:41 -0800 (PST)\nFrom: Jamison Gisele Lilia Bank Alerts <alerts@JamisonGiseleLilia.com>\nTo: jannette.rawhouser@demo.org\nBcc: bcc70@example.com\nMessage-ID: <659260106.1.1646907701959@localhost>\nSubject: much out.  And we 'll do it\nMIME-Version: 1.0\nContent-Type: multipart/mixed;\n        boundary=\"----=_Part_0_247087736.1646907701951\"\n\n------=_Part_0_247087736.1646907701951\nContent-Type: text/plain; charset=us-ascii\nContent-Transfer-Encoding: 7bit", "text:bcc70*", 4);
        Assertions.assertEquals((int)1, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        for (i = 0; i < result.getNumHighlights(); ++i) {
            s = result.getHighlightStart(i);
            e = result.getHighlightEnd(i);
            Assertions.assertEquals((Object)"bcc70@example.com", (Object)result.getSummarizedText().substring(s, e), (String)"Incorrect highlight positions!");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightEmailsInWildcardQueries(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        String text = "Date: Thu, 10 Mar 2022 02:21:41 -0800 (PST)\nFrom: Jamison Gisele Lilia Bank Alerts <alerts@JamisonGiseleLilia.com>\nTo: jannette.rawhouser@demo.org\nBcc: bcc70@example.com\nMessage-ID: <659260106.1.1646907701959@localhost>\nSubject: much out.  And we 'll do it\nMIME-Version: 1.0\nContent-Type: multipart/mixed;\n        boundary=\"----=_Part_0_247087736.1646907701951\"\n\n------=_Part_0_247087736.1646907701951\nContent-Type: text/plain; charset=us-ascii\nContent-Transfer-Encoding: 7bit";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, "Date: Thu, 10 Mar 2022 02:21:41 -0800 (PST)\nFrom: Jamison Gisele Lilia Bank Alerts <alerts@JamisonGiseleLilia.com>\nTo: jannette.rawhouser@demo.org\nBcc: bcc70@example.com\nMessage-ID: <659260106.1.1646907701959@localhost>\nSubject: much out.  And we 'll do it\nMIME-Version: 1.0\nContent-Type: multipart/mixed;\n        boundary=\"----=_Part_0_247087736.1646907701951\"\n\n------=_Part_0_247087736.1646907701951\nContent-Type: text/plain; charset=us-ascii\nContent-Transfer-Encoding: 7bit", "text:bcc70@e*e.com", 4);
        Assertions.assertEquals((int)1, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        for (int i = 0; i < result.getNumHighlights(); ++i) {
            int s = result.getHighlightStart(i);
            int e = result.getHighlightEnd(i);
            Assertions.assertEquals((Object)"bcc70@example.com", (Object)result.getSummarizedText().substring(s, e), (String)"Incorrect highlight positions!");
        }
    }

    @Nonnull
    private String specialCharacterText(@Nonnull String specialCharacter) {
        return "Do we match special characters like " + specialCharacter + " even when its mashed together like " + specialCharacter + "noSpaces?";
    }

    @MethodSource(value={"specialCharacterAnalyzerCombinations"})
    @ParameterizedTest
    void highlightsSpecialCharacterPrefixSearch(Analyzer queryAnalyzer, Analyzer indexAnalyzer, String specialCharacter) throws Exception {
        String text = this.specialCharacterText(specialCharacter);
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:" + specialCharacter.toLowerCase(Locale.ROOT) + "*", 1);
        Assertions.assertEquals((int)2, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        Assertions.assertEquals((Object)("...like " + specialCharacter + " even...like " + specialCharacter + "noSpaces?"), (Object)result.getSummarizedText(), (String)"Incorrect summary string!");
        for (int i = 0; i < result.getNumHighlights(); ++i) {
            int s = result.getHighlightStart(i);
            int e = result.getHighlightEnd(i);
            String subStr = result.getSummarizedText().substring(s, e);
            if (subStr.equals(specialCharacter)) continue;
            Assertions.assertEquals((Object)(specialCharacter + "noSpaces"), (Object)subStr, (String)"Incorrect Highlight positions!");
        }
    }

    @MethodSource(value={"specialCharacterAnalyzerCombinations"})
    @ParameterizedTest
    void highlightsSpecialCharacterTerm(Analyzer queryAnalyzer, Analyzer indexAnalyzer, String specialCharacter) throws Exception {
        String text = this.specialCharacterText(specialCharacter);
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:" + specialCharacter.toLowerCase(Locale.ROOT), 1);
        Assertions.assertEquals((int)1, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        Assertions.assertEquals((Object)("...like " + specialCharacter + " even..."), (Object)result.getSummarizedText(), (String)"Incorrect summary string!");
        for (int i = 0; i < result.getNumHighlights(); ++i) {
            int s = result.getHighlightStart(i);
            int e = result.getHighlightEnd(i);
            String subStr = result.getSummarizedText().substring(s, e);
            Assertions.assertEquals((Object)specialCharacter, (Object)subStr, (String)"Incorrect highlight value!");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightsReallyLongTermsTermQuery(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        String longTerm = "reallyLongTermWhichTakesHundredsAndHundredsNoIMeanItLotsAndLotsOfCharactersSoItWillExceedTheLimitOfOurConfigurations";
        String text = "This is a " + longTerm + "  I think, but maybe not also because things are weird";
        int maxTokenSize = this.getMaxTokenSize(queryAnalyzer);
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:" + longTerm.toLowerCase(Locale.ROOT).substring(0, maxTokenSize - 1) + "*", 1);
        Assertions.assertEquals((int)1, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        if (indexAnalyzer instanceof NgramAnalyzer) {
            Assertions.assertEquals((Object)("...a " + longTerm + "  ..."), (Object)result.getSummarizedText(), (String)"Incorrect summary string!");
            for (int i = 0; i < result.getNumHighlights(); ++i) {
                int s = result.getHighlightStart(i);
                int e = result.getHighlightEnd(i);
                String subStr = result.getSummarizedText().substring(s, e);
                Assertions.assertEquals((Object)longTerm, (Object)subStr, (String)"Incorrect highlight value!");
            }
        } else {
            Assertions.assertEquals((Object)("...a " + longTerm + "..."), (Object)result.getSummarizedText(), (String)"Incorrect summary string!");
            for (int i = 0; i < result.getNumHighlights(); ++i) {
                int s = result.getHighlightStart(i);
                int e = result.getHighlightEnd(i);
                String subStr = result.getSummarizedText().substring(s, e);
                Assertions.assertEquals((Object)longTerm.substring(0, maxTokenSize), (Object)subStr, (String)"Incorrect highlight value!");
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightsReallyLongTermsPartialPrefix(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        String longTerm = "reallyLongTermWhichTakesHundredsAndHundredsNoIMeanItLotsAndLotsOfCharactersSoItWillExceedTheLimitOfOurConfigurationsAndThenThereIsMoreTextAftewardsCauseIWantToBeEvenLongerAndLongerAndLongerAndDoIEverRunOutofEnglishWordsINeverDoIAmAnEducatedPersonIThinkMay";
        String text = "This is a " + longTerm + "  I think, but maybe not also because things are weird";
        String prefix = longTerm.substring(0, 25);
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:" + prefix.toLowerCase(Locale.ROOT) + "*", 1);
        Assertions.assertEquals((int)1, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        int maxTokenLength = this.getMaxTokenSize(indexAnalyzer);
        if (maxTokenLength < 0) {
            Assertions.assertEquals((Object)("...a " + longTerm + "  ..."), (Object)result.getSummarizedText(), (String)"Incorrect summary string!");
        } else {
            Assertions.assertEquals((Object)("...a " + longTerm + "..."), (Object)result.getSummarizedText(), (String)"Incorrect summary string!");
        }
        for (int i = 0; i < result.getNumHighlights(); ++i) {
            int s = result.getHighlightStart(i);
            int e = result.getHighlightEnd(i);
            String subStr = result.getSummarizedText().substring(s, e);
            if (maxTokenLength < 0) {
                Assertions.assertEquals((Object)longTerm, (Object)subStr, (String)"Incorrect highlight value!");
                continue;
            }
            Assertions.assertEquals((Object)longTerm.substring(0, maxTokenLength), (Object)subStr, (String)"Incorrect highlight value!");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightsReallyLongTermsFullPrefix(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        String longTerm = "reallyLongTermWhichTakesHundredsAndHundredsNoIMeanItLotsAndLotsOfCharactersSoItWillExceedTheLimitOfOurConfigurations";
        String text = "This is a " + longTerm + "  I think, but maybe not also because things are weird";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, text, "text:" + longTerm.toLowerCase(Locale.ROOT) + "*", 1);
        int maxTokenSize = this.getMaxTokenSize(indexAnalyzer);
        if (maxTokenSize > 0) {
            Assertions.assertEquals((int)0, (int)result.getNumHighlights(), (String)"Did not return empty for limited analyzers!");
        } else {
            Assertions.assertEquals((int)1, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
            Assertions.assertEquals((Object)("...a " + longTerm + "  ..."), (Object)result.getSummarizedText(), (String)"Incorrect summary string!");
            for (int i = 0; i < result.getNumHighlights(); ++i) {
                int s = result.getHighlightStart(i);
                int e = result.getHighlightEnd(i);
                String subStr = result.getSummarizedText().substring(s, e);
                Assertions.assertEquals((Object)longTerm, (Object)subStr, (String)"Incorrect highlight value!");
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"analyzers"})
    void highlightsCjkQueryTerms(Analyzer queryAnalyzer, Analyzer indexAnalyzer) throws Exception {
        String input = "water\u6c34\u6c34\ubb3c-of\u7684\u306e\uc758\u3002house\u5c4b\u5bb6\uc9d1\nyou\u4f60\u541b\ub108";
        HighlightedTerm result = this.doHighlight(queryAnalyzer, indexAnalyzer, input, "text:\u5bb6", 1);
        Assertions.assertEquals((int)1, (int)result.getNumHighlights(), (String)"Incorrect number of highlights!");
        Assertions.assertEquals((Object)"...house\u5c4b\u5bb6\uc9d1\n...", (Object)result.getSummarizedText(), (String)"Incorrect summary string!");
        for (int i = 0; i < result.getNumHighlights(); ++i) {
            int s = result.getHighlightStart(i);
            int e = result.getHighlightEnd(i);
            String subStr = result.getSummarizedText().substring(s, e);
            Assertions.assertEquals((Object)"\u5bb6", (Object)subStr, (String)"Incorrect highlight value!");
        }
    }

    private HighlightedTerm doHighlight(Analyzer queryAnalyzer, Analyzer indexAnalyzer, String text, String query) throws IOException {
        return this.doHighlight(queryAnalyzer, indexAnalyzer, text, query, 3);
    }

    private HighlightedTerm doHighlight(Analyzer queryAnalyzer, Analyzer indexAnalyzer, String text, String queryString, int snippetSize) throws IOException {
        UnifiedHighlighter highlighter = LuceneHighlighting.makeHighlighter((String)"text", (Analyzer)indexAnalyzer, (int)snippetSize);
        QueryParser queryParser = LuceneQueryParserFactoryProvider.instance().getParserFactory().createMultiFieldQueryParser(new String[]{"text"}, queryAnalyzer, Collections.emptyMap());
        queryParser.setAllowLeadingWildcard(true);
        try {
            Query query = queryParser.parse(queryString);
            BooleanQuery bq = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).build();
            Object result = highlighter.highlightWithoutSearcher("text", (Query)bq, text, 100);
            Assertions.assertTrue((boolean)(result instanceof HighlightedTerm), (String)"Did not return a string!");
            return (HighlightedTerm)result;
        }
        catch (ParseException e) {
            Assertions.fail((String)"Failed to parse Lucene query");
            return null;
        }
    }

    private void assertHighlightCorrect(HighlightedTerm expected, HighlightedTerm actual) {
        Assertions.assertEquals((Object)expected.getSummarizedText(), (Object)actual.getSummarizedText(), (String)"Incorrect snippet result!");
        Assertions.assertEquals((int)expected.getNumHighlights(), (int)actual.getNumHighlights(), (String)"Incorrect number of highlights found!");
        for (int i = 0; i < expected.getNumHighlights(); ++i) {
            Assertions.assertEquals((int)expected.getHighlightStart(i), (int)actual.getHighlightStart(i), (String)"Incorrect highlight start!");
            Assertions.assertEquals((int)expected.getHighlightEnd(i), (int)actual.getHighlightEnd(i), (String)"Incorrect highlight end!");
        }
    }

    private int getMaxTokenSize(Analyzer analyzer) {
        CustomAnalyzer ca;
        TokenizerFactory tokenizerFactory;
        String mtStr;
        int maxTokenLength = -1;
        if (analyzer instanceof StandardAnalyzer) {
            maxTokenLength = ((StandardAnalyzer)analyzer).getMaxTokenLength();
        } else if (analyzer instanceof UAX29URLEmailAnalyzer) {
            maxTokenLength = ((UAX29URLEmailAnalyzer)analyzer).getMaxTokenLength();
        } else if (analyzer instanceof AlphanumericCjkAnalyzer) {
            maxTokenLength = ((AlphanumericCjkAnalyzer)analyzer).getMaxTokenLength();
        } else if (analyzer instanceof SynonymAnalyzer) {
            maxTokenLength = ((SynonymAnalyzer)analyzer).getMaxTokenLength();
        } else if (analyzer instanceof CustomAnalyzer && (mtStr = (String)(tokenizerFactory = (ca = (CustomAnalyzer)analyzer).getTokenizerFactory()).getOriginalArgs().get("maxTokenLength")) != null) {
            maxTokenLength = Integer.parseInt(mtStr);
        }
        return maxTokenLength;
    }

    private boolean isSynonymAnalyzer(Analyzer analyzer) {
        if (analyzer instanceof SynonymAnalyzer) {
            return true;
        }
        if (analyzer instanceof CustomAnalyzer) {
            CustomAnalyzer ca = (CustomAnalyzer)analyzer;
            List tokenFilterFactories = ca.getTokenFilterFactories();
            for (TokenFilterFactory tff : tokenFilterFactories) {
                if (!(tff instanceof SynonymGraphFilterFactory) && !(tff instanceof RegistrySynonymGraphFilterFactory)) continue;
                return true;
            }
        }
        return false;
    }

    private static interface AnalyzerSupplier {
        public Analyzer get() throws IOException;
    }
}

