/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.directory.EmptyIndexInput;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryBaseTest;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.apple.foundationdb.record.lucene.directory.LuceneSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.lucene.store.IndexInput;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Tag(value="RequiresFDB")
public class FDBDirectoryTest
extends FDBDirectoryBaseTest {
    @Test
    public void testDirectoryCreate() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.directory, (String)"directory should not be null");
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.subspace, (Object)this.directory.getSubspace());
    }

    @Test
    public void testGetIncrement() throws IOException {
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.directory.getIncrement());
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)this.directory.getIncrement());
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_GET_INCREMENT_CALLS, 2);
        this.directory.getCallerContext().commit();
        try (FDBRecordContext context = this.fdb.openContext();){
            this.directory = new FDBDirectory(this.subspace, context, null);
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)this.directory.getIncrement());
        }
    }

    @Test
    public void testConcurrentGetIncrement() throws IOException {
        int threads = 50;
        ArrayList<CompletableFuture<Long>> futures = new ArrayList<CompletableFuture<Long>>(50);
        for (int i = 0; i < 50; ++i) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    return this.directory.getIncrement();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, this.directory.getCallerContext().getExecutor()));
        }
        List values = (List)AsyncUtil.getAll(futures).join();
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.containsInAnyOrder((Collection)LongStream.range(1L, 51L).mapToObj(Matchers::equalTo).collect(Collectors.toList())));
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_GET_INCREMENT_CALLS, 50);
        this.assertMetricCountAtMost((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_GET_INCREMENT, 50);
        this.directory.getCallerContext().commit();
        try (FDBRecordContext context = this.fdb.openContext();){
            this.directory = new FDBDirectory(this.subspace, context, null);
            org.junit.jupiter.api.Assertions.assertEquals((long)51L, (long)this.directory.getIncrement());
        }
    }

    @Test
    public void testWriteGetLuceneFileReference() {
        FDBLuceneFileReference luceneFileReference = this.directory.getFDBLuceneFileReference("NonExist");
        org.junit.jupiter.api.Assertions.assertNull((Object)luceneFileReference);
        String luceneReference1 = "luceneReference1";
        FDBLuceneFileReference fileReference = new FDBLuceneFileReference(1L, 10L, 10L, 10L);
        this.directory.writeFDBLuceneFileReference(luceneReference1, fileReference);
        FDBLuceneFileReference actual = this.directory.getFDBLuceneFileReference(luceneReference1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)actual, (String)"file reference should exist");
        org.junit.jupiter.api.Assertions.assertEquals((Object)actual, (Object)fileReference);
    }

    @Test
    public void testWriteLuceneFileReference() {
        FDBLuceneFileReference reference1 = new FDBLuceneFileReference(2L, 1L, 1L, 1L);
        this.directory.writeFDBLuceneFileReference("test1", reference1);
        FDBLuceneFileReference reference2 = new FDBLuceneFileReference(3L, 1L, 1L, 1L);
        this.directory.writeFDBLuceneFileReference("test1", reference2);
        FDBLuceneFileReference luceneFileReference = this.directory.getFDBLuceneFileReference("test1");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)luceneFileReference, (String)"fileReference should exist");
        LuceneSerializer serializer = this.directory.getSerializer();
        this.assertCorrectMetricSize((StoreTimer.SizeEvent)LuceneEvents.SizeEvents.LUCENE_WRITE_FILE_REFERENCE, 2, serializer.encode(reference1.getBytes()).length + serializer.encode(reference2.getBytes()).length);
    }

    @Test
    public void testMissingSeek() {
        CompletableFuture seekFuture = this.directory.readBlock((IndexInput)new EmptyIndexInput("Test Empty"), "testDescription", this.directory.getFDBLuceneFileReferenceAsync("testReference"), 1);
        FDBRecordContext context = this.directory.getCallerContext();
        org.junit.jupiter.api.Assertions.assertThrows(RecordCoreArgumentException.class, () -> LuceneConcurrency.asyncToSync((StoreTimer.Wait)LuceneEvents.Waits.WAIT_LUCENE_GET_DATA_BLOCK, (CompletableFuture)seekFuture, (FDBRecordContext)context));
    }

    @Test
    public void testWriteSeekData() throws Exception {
        this.directory.writeFDBLuceneFileReference("testReference1", new FDBLuceneFileReference(1L, 1L, 1L, 1L));
        EmptyIndexInput emptyInput = new EmptyIndexInput("Empty Input");
        org.junit.jupiter.api.Assertions.assertNull(this.directory.readBlock((IndexInput)emptyInput, "testReference1", this.directory.getFDBLuceneFileReferenceAsync("testReference1"), 1).get());
        this.directory.writeFDBLuceneFileReference("testReference2", new FDBLuceneFileReference(2L, 1L, 1L, 200L));
        byte[] data = "test string for write".getBytes();
        this.directory.writeData(2L, 1, data);
        org.junit.jupiter.api.Assertions.assertNotNull(this.directory.readBlock((IndexInput)emptyInput, "testReference2", this.directory.getFDBLuceneFileReferenceAsync("testReference2"), 1).get(), (String)"seek data should exist");
        this.directory.getCallerContext().commit();
        this.assertCorrectMetricSize((StoreTimer.SizeEvent)LuceneEvents.SizeEvents.LUCENE_WRITE, 1, this.directory.getSerializer().encode(data).length);
    }

    @Test
    public void testListAll() throws IOException {
        org.junit.jupiter.api.Assertions.assertEquals((int)this.directory.listAll().length, (int)0);
        this.directory.writeFDBLuceneFileReference("test1", new FDBLuceneFileReference(1L, 1L, 1L, 1L));
        this.directory.writeFDBLuceneFileReference("test2", new FDBLuceneFileReference(2L, 1L, 1L, 1L));
        this.directory.writeFDBLuceneFileReference("test3", new FDBLuceneFileReference(3L, 1L, 1L, 1L));
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])new String[]{"test1", "test2", "test3"}, (Object[])this.directory.listAll());
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LIST_ALL, 2);
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LOAD_FILE_CACHE, 1);
        this.directory.getCallerContext().ensureActive().cancel();
        FDBStoreTimer timer = new FDBStoreTimer();
        try (FDBRecordContext context = this.fdb.openContext(null, timer);){
            this.directory = new FDBDirectory(this.subspace, context, null);
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])new String[0], (Object[])this.directory.listAll());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LIST_ALL));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LOAD_FILE_CACHE));
        }
    }

    @Test
    public void testDeleteData() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFileException.class, () -> this.directory.deleteFile("NonExist"));
        FDBLuceneFileReference reference1 = new FDBLuceneFileReference(1L, 1L, 1L, 1L);
        this.directory.writeFDBLuceneFileReference("test1", reference1);
        this.directory.deleteFile("test1");
        org.junit.jupiter.api.Assertions.assertEquals((int)this.directory.listAll().length, (int)0);
        this.assertMetricCountAtMost((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_DELETE_FILE, 2);
    }

    @Test
    public void testFileLength() throws Exception {
        long expectedSize = 20L;
        FDBLuceneFileReference reference1 = new FDBLuceneFileReference(1L, expectedSize, expectedSize, 1024L);
        this.directory.writeFDBLuceneFileReference("test1", reference1);
        long fileSize = this.directory.fileLength("test1");
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedSize, (long)fileSize);
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_GET_FILE_LENGTH, 1);
        this.directory.getCallerContext().commit();
        FDBStoreTimer timer = new FDBStoreTimer();
        try (FDBRecordContext context = this.fdb.openContext(null, timer);){
            this.directory = new FDBDirectory(this.subspace, context, null);
            long fileSize2 = this.directory.fileLength("test1");
            org.junit.jupiter.api.Assertions.assertEquals((long)expectedSize, (long)fileSize2);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_GET_FILE_LENGTH));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_FILE_LENGTH));
        }
    }

    static Stream<Arguments> testFileLengthNonExistent() {
        return Stream.of("nonExist", "nonExistentEntries.cfe", "nonExistentSegmentInfo.si").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest(name="testFileLengthNonExistent[fileName={0}]")
    @MethodSource
    public void testFileLengthNonExistent(String fileName) {
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFileException.class, () -> this.directory.fileLength(fileName));
    }

    @Test
    public void testRename() {
        IOException ioException = (IOException)org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> this.directory.rename("NoExist", "newName"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(ioException.getCause() instanceof RecordCoreArgumentException));
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_RENAME_FILE, 1);
    }

    private void assertCorrectMetricCount(StoreTimer.Event metric, int expectedValue) {
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedValue, (int)this.timer.getCount(metric), () -> "Incorrect call count for metric " + String.valueOf(metric));
    }

    private void assertCorrectMetricSize(StoreTimer.SizeEvent metric, int expectedNumber, long expectedCumulativeBytes) {
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedNumber, (int)this.timer.getCount((StoreTimer.Event)metric), () -> "Incorrect call count for metric " + String.valueOf(metric));
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedCumulativeBytes, (long)this.timer.getSize(metric), () -> "Incorrect size for metric " + String.valueOf(metric));
    }

    private void assertMetricCountAtMost(StoreTimer.Event metric, int maximumValue) {
        MatcherAssert.assertThat((String)("Metric " + String.valueOf(metric) + " should be called at most " + maximumValue + " times"), (Object)this.timer.getCount(metric), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(maximumValue)));
    }

    @Test
    void testDataBlocksProperlyCleared() throws Exception {
        long fileId = 1L;
        FDBLuceneFileReference reference = new FDBLuceneFileReference(fileId, 100L, 100L, 1024L);
        String fileName = "test_file.dat";
        this.directory.writeFDBLuceneFileReference(fileName, reference);
        byte[] testData1 = "test data block 1".getBytes();
        byte[] testData2 = "test data block 2".getBytes();
        this.directory.writeData(fileId, 1, testData1);
        this.directory.writeData(fileId, 2, testData2);
        EmptyIndexInput emptyInput = new EmptyIndexInput("Test");
        byte[] block1 = (byte[])this.directory.readBlock((IndexInput)emptyInput, fileName, this.directory.getFDBLuceneFileReferenceAsync(fileName), 1).join();
        byte[] block2 = (byte[])this.directory.readBlock((IndexInput)emptyInput, fileName, this.directory.getFDBLuceneFileReferenceAsync(fileName), 2).join();
        Assertions.assertThat((byte[])block1).isNotEmpty();
        Assertions.assertThat((byte[])block2).isNotEmpty();
        this.directory.deleteFile(fileName);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.directory.listAll().length);
        List subspaceKeys = (List)this.context.ensureActive().getRange(this.directory.getSubspace().range()).asList().join();
        Assertions.assertThat((List)subspaceKeys).isEmpty();
    }

    @Test
    void testNoBlockLeaksWithMultipleFiles() throws Exception {
        long fileId1 = 100L;
        long fileId2 = 200L;
        FDBLuceneFileReference ref1 = new FDBLuceneFileReference(fileId1, 50L, 50L, 512L);
        FDBLuceneFileReference ref2 = new FDBLuceneFileReference(fileId2, 75L, 75L, 1024L);
        String fileName1 = "file1.dat";
        String fileName2 = "file2.dat";
        this.directory.writeFDBLuceneFileReference(fileName1, ref1);
        this.directory.writeFDBLuceneFileReference(fileName2, ref2);
        byte[] data1 = "data for file 1".getBytes();
        byte[] data2 = "data for file 2".getBytes();
        this.directory.writeData(fileId1, 1, data1);
        this.directory.writeData(fileId2, 1, data2);
        int keysPerFile = 2;
        List initialKeys = (List)this.context.ensureActive().getRange(this.directory.getSubspace().range()).asList().join();
        Assertions.assertThat((List)initialKeys).hasSize(4);
        this.directory.deleteFile(fileName1);
        List afterDeleteKeys = (List)this.context.ensureActive().getRange(this.directory.getSubspace().range()).asList().join();
        Assertions.assertThat((List)afterDeleteKeys).hasSize(2);
        this.directory.deleteFile(fileName2);
        List finalKeys = (List)this.context.ensureActive().getRange(this.directory.getSubspace().range()).asList().join();
        Assertions.assertThat((List)finalKeys).isEmpty();
    }
}

