/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedCodec;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedCompoundFormat;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;

public class TestingCodec
extends Codec {
    private final LuceneOptimizedCodec underlying = LuceneOptimizedCodec.CODEC;
    private static boolean disableLaziness;
    private static boolean disableLazinessForLiveDocs;
    private static boolean allowRandomCompoundFiles;

    public TestingCodec() {
        super("RLT");
    }

    public static void disableLaziness() {
        disableLaziness = true;
    }

    public static void disableLazinessForLiveDocs() {
        disableLazinessForLiveDocs = true;
    }

    public static void allowRandomCompoundFiles() {
        allowRandomCompoundFiles = true;
    }

    public static void reset() {
        disableLaziness = false;
        disableLazinessForLiveDocs = false;
        allowRandomCompoundFiles = false;
    }

    public PostingsFormat postingsFormat() {
        return this.underlying.postingsFormat();
    }

    public DocValuesFormat docValuesFormat() {
        final DocValuesFormat underlyingDocValuesFormat = this.underlying.docValuesFormat();
        if (disableLaziness) {
            return new DocValuesFormat(underlyingDocValuesFormat.getName()){

                public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
                    return underlyingDocValuesFormat.fieldsConsumer(state);
                }

                public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
                    DocValuesProducer underlyingProducer = underlyingDocValuesFormat.fieldsProducer(state);
                    underlyingProducer.ramBytesUsed();
                    return underlyingProducer;
                }
            };
        }
        return underlyingDocValuesFormat;
    }

    public StoredFieldsFormat storedFieldsFormat() {
        final StoredFieldsFormat storedFieldsFormat = this.underlying.storedFieldsFormat();
        if (disableLaziness) {
            return new StoredFieldsFormat(){

                public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
                    StoredFieldsReader storedFieldsReader = storedFieldsFormat.fieldsReader(directory, si, fn, context);
                    storedFieldsReader.ramBytesUsed();
                    return storedFieldsReader;
                }

                public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
                    return storedFieldsFormat.fieldsWriter(directory, si, context);
                }
            };
        }
        return storedFieldsFormat;
    }

    public TermVectorsFormat termVectorsFormat() {
        return this.underlying.termVectorsFormat();
    }

    public FieldInfosFormat fieldInfosFormat() {
        return this.underlying.fieldInfosFormat();
    }

    public SegmentInfoFormat segmentInfoFormat() {
        return this.underlying.segmentInfoFormat();
    }

    public NormsFormat normsFormat() {
        return this.underlying.normsFormat();
    }

    public LiveDocsFormat liveDocsFormat() {
        final LiveDocsFormat liveDocsFormat = this.underlying.liveDocsFormat();
        if (disableLazinessForLiveDocs) {
            return new LiveDocsFormat(){

                public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
                    Bits bits = liveDocsFormat.readLiveDocs(dir, info, context);
                    try {
                        bits.length();
                    }
                    catch (UncheckedIOException e) {
                        throw e.getCause();
                    }
                    return bits;
                }

                public void writeLiveDocs(Bits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
                    liveDocsFormat.writeLiveDocs(bits, dir, info, newDelCount, context);
                }

                public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
                    liveDocsFormat.files(info, files);
                }
            };
        }
        return liveDocsFormat;
    }

    public CompoundFormat compoundFormat() {
        if (allowRandomCompoundFiles) {
            return new LuceneOptimizedCompoundFormat(((LuceneOptimizedCompoundFormat)this.underlying.compoundFormat()).underlying){

                protected void copyFieldInfosId(Directory dir, Set<String> filesForAfter, String entriesFile) throws IOException {
                    Optional<String> fieldInfosName = filesForAfter.stream().filter(FDBDirectory::isFieldInfoFile).findFirst();
                    if (fieldInfosName.isPresent()) {
                        super.copyFieldInfosId(dir, filesForAfter, entriesFile);
                    }
                }

                protected void validateFileCounts(Set<String> files, int fieldInfos, int storedFields) {
                }
            };
        }
        return this.underlying.compoundFormat();
    }

    public PointsFormat pointsFormat() {
        return this.underlying.pointsFormat();
    }
}

